<?php

class Admin extends Controller {

	function Admin()
	{
	     
              parent::Controller();
		if(!$this->session->userdata('logged_in'))
		{
		   $tempurl = explode("/index.php/", $_SERVER['PHP_SELF']);
                   redirect("login?ref=".$tempurl[1]);
		}
		
		// if user is an installer, redirect them to an error page if
		// they're trying to do something they do have permissions to do
		if($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y')
		{
			$method = $this->router->method;
			$protected = array("delete_job");
			if(in_array($method,$protected))
			{
				redirect("admin/error?e=permissions");
			}
		}
                $this->load->helper(array('form', 'url'));
	}
	
	function index()
	{
		$data = array();
		
		$this->load->helper("date");
		
		$prefs = array (
			'start_day'    => 'sunday',
			'month_type'   => 'long',
			'day_type'     => 'short'
		);
		
		if(@$year=='') {$year = date("Y");}
		if(@$month=='') {$month = date("m");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$data['year'] = $year;
		$data['month'] = $month;
		
		// daily job limit
		$daily_limit = $this->db->get("job_limit")->row_array();
		$daily_limit = $daily_limit['limit'];
		$jobs = array();
		// get jobs for the current month
		$j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE DATE_FORMAT(jobs.job_date,'%Y-%m') = '".$year."-".$month."' ORDER BY jobs.job_date ASC")->result_array();
		foreach($j as $key => $value)
		{
			$jobs[date("j", strtotime($value['job_date']))][] = $value;
		}
		$days_count = days_in_month($month,$year);
		
		// grab service calls for the current month
		$sc = $this->db->query("SELECT service_calls.*,colors.hex, users.custom_hex, users.id as user_id FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id WHERE DATE_FORMAT(`date`,'%Y-%m') = '".$year."-".$month."' GROUP BY DATE_FORMAT(`date`,'%Y-%m-%d')")->result_array();
		// loop through them and assign their days as key values to make them easier to access when setup the calendar values
		$service_calls = array();
		$has_service_calls = array();
                $data['dates'] = null;
		foreach($sc as $key => $value)
		{
			if($value['job_count'] == '')
			{
				$has_service_calls[date("j",strtotime($value['date']))] = true;
			}
			$service_calls[date("j",strtotime($value['date']))] = $value['job_count'];
		}
		
		for($i=0; $i<($days_count + 1); $i++)
		{
			if(array_key_exists($i,$jobs) or array_key_exists($i,$service_calls))
			{
				if(array_key_exists($i,$service_calls))
				{
					$service_call_count = $service_calls[$i];
				}
				else
				{
					$service_call_count = 0;
				}
				
				if($this->session->userdata("role") == 'admin')
				{
					if(array_key_exists($i,$jobs))
					{
						if($jobs[$i][0]['hex'] == '')
						{
							$jobs[$i][0]['hex'] = '7DBB4C';
						}
						if($jobs[$i][0]['custom_hex'] != '') {
							$color = $jobs[$i][0]['custom_hex'];
						} else {
							$color = $jobs[$i][0]['hex'];
						}
						$data['dates'][$i] = '<div style="background:#'.$color.';" class="">';
					}
					else
					{
						if(array_key_exists($i,$service_calls))
						{
							$data['dates'][$i] = '<div class="">';
						}
					}
				}
				else
				{
					if(array_key_exists($i,$jobs))
					{
						// determine if user has any jobs on the current day
						$has_job_on_day = false;
						foreach($jobs[$i] as $day_job)
						{
							if($day_job['user_id'] == $this->session->userdata("user_id"))
							{
								$has_job_on_day = true;
							}
						}
						if ($has_job_on_day === true) {
							$data['dates'][$i] = '<div style="background:#'.$this->session->userdata("hex_color").';" class="">';
						} else {
							$data['dates'][$i] = '<div style="background:#7DBB4C;" class="">';
						}
					}
					else
					{
						if(array_key_exists($i,$service_calls))
						{
							$data['dates'][$i] = '<div class="">';
						}
					}
				}
				
				$day_job_count = max(@$jobs[$i][0]['job_count'],@$service_call_count);
				
				if($day_job_count < 1)
				{
					$day_job_count = 0;
				}
				$data['dates'][$i] .= '<a href="/ajax/preview_day/'.$year.'/'.$month.'/{day}" class="facebox day-view-url">
					<div class="job-count-home">';
				if($day_job_count < 2)
				{
					if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
					{
						$data['dates'][$i] .= '<a href="/ajax/preview_day/'.$year.'/'.$month.'/'.sprintf("%02d",$i).'" class="facebox day-view-url">';
					}
				}
				$data['dates'][$i] .= $day_job_count.'/'.$daily_limit;
				if($day_job_count < $daily_limit)
				{
					if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
					{
						$data['dates'][$i] .= '</a>';
					}
				}
				$data['dates'][$i] .= '
						</a>
					</div>
					</a>
				</div>';
				$data['dates'][$i] .= '<div class="booked-day-home">';
				if(array_key_exists($i,$has_service_calls) or $service_call_count > 0)
				{
					$data['dates'][$i] .= '
					<!--<div class="service-calls"><a href="/ajax/service_calls/'.$year."/".$month."/".sprintf("%02d",$i).'" class="facebox">Service Calls</a></div>-->';
				}
				$data['dates'][$i] .= '
					<span style="color:#fff;">{day}</span>
				</div>';
			}
		}
		
		$prefs['template'] = '

		   {table_open}<table class="calendar2" border="0" cellpadding="0" cellspacing="1">{/table_open}

		   {heading_row_start}<tr>{/heading_row_start}
			
		   {heading_previous_cell}<th><a href="{previous_url}">&lt;&lt;</a></th>{/heading_previous_cell}
		   {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
		   {heading_next_cell}<th><a href="{next_url}">&gt;&gt;</a></th>{/heading_next_cell}

		   {heading_row_end}</tr>{/heading_row_end}

		   {week_row_start}<tr class="week-days">{/week_row_start}
		   {week_day_cell}<td style="background-color:#7d7d7d; border:1px solid #7d7d7d;"><div align="left" style="color:#fff;">{week_day}</div></td>{/week_day_cell}
		   {week_row_end}</tr>{/week_row_end}

		   {cal_row_start}<tr>{/cal_row_start}
		   {cal_cell_start}<td>{/cal_cell_start}

			{cal_cell_content}
		    <div class="cell-inner-home">
				{content}
			</div>
			{/cal_cell_content}
			{cal_cell_content_today}
			<div class="cell-inner-home">
				{content}
			</div>
			{/cal_cell_content_today}

			{cal_cell_no_content}
			<div class="cell-inner-home">
				<div class="reserve-job-block-home">';
			
			if($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y')
			{
				
			}
			else
			{
				$prefs['template'] .= '<a href="/ajax/reserve_job/'.$year.'/'.$month.'/{day}" class="facebox reserve-job tooltip" title="Reserve a Job"><img src="/assets/images/blank.gif" /></a></div>';
			}
			
			$prefs['template'] .= '
				<span class="day-block2">{day}</span>
			</div>
			{/cal_cell_no_content}
			{cal_cell_no_content_today}
			<div class="cell-inner-home">
				<div class="reserve-job-block-home">';
			
			if($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y')
			{
				
			}
			else
			{
				$prefs['template'] .= '<a href="/ajax/reserve_job/'.$year.'/'.$month.'/{day}" class="facebox reserve-job tooltip" title="Reserve a Job"><img src="/assets/images/blank.gif" /></a></div>';
			}
				
			$prefs['template'] .= '
				<span class="day-block2">{day}</span>
			</div>
			{/cal_cell_no_content_today}

		   {cal_cell_blank}&nbsp;{/cal_cell_blank}

		   {cal_cell_end}</td>{/cal_cell_end}
		   {cal_row_end}</tr>{/cal_row_end}

		   {table_close}</table>{/table_close}
		';
		
		$this->load->library('calendar',$prefs);
		
		$this->load->view("common/header");
		$this->load->view("admin/index",$data);
		$this->load->view("common/footer");
	}
	
	function   jobschedule($year='',$month='')
	{
		$this->load->library("job");
		$this->load->helper("date");
		
		$data = array();
		
		$prefs = array (
			'start_day'    => 'sunday',
			'month_type'   => 'long',
			'day_type'     => 'long'
		);
		
		$jobs = array();
                $job_type = array();
		$inverter_types = $this->db->get("job_types")->result_array();
		foreach($inverter_types as $row)
		{
			$job_type[$row['id']] = $row['intials'];
		}
                $sql = "SELECT homepage FROM home_page WHERE user_id=".$this->session->userdata("user_id");
                $row = array();
                $row = $this->db->query($sql)->result_array();
                $newhomepage=array();
                if (count($row) && @$row[0]['homepage']){
                   $newhomepage = explode("/",$row[0]['homepage']);
                   
                }
              
		if($year=='') {
                    $year = date("Y");
                    if (count($newhomepage)>2 && $newhomepage[2]){
                        $year = $newhomepage[2];
                        
                    }
                }
		if($month=='') {
                    $month = date("m");
                    if (count($newhomepage)>2 && $newhomepage[3]){
                        $month = $newhomepage[3];
                    }
                }
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$data['year'] = $year;
		$data['month'] = $month;
		
		// daily job limit
		$daily_limit = $this->db->get("job_limit")->row_array();
		$daily_limit = $daily_limit['limit'];
		
		// create calendar and year dd values and set which should be preselected
		$data['calendar_months'] = array('01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr', '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Aug', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec');
		$data['calendar_years'] = array();
		for($i=date("Y",strtotime("-2 years")); $i<date("Y",strtotime("+2 years")); $i++)
		{
			$data['calendar_years'][$i] = $i;
		}
		$data['calendar_month'] = $data['month'];
		$data['calendar_year'] = $data['year'];
			
		// get jobs for the current month
		$pv_sql = "";
                $pv_sql = " AND jobs.job_type_id in(1,2,3) ";
                if( $this->session->userdata("role") == 'installer')
		{
		  $pv_sql = " AND  FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",installer_id)";
                  
		}
                  if( $this->session->userdata("role") == 'contractor')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",contractor_id)";
                  
		}
                 if( $this->session->userdata("role") == 'designer')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",designer_id)";
                  
		}
                $j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE DATE_FORMAT(jobs.job_date,'%Y-%m') = '".$year."-".$month."' $pv_sql ORDER BY jobs.job_date ASC")->result_array();
		foreach($j as $key => $value)
		{
			$jobs[date("j", strtotime($value['job_date']))][] = $value;
		}
		$days_count = days_in_month($month,$year);
		
		// grab service calls for the current month
		$sc = $this->db->query("SELECT service_calls.*,colors.hex, users.custom_hex, users.id as user_id FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id WHERE DATE_FORMAT(`date`,'%Y-%m') = '".$year."-".$month."' GROUP BY DATE_FORMAT(`date`,'%Y-%m-%d')")->result_array();
		// loop through them and assign their days as key values to make them easier to access when setup the calendar values
		$service_calls = array();
		$has_service_calls = array();
		foreach($sc as $key => $value)
		{
			if($value['job_count'] == '')
			{
                            $has_service_calls[date("j",strtotime($value['date']))] = true;
			}
			$service_calls[date("j",strtotime($value['date']))] = $value['job_count'];
		}
		
		#die(print(count($service_calls)));
                $adminblock_date = array();
		$inverter_types = $this->db->query("SELECT * FROM admin_block_date WHERE   DATE_FORMAT(block_date,'%Y-%m') = '".$year."-".$month."' ")->result_array();
		foreach($inverter_types as $row => $value){
                     $adminblock_date[date("j",strtotime($value['block_date']))] = $value['message'];
		}
		
		for($i=0; $i<($days_count+1); $i++)
		{
		    if(array_key_exists($i,$adminblock_date) ){
                        $data['dates'][$i] = '<div style="background:#333333;" class="booked-day-wrap "><div style="margin-right:110px;">'.$i.'</div><div  style="color:white;"><br/><br/>'.$adminblock_date[$i].'</div></div>';
                        
                        
                    }else if(array_key_exists($i,$jobs) or array_key_exists($i,$service_calls))
			{	
				if(array_key_exists($i,$service_calls))
				{
					$service_call_count = $service_calls[$i];
				}
				else
				{
					$service_call_count = 0;
				}
				
				if($this->session->userdata("role") == 'admin')
				{
					if(array_key_exists($i,$jobs))
					{
						if($jobs[$i][0]['hex'] == '')
						{
							$jobs[$i][0]['hex'] = '7DBB4C';
						}
						if($jobs[$i][0]['custom_hex'] != '') {
							$color = $jobs[$i][0]['custom_hex'];
						} else {
							$color = $jobs[$i][0]['hex'];
						}
						$data['dates'][$i] = '<a href="'.base_url().'ajax/quick_summary/'.$year.'/'.$month.'/{day}" class="facebox quick-summary tooltip" title="Quick Summary"><img src="/assets/images/magnifier.png" /></a><div  class="booked-day-wrap">';
					}
					else
					{
						if(array_key_exists($i,$service_calls))
						{
							$data['dates'][$i] = '<div class="booked-day-wrap2" >';
						}
					}
				}
				else
				{
					if(array_key_exists($i,$jobs))
					{
						// determine if user has any jobs on the current day
						$has_job_on_day = false;
						foreach($jobs[$i] as $day_job)
						{
							if($day_job['user_id'] == $this->session->userdata("user_id"))
							{
								$has_job_on_day = true;
							}
						}
						if ($has_job_on_day === true) {
							$data['dates'][$i] = '<a href="'.base_url().'ajax/quick_summary/'.$year.'/'.$month.'/{day}" class="facebox quick-summary tooltip" title="Quick Summary"><img src="/assets/images/magnifier.png" /></a><div  class="booked-day-wrap" >';
						} else {
							$data['dates'][$i] = '<a href="'.base_url().'ajax/quick_summary/'.$year.'/'.$month.'/{day}" class="facebox quick-summary tooltip" title="Quick Summary"><img src="/assets/images/magnifier.png" /></a><div class="booked-day-wrap ">';
						}
					}
					else
					{
						if(array_key_exists($i,$service_calls))
						{
							$data['dates'][$i] = '<div class="booked-day-wrap2" >';
						}
					}
				}
				
				$day_job_count = 0;
                                $service_job_count = 0 ;
				$dayData = "";
                                $new_dayData=array();
				if(array_key_exists($i,$jobs))
				{
			            $jobcounter = 1;
                                    $temp = false;
                                     foreach(@$jobs[$i] as $tj)
					{
                                            if($tj['custom_hex'] != '') {
							$color = $tj['custom_hex'];
						} else {
							$color = $tj['hex'];
						}
                                                $currentinstaller = true;
                                                if($this->session->userdata("role")=='installer'){
                                                    $getinstaller = explode(",",$tj['installer_id']);
                                                    if (in_array($this->session->userdata("user_id"),$getinstaller)){
                                                        $currentinstaller = false;
                                                         $color = $this->getUserColor($this->session->userdata("user_id"));
                                                    }
                                                }
                                                if($this->session->userdata("role")=='contractor'){
                                                    $getinstaller = explode(",",$tj['contractor_id']);
                                                    if ($this->session->userdata("user_id")==$tj['contractor_id']){
                                                        $currentinstaller = false;
                                                        $color = $this->getUserColor($this->session->userdata("user_id"));
                                                    }
                                                }
                                                 if($this->session->userdata("role")=='designer'){
                                                    $getinstaller = explode(",",$tj['designer_id']);
                                                    if ($this->session->userdata("user_id")==$tj['designer_id']){
                                                        $currentinstaller = false;
                                                        $color = $this->getUserColor($this->session->userdata("user_id"));
                                                    }
                                                }

                                                
                                                if ($this->session->userdata("role") != 'admin' && $tj['user_id']!=$this->session->userdata("user_id") && $currentinstaller){
                                                   $color = "7dbb4b";
                                                   if ($jobcounter>5){
                                                    if(!$temp) {
                                                         $new_dayData[]= '<a href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}">More...</a>';
                                                        $dayData .= '<a href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}">More...</a>';
                                                        $temp =true;
                                                    }
                                                   }else{
                                                     $dayData .= '<div style="background:#'.$color.';text-align:left;margin:3px;height:16px;">'.$job_type[$tj['job_type_id']].",".$this->getCustomerLastname($tj['customer_id']).",". $this->getUserIntial($tj['user_id']).'</div>';
                                                     $new_dayData[] = '<div style="background:#'.$color.';text-align:left;margin:3px;height:16px;">'.$job_type[$tj['job_type_id']].",".$this->getCustomerNeighborhood($tj['customer_id']).'</div>';
                                                   }
                                                } else{
                                                   if ($jobcounter>5){
                                                    if(!$temp) {
                                                        $dayData .= '<a href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}">More..</a>';
                                                        $new_dayData[]= '<a href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}">More..</a>';
                                                        $temp =true;
                                                    }
                                                   } else {
                                                       $dayData .= '<a href="'.base_url().'admin/job_comment/'.$tj['id'].'" style="color:white;"><div style="background:#'.$color.';text-align:left;margin:3px;height:16px;">'.$job_type[$tj['job_type_id']].",".$this->getCustomerLastname($tj['customer_id']).",". $this->getUserIntial($tj['user_id']).'</div></a>';
                                                       $new_temp= '<a href="'.base_url().'admin/job_comment/'.$tj['id'].'" style="color:white;"><div style="background:#'.$color.';text-align:left;margin:3px;height:16px;">'.$job_type[$tj['job_type_id']].",".$this->getCustomerLastname($tj['customer_id']).",". $this->getUserIntial($tj['user_id']).'</div></a>';
                                                       array_unshift($new_dayData, $new_temp);
                                                   }
                                                }
                                                $jobcounter++;
                                                
                                            if($tj['job_type_id']!=5  ){
                                               
                                                $day_job_count += (int)$tj['job_count'];
                                               
                                            }
                                            if($tj['job_type_id']==5){
                                               
                                                $service_job_count += (int)$tj['job_count'];
                                               
                                            }
					}
				}
				
				//$day_job_count += @$service_call_count;

                                $job_count_message = "";


				if($day_job_count < 1)
				{
					$day_job_count = 0;
				}else{
                                 $job_count_message = "$day_job_count Jobs";

                                }
                                $service_count_message = "";
                                if($service_job_count < 1)
				{
					$service_job_count = 0;
				}else{
                                 $service_count_message = "$service_job_count Services";

                                }

                                
                                
                                if($service_job_count && $day_job_count ){
                                     $service_count_message = "$job_count_message / $service_count_message ";
                                }else if($service_job_count) {
                                     $service_count_message = "$service_count_message";
                                }else if($day_job_count){
                                    $service_count_message = "$job_count_message ";
                                }
				
				$data['dates'][$i] .= '	<div class="jobconpan">';
				if($day_job_count < $daily_limit)
				{
					if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
					{
						//$data['dates'][$i] .= '<a href="/ajax/reserve_job/'.$year.'/'.$month.'/'.sprintf("%02d",$i).'" class="facebox reserve-job reserve-inner tooltip" title="Reserve a Job">';
					}
				}
				$data['dates'][$i] .= implode(" ",$new_dayData);
				if($day_job_count < $daily_limit)
				{
					if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
					{
						//$data['dates'][$i] .= '</a>';
					}
				}
				$data['dates'][$i] .= '
						
					</div>
					
				</div>';
				$data['dates'][$i] .= '<div class="booked-day">';
					//$data['dates'][$i] .= $job_count_message.' '.$service_count_message;
				$data['dates'][$i] .= '
					<span style="color:#fff;">{day} &nbsp;&nbsp;<a href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" class="day-view-url tooltip" title="Go To Day View"> <span style="font:underline;text-decoration: underline;">'. $service_count_message.'</span> </a></span></div>';
			}
		}
		
		$prefs['template'] = '

		   {table_open}<table class="calendar" border="0" cellpadding="0" cellspacing="1">{/table_open}

		   {heading_row_start}<tr>{/heading_row_start}
			
		   {heading_previous_cell}<th><a href="{previous_url}">&lt;&lt;</a></th>{/heading_previous_cell}
		   {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
		   {heading_next_cell}<th><a href="{next_url}">&gt;&gt;</a></th>{/heading_next_cell}

		   {heading_row_end}</tr>{/heading_row_end}

		   {week_row_start}<tr class="week-days">{/week_row_start}
		   {week_day_cell}<td style="background-color:#7d7d7d; border:1px solid #7d7d7d;"><div align="left" style="color:#fff;">{week_day}</div></td>{/week_day_cell}
		   {week_row_end}</tr>{/week_row_end}

		   {cal_row_start}<tr>{/cal_row_start}
		   {cal_cell_start}<td>{/cal_cell_start}

			{cal_cell_content}
		    <div class="cell-inner-big">
				
				{content}
			</div>
			{/cal_cell_content}
			{cal_cell_content_today}
			<div class="cell-inner-big">
				
				{content}
			</div>
			{/cal_cell_content_today}

			{cal_cell_no_content}
			<div class="cell-inner-big">
				<div class="reserve-job-block">';
			
			if($this->session->userdata("role") == 'admin')
			{
				$prefs['template'] .= '<a href="'.base_url().'ajax/block_day_form/'.$year.'/'.$month.'/{day}" class="facebox reserve-job tooltip" title="Block A Day"><img src="/assets/images/blank.gif" /></a></div>';
			}
			
			$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content}
			{cal_cell_no_content_today}
			<div class="cell-inner-big">
				<div class="reserve-job-block">';
			
			if($this->session->userdata("role") == 'admin')
			{
				$prefs['template'] .= '<a href="'.base_url().'ajax/block_day_form/'.$year.'/'.$month.'/{day}" class="facebox reserve-job tooltip" title="Block A Day"><img src="/assets/images/blank.gif" /></a></div>';
			}
			$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content_today}

		   {cal_cell_blank}&nbsp;{/cal_cell_blank}

		   {cal_cell_end}</td>{/cal_cell_end}
		   {cal_row_end}</tr>{/cal_row_end}

		   {table_close}</table>{/table_close}
		';
		
		$this->load->library('calendar',$prefs);
		$this->load->view("common/header");
		$this->load->view("admin/jobschedule",$data);
		$this->load->view("common/footer");
	}
	
	function day($year='',$month='',$day='',$installeravail = 0)
	{
		$this->load->helper("text");
		
		$data = array();
		
		if($year == '' or $month == '' or $day == '') { redirect("admin/error?e=no_day");}
		
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = $day;
                if(!$installeravail){
                   $installeravail=$this->getInstallerDay($year,$month,$day);
                }
		$data['installeravail'] = $installeravail;
		$data['day_timestamp'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		
		// daily job limit
		$data['daily_limit'] = $this->db->get("job_limit")->row_array();
		
		$extra_sql = '';
                $pv_sql ='';
                $data['editjob'] = true;
		if($this->session->userdata("role") != 'admin' )
		{
		 $extra_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));
                 $pv_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));

		}
                if( $this->session->userdata("role") == 'installer')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",installer_id)";
                  $data['editjob'] = false;
		}
                  if( $this->session->userdata("role") == 'contractor')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",contractor_id)";
                  $data['editjob'] = false;
		}
                if( $this->session->userdata("role") == 'designer_id')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",designer_id)";
                  $data['editjob'] = false;
		}
		// grab photovoltaic jobs
		 $sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='2' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $pv_sql
			";
		$data['pv_jobs'] = $this->db->query($sql)->result_array();
		
		// grab solar water heating jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='1' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $pv_sql
		";
		$data['swh_jobs'] = $this->db->query($sql)->result_array();
		
		// grab solar attic fan jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='3' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
		";
		$data['saf_jobs'] = $this->db->query($sql)->result_array();
		
		// get service calls for the day
		$sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='5' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
		";
		$data['service_calls'] = $this->db->query($sql)->result_array();
		
		// get day's installation job count
		$jc = $this->db->query("SELECT job_count as total FROM jobs LEFT JOIN users ON jobs.user_id=users.id WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".sprintf("%02d",$day)."' $extra_sql")->row_array();
		// get day's service call total count
		$sc = $this->db->query("SELECT job_count as total FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id WHERE DATE_FORMAT(`date`,'%Y-%m-%d') = '".$year."-".$month."-".sprintf("%02d",$day)."' $extra_sql")->row_array();
		$data['day_job_total'] = max(@$sc['total'], @$jc['total']);
		$data['service_count_total'] = @$sc['total'];
		
		$data['notes'] = array();
		// grab notes for all jobs on this day
		foreach($data['pv_jobs'] as $j)
		{
			$notes  = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id='".$j['id']."'")->result_array();
			foreach($notes as $n)
			{
				$data['notes'][strtotime($n['created'])] = $n;
			}
		}
		
		foreach($data['swh_jobs'] as $j)
		{
			$notes  = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id='".$j['id']."'")->result_array();
			foreach($notes as $n)
			{
				$data['notes'][strtotime($n['created'])] = $n;
			}
		}
		
		foreach($data['saf_jobs'] as $j)
		{
			$notes  = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id='".$j['id']."'")->result_array();
			foreach($notes as $n)
			{
				$data['notes'][strtotime($n['created'])] = $n;
			}
		}
		
		foreach($data['service_calls'] as $j)
		{
			$notes  = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.service_call_id='".$j['id']."'")->result_array();
			foreach($notes as $n)
			{
				$data['notes'][strtotime($n['created'])] = $n;
			}
		}
		
		ksort($data['notes']);
		$data['day_notes'] = array_slice($data['notes'],0,3);
		$data['remaining_notes'] = (count($data['notes']) - count($data['day_notes']));
		if(!$this->session->userdata('access')){
                     $data['editjob'] = false;
                }
		$this->load->view("common/header");
		$this->load->view("admin/day",$data);
		$this->load->view("common/footer");
	}
	
	function error()
	{
		$data = array();
			
		$this->load->view("common/header");
		$this->load->view("admin/error",$data);
		$this->load->view("common/footer");
	}
	
	function job($job_id='')
	{
		$data = array();
		
		$data['job_id'] = $job_id;
		
		$this->load->library("job");
		$this->load->helper("date");
		$this->load->helper("text");
                 $this->load->helper("thumbnail_helper");
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		
                $jobtimelimit = $this->gettimeLimit($job_id);
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id,'active');
                $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
		// daily job limit
                if($data["timediff"]<=0){
                  /*  $this->delete_jobcron($job_id);
                    $j = $this->db->query("SELECT * FROM users WHERE id=".$data['job']['user_id']."")->result();
                    $sname = $j[0]->first_name." ".$j[0]->last_name;
                    $this->deletemail($value['id'],$timediff,$sname,$j[0]->email);
                    redirect("admin/jobschedule?m=jd");*/
                }
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] = $jobtimelimit1;
                   }

                }
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                $data['daily_limit'] = $this->db->get("job_limit")->row_array();
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
		
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

                $sqlpid = "SELECT job_pid  FROM jobs where  id  =".$job_id;
                $rowpid = $this->db->query($sqlpid)->result_array();
                $sql_splitjob = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_pid=".$rowpid[0]['job_pid']." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['split_jobs'] = $this->db->query($sql_splitjob)->result_array();
		
                // grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                $pid = $this->getparentjobid($job_id);
                $this->db->where("job_id",$pid);
		$this->db->order_by("created","desc");
		$data['mifa'] = $this->db->get("meter_files")->result_array();

                $this->db->where("job_id",$pid);
		$this->db->order_by("created","desc");
		$data['plan_files'] = $this->db->get("genral_files")->result_array();

                $this->db->where("job_id",$pid);
		$this->db->order_by("created","desc");
		$data['sketch_files'] = $this->db->get("sketch_files")->result_array();
                
                $this->db->where("job_id",$pid);
		$this->db->order_by("created","desc");
		$data['presale_files'] = $this->db->get("presale_files")->result_array();
                
                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",1);
		$this->db->order_by("created","desc");
		$data['elec_photo_1'] = $this->db->get("elecphoto_files")->result_array();
                
                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",2);
		$this->db->order_by("created","desc");
		$data['elec_photo_2'] = $this->db->get("elecphoto_files")->result_array();
                
                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",3);
		$this->db->order_by("created","desc");
		$data['elec_photo_3'] = $this->db->get("elecphoto_files")->result_array();
                
                $this->db->where("job_id",$pid);
		$this->db->order_by("created","desc");
		$data['elecphoto_allfiles'] = $this->db->get("elecphoto_files")->result_array();

               $data['job_statuses'][''] = "- Select a job status -";
               $data['job_statuses']['unscheduled'] = "Unscheduled";
               if($data['job']['job_type_id']!=5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                $data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";

                // set job type so we know what template to display and how to validate the data
		if($data['job']['job_type_id'] == 1) { $job_type = 'swh'; }
		if($data['job']['job_type_id'] == 1) { $job_type = 'swh'; }
		if($data['job']['job_type_id'] == 2) { $job_type = 'pv'; }
		if($data['job']['job_type_id'] == 3) { $job_type = 'saf'; }
                if($data['job']['job_type_id'] == 5) { $job_type = 'service'; }
                if($data['job']['job_type_id'] == 6) { $job_type = 'pl'; }
		
		// Grab installation types
		$data['contractors'][] = '- Select a contractor -';
		$this->db->or_where('type','contractor');
		$contractors = $this->db->get("users")->result_array();
		foreach($contractors as $row) { $data['contractors'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row['last_name']); }

                $temp =explode(",",$data['job']['contractor_id']);
                $installname = array();
                foreach($temp as $c=>$v) {
                if($v){
                    $installname[] = $this->getUserIntial($v,true);
                    }
                }
                $data['electrican'] =  $installname;
		/* ---------------------------------------
		PV Job Type
		--------------------------------------- */
		if($job_type == 'pv')
		{
			 // Grab Number of modules
                        $module_array = array("0"=>"Select Number of Modules");
                        for ($i = 1 ; $i<=100;$i++){
                         $module_array[$i] = $i;
                        }
                       $data["nomodule"] = $module_array;
                       $data['nomodule']['other'] = 'Other';
                       if($data['job']['other_job_nom'] != '' && $data['job']['other_job_nom']) $data['job']['job_nom'] = 'other';




                       
                       
		       $data['spmsip']['no'] = "No";
                       $data['spmsip']['yes'] = "Yes";

                       $data['servicepanelupgrade'][0] = "--Upgrade Needed?--";
                       $this->db->order_by('type','asc');
                       $service_display = $this->db->get("service_panel_upgrade")->result_array();
		       foreach($service_display as $row) { $data['servicepanelupgrade'][$row['id']] = $row['type']; }

                       $data['moniter'][0] = "Select Moniter Display";
                       $this->db->order_by('type','asc');
                       $moniter_display = $this->db->get("moniter_display")->result_array();
		       foreach($moniter_display as $row) { $data['moniter'][$row['id']] = $row['type']; }
                       
                        //$data['moniter']['other'] = 'Other';
                        //$data["jobwssn"][0] = "Please Select ";
                        $data["jobwssn"]= array('0'=>"Please Select ",'n'=>"No",'y'=>"Yes");
                        if($data['job']['other_mointer_system'] != '' && $data['job']['other_mointer_system']) $data['job']['mointer_system'] = 'other';


                        $data['data_emt'][0] = "-- Select a Meter Type --";
                        $this->db->order_by('type','asc');

                        $moniter_display = $this->db->get("electric_wire_type")->result_array();
			foreach($moniter_display as $row) { $data['data_emt'][$row['id']] = $row['type']; }

                        
                        $data['data_emt']['other'] = 'Other';

                        if($data['job']['other_jobs_emt'] != '' && $data['job']['other_jobs_emt'] ) $data['job']['jobs_emt'] = 'other';

                         // Grab Number of Electiric  wire source
                        $data["data_ews"] = array("0"=>"Select Electric Wire Source");
                       
                        $this->db->order_by('source','asc');

                        $moniter_display = $this->db->get("electric_wire_source")->result_array();
			foreach($moniter_display as $row) { $data["data_ews"][$row['id']] = $row['source']; }

                        
                        $data['data_ews']['other'] = 'Other';
                        if($data['job']['electric_wire_source_other'] != '' && $data['job']['electric_wire_source_other']) $data['job']['electric_wire_source'] = 'other';

                        $this->db->order_by('id','asc');

                        $data["wirerundistance"] = array("0"=>"Select Wire Run Distance");

                        $wire_distance = $this->db->get("wire_run_distance")->result_array();
			
                        foreach($wire_distance as $row) { $data["wirerundistance"][$row['id']] = $row['type']; }

                        $data["wirerundistance"]['other'] = 'Other';

                        if($data['job']['other_wire_run_distance'] != '' && $data['job']['other_wire_run_distance'] != '') $data['job']['wire_run_distance'] = 'other';

                        
                        $data['inverter_types'][] = '- Select an inverter type -';
			$this->db->order_by('type','asc');
			$inverter_types = $this->db->get("inverter_types")->result_array();
			foreach($inverter_types as $row) { $data['inverter_types'][$row['id']] = $row['type']; }
			$data['inverter_types']['other'] = 'Other';
			if($data['job']['other_inverter_type'] != '') $data['job']['inverter_type_id'] = 'other';
			
			// Grab module powers
			$data['module_powers'][] = '- Select module power -';
			$this->db->order_by('power','desc');
			$module_powers = $this->db->get("module_powers")->result_array();
			foreach($module_powers as $row) { $data['module_powers'][$row['id']] = $row['power']; }
			$data['module_powers']['other'] = 'Other';
			if($data['job']['other_module_power'] != '') $data['job']['module_power_id'] = 'other';

			// Grab module brands
			$data['module_brands'][] = '- Select a module Type -';
			$this->db->order_by('brand','asc');
			$module_brands = $this->db->get("module_brands")->result_array();
			foreach($module_brands as $row) { $data['module_brands'][$row['id']] = $row['brand']; }
			$data['module_brands']['other'] = 'Other';
			if($data['job']['other_module_brand'] != '') $data['job']['module_brand_id'] = 'other';

			// Grab roof types 
			$data['roof_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$roof_types = $this->db->get("roof_types")->result_array();
			foreach($roof_types as $row) { $data['roof_types'][$row['id']] = $row['type']; }
			$data['roof_types']['other'] = 'Other';
			if($data['job']['other_roof_type'] != '') $data['job']['roof_type_id'] = 'other';

			// Grab rafter types 
			$data['rafter_types'][] = '- Select a Rafter Type -';
			$this->db->order_by('type','asc');
			$rafter_types = $this->db->get("rafter_types")->result_array();
			foreach($rafter_types as $row) { $data['rafter_types'][$row['id']] = $row['type']; }
			$data['rafter_types']['other'] = 'Other';
			if($data['job']['other_rafter_type'] != '') $data['job']['rafter_type_id'] = 'other';

			// Grab inverter brands
			$data['inverter_brands'][] = '- Select an Module Number/Name -';
			$this->db->order_by('brand','asc');
			$inverter_brands = $this->db->get("inverter_brands")->result_array();
			foreach($inverter_brands as $row) { $data['inverter_brands'][$row['id']] = $row['brand']; }
			$data['inverter_brands']['other'] = 'Other';
			if($data['job']['other_inverter_brand'] != '') $data['job']['inverter_brand_id'] = 'other';

			// Grab service panel amperage options
			$data['service_panel_amperages'][] = '- Select an amperage -';
			$this->db->order_by('amperage','asc');
			$service_panel_amperages = $this->db->get("service_panel_amperages")->result_array();
			foreach($service_panel_amperages as $row) { $data['service_panel_amperages'][$row['id']] = $row['amperage']; }
			$data['service_panel_amperages']['other'] = 'Other';
			if($data['job']['other_amperage'] != '') $data['job']['service_panel_amperage_id'] = 'other';

			// Grab wire run types
			$data['wire_run_types'][] = '- Select an type -';
			$this->db->order_by('type','asc');
			$wire_run_types = $this->db->get("wire_run_types")->result_array();
			foreach($wire_run_types as $row) { $data['wire_run_types'][$row['id']] = $row['type']; }
			$data['wire_run_types']['other'] = 'Other';
			if($data['job']['other_wire_run_type'] != '') $data['job']['wire_run_type_id'] = 'other';

			// Grab installation types
			$data['installation_types'][] = '- Select an type -';
			$this->db->order_by('type','asc');
			$installation_types = $this->db->get("installation_types")->result_array();
			foreach($installation_types as $row) { $data['installation_types'][$row['id']] = $row['type']; }
			$data['installation_types']['other'] = 'Other';
			if($data['job']['other_installation_type'] != '') $data['job']['installation_type_id'] = 'other';
			
			// build stories drop-down
			for($i=1; $i<=3; $i++) { $data['stories'][$i] = $i; }
                        
                         $data['roof_flashing']['1'] = 'AEI(Eco Fastener)';
                         $data['roof_flashing']['2'] = 'Quickmount';
                         $data['roof_flashing']['3'] = 'Wakaflex';
                         $data['roof_flashing']['4'] = 'GEOCEL';
                         $data['roof_flashing']['5'] = 'Lead';
		      }
		
		if($job_type == 'swh')
		{
			// Grab tank brands
			$data["piperundistance"] = array("0"=>"Select Pipe Run Distance");
                         $this->db->order_by('id','asc');
                         $piperundistance_display = $this->db->get("pipe_run_distance")->result_array();
                         foreach($piperundistance_display as $row) {
                          $data["piperundistance"][$row['id']] = $row['type'];
                        }
                       $data['tank_brands'][] = '- Select a tank brand -';
			$this->db->order_by('brand','asc');
			$tank_brands = $this->db->get("tank_brands")->result_array();
			foreach($tank_brands as $row) { $data['tank_brands'][$row['id']] = $row['brand']; }
			$data['tank_brands']['other'] = 'Other';
			if($data['job']['other_tank_brand'] != '') {$data['job']['tank_brand_id'] = 'other';}
			
			// Grab tank sizes
			$data['tank_sizes'][] = '- Select a tank sizes -';
			$this->db->order_by('size','asc');
			$tank_sizes = $this->db->get("tank_sizes")->result_array();
			foreach($tank_sizes as $row) { $data['tank_sizes'][$row['id']] = $row['size']; }
			$data['tank_sizes']['other'] = 'Other';
			if($data['job']['other_tank_size'] != '') $data['job']['tank_size_id'] = 'other';
			
			// Grab panel types
			$data['panel_types'][] = '- Select a panel type -';
			$this->db->order_by('type','asc');
			$panel_types = $this->db->get("panel_types")->result_array();
			foreach($panel_types as $row) { $data['panel_types'][$row['id']] = $row['type']; }
			$data['panel_types']['other'] = 'Other';
			if($data['job']['other_panel_type'] != '') $data['job']['panel_type_id'] = 'other';
			
			// Grab panel sizes
			$data['panel_sizes'][] = '- Select a panel size -';
			$this->db->order_by('size','asc');
			$panel_sizes = $this->db->get("panel_sizes")->result_array();
			foreach($panel_sizes as $row) { $data['panel_sizes'][$row['id']] = $row['size']; }
			$data['panel_sizes']['other'] = 'Other';
			if($data['job']['other_panel_size'] != '') $data['job']['panel_size_id'] = 'other';
			
			// Grab pipe run types
			$data['pump_types'][] = '- Select Type of pump -';
			$data['pump_types'][] = 'DC';
                        $data['pump_types'][] = 'AC';
                        $data['pump_types'][] = 'Heat Pump';

                        $data['piperun_types'][] = '- Select a pipe-run type -';
			$this->db->order_by('type','asc');
			$piperun_types = $this->db->get("piperun_types")->result_array();
			foreach($piperun_types as $row) { $data['piperun_types'][$row['id']] = $row['type']; }

			$data['piperun_types']['other'] = 'Other';
			if($data['job']['other_piperun_type'] != '') $data['job']['piperun_type_id'] = 'other';
			
			// Grab installation types
			$data['installation_types'][] = '- Select an type -';
			$this->db->order_by('type','asc');
			$installation_types = $this->db->get("installation_types")->result_array();
			foreach($installation_types as $row) { $data['installation_types'][$row['id']] = $row['type']; }
			$data['installation_types']['other'] = 'Other';
			if($data['job']['other_installation_type'] != '') $data['job']['installation_type_id'] = 'other';
			
			// Grab roof types 
			$data['roof_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$roof_types = $this->db->get("roof_types")->result_array();
			foreach($roof_types as $row) { $data['roof_types'][$row['id']] = $row['type']; }
			$data['roof_types']['other'] = 'Other';
			if($data['job']['other_roof_type'] != '') $data['job']['roof_type_id'] = 'other';

			// Grab rafter types 
			$data['rafter_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$rafter_types = $this->db->get("rafter_types")->result_array();
			foreach($rafter_types as $row) { $data['rafter_types'][$row['id']] = $row['type']; }
			$data['rafter_types']['other'] = 'Other';
			if($data['job']['other_rafter_type'] != '') $data['job']['rafter_type_id'] = 'other';
			
			// build stories drop-down
			for($i=1; $i<=3; $i++) { $data['stories'][$i] = $i; }
		}
		
		if($job_type == 'saf')
		{
			// Grab fan brands
			$data['fan_brands'][] = '- Select a brand -';
			$this->db->order_by('brand','asc');
			$fan_brands = $this->db->get("fan_brands")->result_array();
			foreach($fan_brands as $row) { $data['fan_brands'][$row['id']] = $row['brand']; }
			$data['fan_brands']['other'] = 'Other';
			
			// Grab fan sizes
			$data['fan_sizes'][] = '- Select a fan size -';
			$this->db->order_by('size','asc');
			$fan_sizes = $this->db->get("fan_sizes")->result_array();
			foreach($fan_sizes as $row) { $data['fan_sizes'][$row['id']] = $row['size']; }
			$data['fan_sizes']['other'] = 'Other';
			
			// Grab installation types
			$data['installation_types'][] = '- Select an type -';
			$this->db->order_by('type','asc');
			$installation_types = $this->db->get("installation_types")->result_array();
			foreach($installation_types as $row) { $data['installation_types'][$row['id']] = $row['type']; }
			$data['installation_types']['other'] = 'Other';
			
			// Grab roof types 
			$data['roof_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$roof_types = $this->db->get("roof_types")->result_array();
			foreach($roof_types as $row) { $data['roof_types'][$row['id']] = $row['type']; }
			$data['roof_types']['other'] = 'Other';

			// Grab rafter types 
			$data['rafter_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$rafter_types = $this->db->get("rafter_types")->result_array();
			foreach($rafter_types as $row) { $data['rafter_types'][$row['id']] = $row['type']; }
			$data['rafter_types']['other'] = 'Other';
			
			// build stories drop-down
			for($i=1; $i<=3; $i++) { $data['stories'][$i] = $i; }
		}
                if ($job_type == 'service'){
                
		// find other active jobs for customer that this job belongs to
		//$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		//$data['other_jobs'] = $this->db->query($sql)->result_array();

		
		// grab service call notes
		//$data['job_notes'] = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.service_call_id=".$this->db->escape($service_call_id)." LIMIT 3")->result_array();

		// build times drop-down
		$start = strtotime('9:00am');
		$end = strtotime('9:00pm');

		$data['times_dd'] = array();
		for ($i = $start; $i <= $end; $i += 900)
		{
			$data['times_dd'][date('g:i a', $i)] = date('g:i a', $i);
		}

		// grab technician type users
		

		

                }
                
                 if ($job_type == 'pl'){
                
		// find other active jobs for customer that this job belongs to
		//$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		//$data['other_jobs'] = $this->db->query($sql)->result_array();

		
		// grab service call notes
		//$data['job_notes'] = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.service_call_id=".$this->db->escape($service_call_id)." LIMIT 3")->result_array();

		// build times drop-down
		$start = strtotime('9:00am');
		$end = strtotime('9:00pm');

		$data['times_dd'] = array();
		$data['times_dd'][1] ="9am-12pm";
                $data['times_dd'][2] ="1pm-4pm";

		// grab technician type users
		

		

                }
		
		
		if($this->input->post('dosubmit'))
		{
			$row = array();
			// fields for pv job type
                        $row['modified_by'] =  $this->session->userdata("user_id");
                        if($job_type == 'pl'){
                            $row['arrival_time'] = $this->input->post("arrival_time");
                            $row['toprelag'] = $this->input->post("toprelag");
                            $row['pldesc'] = $this->input->post("pldesc");
                          //  $row['contractor_id'] = implode("," ,$this->input->post("contractor_id"));
                            $row['comments'] = $this->input->post("comments");
                            $this->db->where("id",$job_id);
                            $this->db->update("jobs",$row);
                            redirect("admin/job/".$job_id."?savedata=1");
                        }
                        if($job_type == 'service'){
                            $row['repair_time'] = $this->input->post("repair_time");
                            $row['repair_type'] = $this->input->post("repair_type");
                            $row['servicedesc'] = $this->input->post("description");
                          //  $row['contractor_id'] = implode("," ,$this->input->post("contractor_id"));
                            $row['comments'] = $this->input->post("comments");
                            $this->db->where("id",$job_id);
                            $this->db->update("jobs",$row);
                            redirect("admin/job/".$job_id."?savedata=1");
                        }
                        $row['job_nos'] = $this->input->post("nos");
                        $row['job_nosa'] = $this->input->post("nosa");
                        $row['saoorf'] = $this->input->post("saoorf");
                        $row['nodrf'] = $this->input->post("nodrf");
                        $row['envoy_serial_number'] = $this->input->post("envoy_serial_number");
                        $row['spmsip_job'] = $this->input->post("spmsip_job");
                        if ($this->input->post('nom') == 'other') {
                            $row['job_nom'] = '';
                            $row['other_job_nom'] = $this->input->post("other_nom");
			} else {
                            $row['job_nom'] = $this->input->post("nom");
                            $row['other_job_nom'] = '';
			}
                       

			if($job_type == 'pv')
			{

                              if ($this->input->post('mt') == 'other') {
					$row['module_brand_id'] = '';
					$row['other_module_brand'] = $this->input->post("other_mt");
				} else {
					$row['module_brand_id'] = $this->input->post("mt");
					$row['other_module_brand'] = '';
				}

                             //   $row['module_count'] = $this->input->post("module_count");
				$row['system_size'] = $this->input->post("system_size");
				if ($this->input->post("module_power_id") == 'other') {
					$row['module_power_id'] = '';
					$row['other_module_power'] = $this->input->post("other_module_power");
				} else {
					$row['module_power_id'] = $this->input->post("module_power_id");
					$row['other_module_power'] = '';
				}
				if ($this->input->post("inverter_type_id") == 'other') {
					$row['inverter_type_id'] = '';
					$row['other_inverter_type'] = $this->input->post("other_inverter_type");
				} else {
					$row['inverter_type_id'] = $this->input->post("inverter_type_id");
					$row['other_inverter_type'] = '';
				}
                                if ($this->input->post("ms") == 'other') {
					$row['mointer_system'] = '';
					$row['other_mointer_system'] = $this->input->post("other_ms");
				} else {
					$row['mointer_system'] =$this->input->post("ms");
					$row['other_mointer_system'] = '';
				}
				if ($this->input->post("inverter_brand_id") == 'other') {
					$row['inverter_brand_id'] = '';
					$row['other_inverter_brand'] = $this->input->post("other_inverter_brand");
				} else {
					$row['inverter_brand_id'] =$this->input->post("inverter_brand_id");
					$row['other_inverter_brand'] = '';
				}
                                $row['elec_insp_quote'] = $this->input->post('elec_insp_quote');
                                if ($row['elec_insp_quote']=='y') {
                                    $row['elec_comments'] = $this->input->post("elec_comments");
                                } else {
                                     $row['elec_comments'] = '';
                                }
				$row['inverter_count'] = $this->input->post("inverter_count");
                                $row['roof_flashing'] = $this->input->post("roof_flashing");
				$row['inverter_accessible'] = $this->input->post("inverter_accessible");
                                $row['is_ladder'] = $this->input->post("is_longladder");
				if ($this->input->post("emt") == 'other') {
					$row['jobs_emt'] = '';
					$row['other_jobs_emt'] = $this->input->post("other_emt");
				} else {
					$row['jobs_emt'] = $this->input->post("emt");
					$row['other_jobs_emt'] = '';
				}
                               
                                if ($this->input->post("ews") == 'other') {
					$row['electric_wire_source'] = '';
					$row['electric_wire_source_other'] = $this->input->post("other_ews");
				} else {
					$row['electric_wire_source'] = $this->input->post("ews");
					$row['electric_wire_source_other'] = '';
				}
                                
                                $row['job_isnws'] = $this->input->post("isnws");
                                $row['job_wssn'] = $this->input->post("job_wssn");
                               
				if ($this->input->post("service_panel_amperage_id") == 'other') {
					$row['service_panel_amperage_id'] = '';
					$row['other_amperage'] = $this->input->post("other_amperage");
				} else {
					$row['service_panel_amperage_id'] = $this->input->post("service_panel_amperage_id");
					$row['other_amperage'] = '';
				}

                                $row['job_dowr'] = $this->input->post("dowr");
                                $row['job_spu'] = $this->input->post("spu");
                                $row['servicepanelupgrade'] = $this->input->post("service_panel_upgrade");
				if ($this->input->post("wire_run_type_id") == 'other') {
					$row['wire_run_type_id'] = '';
					$row['other_wire_run_type'] = $this->input->post("other_wire_run_type");
				} else {
					$row['wire_run_type_id'] = $this->input->post("wire_run_type_id");
					$row['other_wire_run_type'] = '';
				}
                                if ($this->input->post("wire_run_distance") == 'other') {
					$row['wire_run_distance'] = '';
					$row['other_wire_run_distance'] = $this->input->post("other_wire_run_distance");
				} else {
					$row['wire_run_distance'] = $this->input->post("wire_run_distance");
					$row['other_wire_run_distance'] = '';
				}
				$row['wire_run_distance'] = $this->input->post("wire_run_distance");
				$row['stories'] = $this->input->post("stories");
				if ($this->input->post("roof_type_id") == 'other') {
					$row['roof_type_id'] = '';
					$row['other_roof_type'] = $this->input->post("other_roof_type");
				} else {
					$row['roof_type_id'] = $this->input->post("roof_type_id");
					$row['other_roof_type'] = '';
				}
				$row['roof_color'] = $this->input->post("roof_color");
				$row['roof_pitch'] = $this->input->post("roof_pitch");
				$row['roof_orientation'] = $this->input->post("roof_orientation");
				$row['module_install_location_access'] = $this->input->post("module_install_location_access");
				if ($this->input->post("rafter_type_id") == 'other') {
					$row['rafter_type_id'] = '';
					$row['other_rafter_type'] = $this->input->post("other_rafter_type");
				} else {
					$row['rafter_type_id'] = $this->input->post("rafter_type_id");
					$row['other_rafter_type'] = '';
				}
				$row['rafter_distance'] = $this->input->post("rafter_distance");
				$row['tilt_kit_needed'] = $this->input->post("tilt_kit_needed");
				if ($this->input->post("installation_type_id") == 'other') {
					$row['installation_type_id'] = '';
					$row['other_installation_type'] = $this->input->post("other_installation_type");
				} else {
					$row['installation_type_id'] = $this->input->post("installation_type_id");
					$row['other_installation_type'] = '';
				}
				//$row['contractor_id'] = @implode("," ,$this->input->post("contractor_id"));
                              /*  $job_newcontrator = array();
                                $job_existcontrator = array();
                                $job_existcontrator = explode(",",$data['job']['contractor_id']);
                                $job_newcontrator =  $this->input->post("contractor_id");
                                $diff_Array = array();
                                $diff_Array = array_diff($job_newcontrator,$job_existcontrator);
                               
                                if(count($diff_Array)>=1){
                                  $new_userstring = implode(",",$diff_Array);
                                  $row_users = $this->db->query("SELECT users.email from users WHERE    id in ($new_userstring)")->result_array();
                                  foreach ($row_users as $value){
                                      $this->job->sendmailhelper($job_id,$data['job']['first_name'],$data['job']['last_name'],$value['email']);
                                  }
                                }*/
				$row['comments'] = $this->input->post("comments");
			}
			
			if($job_type == 'saf')
			{
				if ($this->input->post("fan_brand_id") == 'other') {
					$row['fan_brand_id'] = '';
					$row['other_fan_brand'] = $this->input->post("other_fan_brand");
				} else {
					$row['fan_brand_id'] = $this->input->post("fan_brand_id");
					$row['other_fan_brand'] = '';
				}
				if ($this->input->post("fan_size_id") == 'other') {
					$row['fan_size_id'] = '';
					$row['other_fan_size'] = $this->input->post("other_fan_size");
				} else {
					$row['fan_size_id'] = $this->input->post("fan_size_id");
					$row['other_fan_size'] = '';
				}
				$row['panel_install_location_access'] = $this->input->post("panel_install_location_access");
				$row['stories'] = $this->input->post("stories");
				if ($this->input->post("roof_type_id") == 'other') {
					$row['roof_type_id'] = '';
					$row['other_roof_type'] = $this->input->post("other_roof_type");
				} else {
					$row['roof_type_id'] = $this->input->post("roof_type_id");
					$row['other_roof_type'] = '';
				}
				$row['roof_color'] = $this->input->post("roof_color");
				$row['roof_pitch'] = $this->input->post("roof_pitch");
				$row['roof_orientation'] = $this->input->post("roof_orientation");
				$row['fan_install_location_access'] = $this->input->post("module_install_location_access");
				if ($this->input->post("rafter_type_id") == 'other') {
					$row['rafter_type_id'] = '';
					$row['other_rafter_type'] = $this->input->post("other_rafter_type");
				} else {
					$row['rafter_type_id'] = $this->input->post("rafter_type_id");
					$row['other_rafter_type'] = '';
				}
				$row['rafter_distance'] = $this->input->post("rafter_distance");
				$row['tilt_kit_needed'] = $this->input->post("tilt_kit_needed");
				if ($this->input->post("installation_type_id") == 'other') {
					$row['installation_type_id'] = '';
					$row['other_installation_type'] = $this->input->post("other_installation_type");
				} else {
					$row['installation_type_id'] = $this->input->post("installation_type_id");
					$row['other_installation_type'] = '';
				}
				//$row['contractor_id'] = $this->input->post("contractor_id");
				$row['comments'] = $this->input->post("comments");
			}
			
			if($job_type == 'swh')
			{
				if ($this->input->post("tank_brand_id") == 'other') {
					$row['tank_brand_id'] = '';
					$row['other_tank_brand'] = $this->input->post("other_tank_brand");
				} else {
					$row['tank_brand_id'] = $this->input->post("tank_brand_id");
					$row['other_tank_brand'] = '';
				}
				if ($this->input->post("tank_size_id") == 'other') {
					$row['tank_size_id'] = '';
					$row['other_tank_size'] = $this->input->post("other_tank_size");
				} else {
					$row['tank_size_id'] = $this->input->post("tank_size_id");
					$row['other_tank_size'] = '';
				}
                                $row['elec_insp_quote'] = $this->input->post('elec_insp_quote');
                                if ($row['elec_insp_quote']=='y') {
                                    $row['elec_comments'] = $this->input->post("elec_comments");
                                } else {
                                    $row['elec_comments'] = '';
                                }
                                $row['typeofjump'] = $this->input->post("typeofjump");
				$row['existing_heater_location'] = $this->input->post("existing_heater_location");
				$row['remove_old_tank'] = $this->input->post("remove_old_tank");
				$row['relocate_old_tank'] = $this->input->post("relocate_old_tank");
				$row['new_tank_location'] = $this->input->post("new_tank_location");
				$row['tank_distance'] = $this->input->post("tank_distance");
				$row['solar_tank_accessible'] = $this->input->post("solar_tank_accessible");
                                if ($this->input->post("pump_type_id") == 'other') {
					$row['pump_type_id'] = '';
					$row['other_pump_type'] = $this->input->post("other_pump_type");
				} else {
					$row['pump_type_id'] = $this->input->post("pump_type_id");
					$row['other_pump_type'] = '';
				}

				if ($this->input->post("panel_type_id") == 'other') {
					$row['panel_type_id'] = '';
					$row['other_panel_type'] = $this->input->post("other_panel_type");
				} else {
					$row['panel_type_id'] = $this->input->post("panel_type_id");
					$row['other_panel_type'] = '';
				}
				if ($this->input->post("panel_size_id") == 'other') {
					$row['panel_size_id'] = '';
					$row['other_panel_size'] = $this->input->post("other_panel_size");
				} else {
					$row['panel_size_id'] = $this->input->post("panel_size_id");
					$row['other_panel_size'] = '';
				}
				
				$row['piperun_length'] = $this->input->post("piperun_length");
				if ($this->input->post("piperun_type_id") == 'other') {
					$row['piperun_type_id'] = '';
					$row['other_piperun_type'] = $this->input->post("other_piperun_type");
				} else {
					$row['piperun_type_id'] = $this->input->post("piperun_type_id");
					$row['other_piperun_type'] = '';
				}
				$row['gutter_installation'] = $this->input->post("gutter_installation");
				$row['panel_install_location_access'] = $this->input->post("panel_install_location_access");
				$row['stories'] = $this->input->post("stories");
				if ($this->input->post("rafter_type_id") == 'other') {
					$row['rafter_type_id'] = '';
					$row['other_rafter_type'] = $this->input->post("other_rafter_type");
				} else {
					$row['rafter_type_id'] = $this->input->post("rafter_type_id");
					$row['other_rafter_type'] = '';
				}
				$row['roof_color'] = $this->input->post("roof_color");
				$row['roof_pitch'] = $this->input->post("roof_pitch");
				$row['roof_orientation'] = $this->input->post("roof_orientation");
				$row['module_install_location_access'] = $this->input->post("module_install_location_access");
				if ($this->input->post("rafter_type_id") == 'other') {
					$row['rafter_type_id'] = '';
					$row['other_rafter_type'] = $this->input->post("other_rafter_type");
				} else {
					$row['rafter_type_id'] = $this->input->post("rafter_type_id");
					$row['other_rafter_type'] = '';
				}
				$row['rafter_distance'] = $this->input->post("rafter_distance");
				$row['tilt_kit_needed'] = $this->input->post("tilt_kit_needed");
				if ($this->input->post("installation_type_id") == 'other') {
					$row['installation_type_id'] = '';
					$row['other_installation_type'] = $this->input->post("other_installation_type");
				} else {
					$row['installation_type_id'] = $this->input->post("installation_type_id");
					$row['other_installation_type'] = '';
				}
                                $row['panel_count'] = $this->input->post("panel_count");
				//$row['contractor_id'] = $this->input->post("contractor_id");
                                
				$row['contractor_id'] = implode("," ,$this->input->post("contractor_id"));
                                $row['comments'] = $this->input->post("comments");
			}
			
			$pid_job = $this->getparentjobid($job_id);
                        $this->db->where("job_pid",$pid_job);
                        
			$this->db->update("jobs",$row);

			redirect("admin/job/".$job_id."?savedata=1");
		}
		 global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
		$data['savedata'] =  $this->input->get("savedata");
                $this->load->view("common/header");
              
		$this->load->view("admin/job_$job_type",$data);
		$this->load->view("common/footer");
	}
	
	function delete_job($job_id='')
	{
		// make sure user is either admin or that the job at least belongs to them before deleting
		if($this->session->userdata("role") != 'admin')
		{
			$row = $this->db->query("SELECT * FROM jobs WHERE user_id=".$this->db->escape($this->session->userdata("user_id"))." AND id=".$this->db->escape($job_id))->row_array();
			if (count($row) > 0) {
				$this->db->where("id",$job_id);
				$this->db->delete("jobs");
				
				if($this->input->get("ref"))
				{
					redirect($this->input->get("ref"));
				}
				else
				{
					redirect("admin/jobschedule");
				}
			} else {
				redirect("admin/error?e=permissions");
			}
		}
		else
		{
			 $sqlpid = "SELECT job_pid  FROM jobs where  id  =".$job_id;
                         $rowpid = $this->db->query($sqlpid)->result_array();
                        $this->db->where("job_pid",$rowpid[0]['job_pid']);
			$this->db->delete("jobs");

			if ($this->input->get("ref")) {
				redirect($this->input->get("ref"));
			} else {
				redirect("admin/jobschedule");
			}
		}
	}
	
	function delete_service_call($service_call_id='')
	{
		// make sure user is either admin or that the job at least belongs to them before deleting
		if($this->session->userdata("role") != 'admin')
		{
			$row = $this->db->query("SELECT * FROM service_calls WHERE user_id=".$this->db->escape($this->session->userdata("user_id"))." AND id=".$this->db->escape($service_call_id))->row_array();
			if (count($row) > 0) {
				$this->db->where("id",$service_call_id);
				$this->db->delete("service_calls");
				
				if ($this->input->get("ref")) {
					redirect($this->input->get("ref"));
				} else {
					redirect("admin/jobschedule");
				}
			} else {
				redirect("admin/error?e=permissions");
			}
		}
		else
		{
			$this->db->where("id",$service_call_id);
			$this->db->delete("service_calls");

			if ($this->input->get("ref")) {
				redirect($this->input->get("ref"));
			} else {
				redirect("admin/jobschedule");
			}
		}
	}
	
	function job_financing($job_id='')
	{
		$data = array();
		
		$data['job_id'] = $job_id;
		
		$this->load->library("job");
                $data['percent_completed'] = $this->job->percent_completed($job_id);
		$this->load->helper("text");
		
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();
                $data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
                 if($data['job']['job_type_id'] == 6 ) { $data['titleshow'] = 'PreLag'; }
                
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		//$data['percent_completed'] = $this->job->percent_completed($job_id);
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
		// daily job limit
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id,'active');
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();
		
		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
		
		$data['job_statuses'][''] = "- Select a job status -";
               $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']!=5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                $data['job_statuses']['to be completed'] = "To Be Completed";
		$data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
		// Grab payment types
		$data['payment_types'][] = '- Select a payment method -';
		$this->db->order_by('type','asc');
		$payment_types = $this->db->get("payment_types")->result_array();
		foreach($payment_types as $row)
		{
			$data['payment_types'][$row['id']] = $row['type'];
		}
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['system_special_pricing'] = $this->input->post("system_special_pricing");
			$row['list_price'] = $this->input->post("list_price");
			$row['referral'] = $this->input->post("referral");
			$row['program_discount'] = $this->input->post("program_discount");
			$row['state_excise_tax'] = $this->input->post("state_excise_tax");
			$row['referral_amount'] = $this->input->post("referral_amount");
			$row['sales_commission'] = $this->input->post("sales_commission");
			$row['state_tax_credit'] = $this->input->post("state_tax_credit");

                        $row['federal_tax_credit'] = $this->input->post("federal_tax_credit");
			$row['total_tax_credits'] = $this->input->post("total_tax_credits");
			$row['payment_type_id'] = $this->input->post("payment_type_id");
			$row['financing_comments'] = $this->input->post("financing_comments");
                        $row['institution'] = $this->input->post("institution");
                        $row['payment_dpp'] = $this->input->post("dpp");
			$row['payment_amdpp'] = $this->input->post("amdpp");
			$row['payment_fpp'] = $this->input->post("fpp");
			$row['payment_amfpp'] = $this->input->post("amfpp");
			
			$pid_job = $this->getparentjobid($job_id);
                        $this->db->where("job_pid",$pid_job);
			$this->db->update("jobs",$row);
			
			redirect("admin/job_financing/".$job_id."?savedata=1");
		}
		
		// see if we need to notify user to add a referral
		if($data['job']['referral'] == 'y')
		{
			$this->db->where('job_id',$data['job']['id']);
			$refs = $this->db->get("referrals")->result_array();
			if(count($refs) == 0)
			{
				$data['show_referral_popup'] = true;
			}
		}
		 global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $data['savedata'] =  $this->input->get("savedata");
		$this->load->view("common/header");
                if($data['job']['job_type_id'] == 5 ){
                    $this->load->view("admin/service_financing",$data);
                }else if($data['job']['job_type_id'] == 1){
                    $this->load->view("admin/jobswh_financing",$data);
                }else{
                    $this->load->view("admin/job_financing",$data);
                }
		$this->load->view("common/footer");
	}
	
	function job_referrals($job_id='')
	{
		$this->load->library("job");
		$this->load->helper("text");
		
		$data = array();
		$data['job_id'] = $job_id;
		
		$sql = "SELECT
			referrals.*,
			referral_types.type as referral_type
			FROM
				referrals
			LEFT JOIN referral_types ON referrals.referral_type_id=referral_types.id
			WHERE referrals.job_id=".$this->db->escape($job_id)."
		";
		$data['referrals'] = $this->db->query($sql)->result_array();
		
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
                $data['job'] = $this->db->query($sql)->row_array();
                $data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
                 if($data['job']['job_type_id'] == 6 ) { $data['titleshow'] = 'PreLag'; }
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);

                $jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
		// daily job limit
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                 $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();
		
		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
		
		$data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']!=5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                 $data['job_statuses']['to be completed'] = "To Be Completed";
                 $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
		 global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
		$data['savedata'] =  $this->input->get("savedata");
		$this->load->view("common/header");
		$this->load->view("admin/job_referrals",$data);
		$this->load->view("common/footer");
	}
	
	function add_referral($job_id='')
	{
		$this->load->library("job");
		
		$data = array();
		$data['job_id'] = $job_id;
		
		$this->db->where("job_id",$job_id);
		$data['referrals'] = $this->db->get("referrals")->result_array();
		
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		
		$data['job'] = $this->db->query($sql)->row_array();
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
                $jobtimelimit = $this->gettimeLimit($job_id);
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);
                $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
		// daily job limit
                if($data["timediff"]<=0){
                  /*  $this->delete_jobcron($job_id);
                    $j = $this->db->query("SELECT * FROM users WHERE id=".$data['job']['user_id']."")->result();
                    $sname = $j[0]->first_name." ".$j[0]->last_name;
                    $this->deletemail($value['id'],$timediff,$sname,$j[0]->email);
                    redirect("admin/jobschedule?m=jd");*/
                }
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                $data['daily_limit'] = $this->db->get("job_limit")->row_array();

		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();

		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                $this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['plan_files'] = $this->db->get("genral_files")->result_array();
                $data['percent_completed'] = $this->job->percent_completed($job_id);
                $data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']!=5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
		$data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
		
		// states array
		$data['states'] =  array('' => "- Choose a state -");
		$data['states'] += array('AK'=>"Alaska",'AL'=>"Alabama",'AR'=>"Arkansas",'AZ'=>"Arizona",'CA'=>"California",'CO'=>"Colorado",'CT'=>"Connecticut",'DC'=>"District Of Columbia",'DE'=>"Delaware",'FL'=>"Florida",'GA'=>"Georgia",'HI'=>"Hawaii",'IA'=>"Iowa",'ID'=>"Idaho",'IL'=>"Illinois", 'IN'=>"Indiana",'KS'=>"Kansas",'KY'=>"Kentucky",'LA'=>"Louisiana",'MA'=>"Massachusetts",'MD'=>"Maryland",'ME'=>"Maine",'MI'=>"Michigan",'MN'=>"Minnesota",'MO'=>"Missouri",'MS'=>"Mississippi",'MT'=>"Montana",'NC'=>"North Carolina",'ND'=>"North Dakota",'NE'=>"Nebraska",'NH'=>"New Hampshire",'NJ'=>"New Jersey",'NM'=>"New Mexico",'NV'=>"Nevada",'NY'=>"New York",'OH'=>"Ohio",'OK'=>"Oklahoma", 'OR'=>"Oregon",'PA'=>"Pennsylvania",'RI'=>"Rhode Island",'SC'=>"South Carolina",'SD'=>"South Dakota",'TN'=>"Tennessee",'TX'=>"Texas",'UT'=>"Utah",'VA'=>"Virginia",'VT'=>"Vermont",'WA'=>"Washington",'WI'=>"Wisconsin",'WV'=>"West Virginia",'WY'=>"Wyoming");
		
		// Grab referral types
		$data['referral_types'][] = '- Select a referral type -';
		$this->db->order_by('type','asc');
		$referral_types = $this->db->get("referral_types")->result_array();
		foreach($referral_types as $row)
		{
			$data['referral_types'][$row['id']] = $row['type'];
		}
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['job_id'] = $job_id;
			$row['referral_type_id'] = $this->input->post("referral_type_id");
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
			$row['home_phone'] = $this->input->post("home_phone");
			$row['address'] = $this->input->post("address");
			$row['city'] = $this->input->post("city");
			$row['state'] = $this->input->post("state");
			$row['zip_code'] = $this->input->post("zip_code");
			$row['referral_amount'] = $this->input->post("referral_amount");
                        $row['ti9taxform'] = $this->input->post("ti9taxform");
			$row['comments'] = $this->input->post("comments");
			$this->db->insert("referrals",$row);
			redirect("admin/job_referrals/".$job_id."?savedata=1");
		}
		global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $data['savedata'] =  $this->input->get("savedata");
		$this->load->view("common/header");
		$this->load->view("admin/add_referral",$data);
		$this->load->view("common/footer");
	}
	
	function edit_referral($referral_id='')
	{
		$this->load->library("job");
		
		$data = array();
		
		$data['referral_id'] = $referral_id;
		
		// grab referral info
		$this->db->where("id",$referral_id);
		$data['referral'] = $this->db->get("referrals")->row_array();
		
		$job_id = $data['referral']['job_id'];
		
		$data['job_id'] = $job_id;
		
		$this->db->where("job_id",$job_id);
		$data['referrals'] = $this->db->get("referrals")->result_array();
		
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		
		$data['job'] = $this->db->query($sql)->row_array();
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
                $jobtimelimit = $this->gettimeLimit($job_id);
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);
                $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
		// daily job limit
                if($data["timediff"]<=0){
                  /*  $this->delete_jobcron($job_id);
                    $j = $this->db->query("SELECT * FROM users WHERE id=".$data['job']['user_id']."")->result();
                    $sname = $j[0]->first_name." ".$j[0]->last_name;
                    $this->deletemail($value['id'],$timediff,$sname,$j[0]->email);
                    redirect("admin/jobschedule?m=jd");*/
                }
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                $data['daily_limit'] = $this->db->get("job_limit")->row_array();

		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();

		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                $this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['plan_files'] = $this->db->get("genral_files")->result_array();
                $data['percent_completed'] = $this->job->percent_completed($job_id);
                $data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']!=5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
		$data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
		
		// states array
		$data['states'] =  array('' => "- Choose a state -");
		$data['states'] += array('AK'=>"Alaska",'AL'=>"Alabama",'AR'=>"Arkansas",'AZ'=>"Arizona",'CA'=>"California",'CO'=>"Colorado",'CT'=>"Connecticut",'DC'=>"District Of Columbia",'DE'=>"Delaware",'FL'=>"Florida",'GA'=>"Georgia",'HI'=>"Hawaii",'IA'=>"Iowa",'ID'=>"Idaho",'IL'=>"Illinois", 'IN'=>"Indiana",'KS'=>"Kansas",'KY'=>"Kentucky",'LA'=>"Louisiana",'MA'=>"Massachusetts",'MD'=>"Maryland",'ME'=>"Maine",'MI'=>"Michigan",'MN'=>"Minnesota",'MO'=>"Missouri",'MS'=>"Mississippi",'MT'=>"Montana",'NC'=>"North Carolina",'ND'=>"North Dakota",'NE'=>"Nebraska",'NH'=>"New Hampshire",'NJ'=>"New Jersey",'NM'=>"New Mexico",'NV'=>"Nevada",'NY'=>"New York",'OH'=>"Ohio",'OK'=>"Oklahoma", 'OR'=>"Oregon",'PA'=>"Pennsylvania",'RI'=>"Rhode Island",'SC'=>"South Carolina",'SD'=>"South Dakota",'TN'=>"Tennessee",'TX'=>"Texas",'UT'=>"Utah",'VA'=>"Virginia",'VT'=>"Vermont",'WA'=>"Washington",'WI'=>"Wisconsin",'WV'=>"West Virginia",'WY'=>"Wyoming");
		
		// Grab referral types
		$data['referral_types'][] = '- Select a referral type -';
		$this->db->order_by('type','asc');
		$referral_types = $this->db->get("referral_types")->result_array();
		foreach($referral_types as $row)
		{
			$data['referral_types'][$row['id']] = $row['type'];
		}
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['job_id'] = $job_id;
                        $row['referral_type_id'] = $this->input->post("referral_type_id");
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
			$row['home_phone'] = $this->input->post("home_phone");
			$row['address'] = $this->input->post("address");
			$row['city'] = $this->input->post("city");
			$row['state'] = $this->input->post("state");
			$row['zip_code'] = $this->input->post("zip_code");
			$row['referral_amount'] = $this->input->post("referral_amount");
                        $row['ti9taxform'] = $this->input->post("ti9taxform");
			$row['comments'] = $this->input->post("comments");
			$this->db->where("id",$referral_id);
			$this->db->update("referrals",$row);
			
			redirect("admin/edit_referral/".$referral_id."?savedata=1");
		}
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
		$data['savedata'] =  $this->input->get("savedata");
		$this->load->view("common/header");
		$this->load->view("admin/edit_referral",$data);
		$this->load->view("common/footer");
	}
	
	function service_call($service_call_id='')
	{
		$data = array();
		
		$this->load->helper("text");
		
		if($service_call_id=='') { redirect('admin/error?e=service_call_id'); }
		
		$sql = "SELECT
			service_calls.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address
			FROM
				service_calls
			LEFT JOIN customers ON service_calls.customer_id=customers.id
			WHERE service_calls.id=".$this->db->escape($service_call_id)."
		";
		$data['service_call'] = $this->db->query($sql)->row_array();
		$data['service_call_timestamp'] = strtotime($data['service_call']['date']);
		
		// grab job files
		$this->db->where("service_call_id",$service_call_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
		
		// Grab contractors
		$data['contractors'][] = '- Select a contractor -';
		$this->db->order_by('contractor','asc');
		$contractors = $this->db->get("contractors")->result_array();
		foreach($contractors as $row) { $data['contractors'][$row['id']] = $row['contractor']; }
		
		// find other active jobs for customer that this job belongs to
		//$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		//$data['other_jobs'] = $this->db->query($sql)->result_array();
		
		// find other service calls
		$sql = "SELECT service_calls.* FROM service_calls WHERE service_calls.customer_id=".$this->db->escape($data['service_call']['customer_id'])." AND service_calls.id!=".$this->db->escape($service_call_id)." ORDER BY service_calls.date ASC";
		$data['other_service_calls'] = $this->db->query($sql)->result_array();
		
		// grab service call notes
		$data['job_notes'] = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.service_call_id=".$this->db->escape($service_call_id)." LIMIT 3")->result_array();
		
		// build times drop-down
		$start = strtotime('9:00am');
		$end = strtotime('9:00pm');

		$data['times_dd'] = array();
		for ($i = $start; $i <= $end; $i += 900)
		{
			$data['times_dd'][date('g:i a', $i)] = date('g:i a', $i);
		}
		
		// grab technician type users
		$technicians = $this->db->query("SELECT * FROM users WHERE type='installer' ORDER BY last_name ASC")->result_array();
		$data['technicians_dd'] = array();
		foreach($technicians as $key => $value)
		{
			$data['technicians_dd'][$value['id']] = $value['first_name']." ".$value['last_name'];
		}
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['technician_id'] = $this->input->post("technician_id");
			$row['repair_time'] = $this->input->post("repair_time");
			$row['repair_type'] = $this->input->post("repair_type");
			$row['description'] = $this->input->post("description");
			//$row['contractor_id'] = $this->input->post("contractor_id");
			$row['comments'] = $this->input->post("comments");
			
			$this->db->where("id",$service_call_id);
			$this->db->update("service_calls",$row);
			
			redirect("admin/service_call/".$service_call_id);
		}
		
		$this->load->view("common/header");
		$this->load->view("admin/service_call",$data);
		$this->load->view("common/footer");
	}
	
	function customer($customer_id='')
	{
		$data = array();
		
		$this->load->helper("text");
		$data['customer_id'] = $customer_id;
                if($customer_id=='') { redirect('admin/error?e=customer_id'); }
		 $data = array();
                 //$data['job_id'] = $job_id;
                 $this->load->library("job");
                 $this->load->helper("text");
                 $sql = "SELECT
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
                        customers.first_name1,
			customers.last_name1,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,customers.home_phone,customers.secondary_phone,customers.home_phone1,customers.secondary_phone1,customers.home_phone2,customers.secondary_phone2,
                        customers.household_type_id,
                        customers.email
                        
		FROM
			customers
			
		WHERE customers.id=".$this->db->escape($customer_id)."
		";
		$data['customer'] = $this->db->query($sql)->row_array();
		if(count($data['customer']) == 0){ redirect("admin/error?e=job_id"); }
		
// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['customer']['customer_id'])."  ORDER BY jobs.job_date ASC";
		$data['jobs'] = $this->db->query($sql)->result_array();
                
                $data['phone'][''] = "- Select a phone -";
                $data['phone']['home'] = "Home";
		$data['phone']['work'] = "work";
		$data['phone']['cell'] = "cell";

                
                $customer_id = $data['customer']['customer_id'];
                $data['customer_id'] = $customer_id;
		if($customer_id=='') { redirect('admin/error?e=customer_id'); }

		$data['states'] =  array('' => "- Choose a state -");
		$data['states'] += array('AK'=>"Alaska",'AL'=>"Alabama",'AR'=>"Arkansas",'AZ'=>"Arizona",'CA'=>"California",'CO'=>"Colorado",'CT'=>"Connecticut",'DC'=>"District Of Columbia",'DE'=>"Delaware",'FL'=>"Florida",'GA'=>"Georgia",'HI'=>"Hawaii",'IA'=>"Iowa",'ID'=>"Idaho",'IL'=>"Illinois", 'IN'=>"Indiana",'KS'=>"Kansas",'KY'=>"Kentucky",'LA'=>"Louisiana",'MA'=>"Massachusetts",'MD'=>"Maryland",'ME'=>"Maine",'MI'=>"Michigan",'MN'=>"Minnesota",'MO'=>"Missouri",'MS'=>"Mississippi",'MT'=>"Montana",'NC'=>"North Carolina",'ND'=>"North Dakota",'NE'=>"Nebraska",'NH'=>"New Hampshire",'NJ'=>"New Jersey",'NM'=>"New Mexico",'NV'=>"Nevada",'NY'=>"New York",'OH'=>"Ohio",'OK'=>"Oklahoma", 'OR'=>"Oregon",'PA'=>"Pennsylvania",'RI'=>"Rhode Island",'SC'=>"South Carolina",'SD'=>"South Dakota",'TN'=>"Tennessee",'TX'=>"Texas",'UT'=>"Utah",'VA'=>"Virginia",'VT'=>"Vermont",'WA'=>"Washington",'WI'=>"Wisconsin",'WV'=>"West Virginia",'WY'=>"Wyoming");

		

		// find existing, other customers with this address...
		

		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['customer_type_id'] = $this->input->post("customer_type_id");
			$row['household_type_id'] = $this->input->post("household_type_id");
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
                        $row['first_name1'] = $this->input->post("spouse_firstname");
			$row['last_name1'] = $this->input->post("spouse_lastname");
			$row['home_phone'] = $this->input->post("home_phone");
			$row['secondary_phone'] = $this->input->post("secondary_phone");
                        $row['home_phone1'] = $this->input->post("home_phone1");
			$row['secondary_phone1'] = $this->input->post("secondary_phone1");
                        $row['home_phone2'] = $this->input->post("home_phone2");
			$row['secondary_phone2'] = $this->input->post("secondary_phone2");
			$row['email'] = $this->input->post("email");
			$row['address'] = $this->input->post("address");
			$row['city'] = $this->input->post("city");
			$row['state'] = $this->input->post("state");
			$row['zip_code'] = $this->input->post("zip_code");
                        $row['billing_address'] = $this->input->post("billing_address");
			$row['billing_city'] = $this->input->post("billing_city");
			$row['billing_state'] = $this->input->post("billing_state");
			$row['billing_zip_code'] = $this->input->post("billing_zip_code");

			$row['different_billing_address'] = $this->input->post("is_billing_address");
                        $row['neighborhood'] = $this->input->post("neighborhood");
			$row['association'] = $this->input->post("association");
			$row['household_members'] = $this->input->post("household_members");
			$row['avg_electric_bill'] = $this->input->post("avg_electric_bill");
			$row['sun_zone'] = $this->input->post("sun_zone");
			$row['cust_tmk'] = $this->input->post("cust_tmk");
                        $row['cust_bpan'] = $this->input->post("cust_bpan");
                        $row['heco_account_number'] = $this->input->post("heco_account_number");
			$row['heco_meter_number'] = $this->input->post("heco_meter_number");
			$row['comments'] = $this->input->post("comments");
                       
			$this->db->where("id",$customer_id);
			$this->db->update("customers",$row);

			redirect("admin/customer/".$customer_id."?savedata=1");
                }
                $sql = "SELECT * FROM household_types ORDER BY `type` ASC";
		$htypes = $this->db->query($sql)->result_array();
		$data['household_types'][] = '- Choose a household type';
		foreach($htypes as $h)
		{
			$data['household_types'][$h['id']] = $h['type'];
		}
		 global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $data['savedata'] =  $this->input->get("savedata");
                $data['errordata'] =  $this->input->get("errordata");
                $this->db->where("id",$customer_id);
		$data['customer'] = $this->db->get("customers")->row_array();
                $this->load->view("common/header");
		$this->load->view("admin/customer_new",$data);
		$this->load->view("common/footer");
	}
	
	function customer_jobs($customer_id='')
	{
		$data = array();
			
		$this->load->view("common/header");
		$this->load->view("admin/customer_jobs",$data);
		$this->load->view("common/footer");
	}
	
	function profile()
	{
		$data = array();
                $this->load->helper("thumbnail_helper");
		$data['validation_errors'] = false;
		$data['updated'] = false;
		
		// grab user data for form
		$data['user'] = $this->db->query("SELECT * FROM users WHERE id=".$this->db->escape($this->session->userdata("user_id")))->row_array();
		
		if($this->input->post("dosubmit"))
		{
			$this->load->library('validation');
			
			if($this->input->post("email") != $this->session->userdata("email")) 
			{
				$rules['email']	= "required|valid_email|callback_email_exists";
			} 
			else 
			{
				$rules['email']	= "required|valid_email";
			}

			$rules['first_name']	= "required";
			$rules['last_name']	= "required";
                        $rules['uname']	= "alpha_numeric|callback_uname_exists";
			if($this->input->post("new_password"))
			{
				$rules['password'] = "callback_password_check";
				$rules['new_password']	= "required|matches[new_password2]";
				$rules['new_password2']	= "required";
			}
			
			$this->validation->set_rules($rules);
			
			$fields['password']	= 'Password';
			$fields['new_password']	= 'New Password';
			$fields['new_password2'] = 'New Password Confirmation';
			$fields['email'] = 'Email Address';
			$fields['first_name'] = 'First Name';
			$fields['last_name'] = 'Last Name';
                        $field['uname'] = "User Name";

			$this->validation->set_fields($fields);

			if ($this->validation->run() == FALSE)
			{
				$data['validation_errors'] = true;
			}
			else
			{
				$data['updated'] = true;
				$row = array();
				$row['email'] = $this->input->post("email");
				$row['first_name'] = $this->input->post("first_name");
				$row['last_name'] = $this->input->post("last_name");
                                $row['uname'] = $this->input->post("uname");
                                $row['phone']= $this->input->post("phone");
				if($this->input->post("new_password"))
				{
					$row['password'] = md5($this->input->post("new_password"));
				}
				$this->db->where("id",$this->session->userdata("user_id"));
				$this->db->update("users",$row);
				
				// grab updated user data for form
				$data['user'] = $this->db->query("SELECT * FROM users WHERE id=".$this->db->escape($this->session->userdata("user_id")))->row_array();
				$this->session->set_userdata('email', $this->input->post("email"));
			}
		}
		
		$this->load->view("common/header");
		$this->load->view("admin/profile",$data);
		$this->load->view("common/footer");
	}
	
	function search()
	{
		$data = array();
		$data['keywords'] = $this->input->get("q");
		$data['search_results'] = $this->db->query("SELECT customers.* FROM customers WHERE customers.first_name LIKE '%".mysql_escape_string($data['keywords'])."%' OR customers.last_name LIKE '%".mysql_escape_string($data['keywords'])."%' OR customers.address LIKE '%".mysql_escape_string($data['keywords'])."%'")->result_array();
		$this->load->library('pagination');
              /*  print_r($this->session);
                $config['base_url'] = 'http://example.com/index.php/test/page/';
                $config['total_rows'] = 200;
                $config['per_page'] = 20;
                $this->pagination->initialize($config);
                echo $this->pagination->create_links();*/
		$this->load->view("common/header");
		$this->load->view("admin/search",$data);
		$this->load->view("common/footer");
	}
	
	function news()
	{
		$data = array();
			
		$this->load->view("common/header");
		$this->load->view("admin/news",$data);
		$this->load->view("common/footer");
	}
	
	function view_news($news_id)
	{
		$data = array();
			
		$this->load->view("common/header");
		$this->load->view("admin/view_news",$data);
		$this->load->view("common/footer");
	}
	
	function myjobs()
	{
		$data = array();
		
		$this->load->helper("date");
		$this->load->helper("text");
		$this->load->library("job");
	        $this->load->library('pagination');
                $this->load->helper('url');
                $urlstring =  array();
                $urlstring = explode("&per_page=",$_SERVER["QUERY_STRING"]);
                if(count($urlstring)==1){$urlstring[0] = "q=0".$urlstring[0]; }
                $config['base_url'] = base_url()."admin/myjobs?".$urlstring[0];
               // print_R();
		$yearmonth = $this->input->get("yearmonth");
		$day = $this->input->get("day");
		$endyearmonth = $this->input->get("endyearmonth");
		$endday = $this->input->get("endday");
                $data['filterdata'] = true;
		if($yearmonth=='' &&  $endyearmonth==''&& $yearmonth==0 &&  $endyearmonth==0){
                    $data['filterdata'] =false;
                }
		if($yearmonth=='' || $yearmonth==0 ) {$yearmonth = (date("Y")-1)."01";}
		if($day=='' || $day==0) {$day = "01";}
		$yearmonth = preg_replace("/[^0-9]/","",$yearmonth);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['yearmonth'] = $yearmonth;
		$data['day'] = $day;
		
		if($endyearmonth=='' || $endyearmonth==0 ) {$endyearmonth = (date("Y")+3)."12";}
		if($endday=='' || $endday==0 ) {$endday = "31";}
		$endyearmonth = preg_replace("/[^0-9]/","",$endyearmonth);
		$endday = preg_replace("/[^0-9]/","",$endday);
		$data['endyearmonth'] = $endyearmonth;
		$data['endday'] = $endday;
		$salesuserg = $this->input->get("salesuser");
                $sql_saleuser = "";
                if ($salesuserg!=-1 && $salesuserg!="") {
                  $sql_saleuser = " AND (jobs.user_id =".$salesuserg." OR  FIND_IN_SET(".$this->db->escape($salesuserg).",contractor_id) OR FIND_IN_SET(".$this->db->escape($salesuserg).",installer_id) OR FIND_IN_SET(".$this->db->escape($salesuserg).",designer_id) )";
                  $data['salesuser'] = $salesuserg;
                }
                
                $statususerg = $this->input->get("statususer");
                $sql_statususer = "";
                if ($statususerg!=-1 && $statususerg!="") {
                  $sql_statususer = " AND jobs.current_status ='".$statususerg."' ";
                  $data['statususer'] = $statususerg;
                }
                
		$limit = $this->input->get("limit");
                
		if($limit > 30 )
		{
			$limit = 30;
		}
		if($limit == 'all' )
		{
			$limit = '9999';
		}
                if($limit == '' || !isset($limit))
		{
			$limit = 30;
		}
                $data['limit'] = $limit;
		if($limit == '9999') {
                    $data['limit'] = 'all';
                }
		$extra_jobs_sql = '';
		$extra_sc_sql = '';
                $data['editjob'] = true;
                $pv_sql = "";
		if($this->session->userdata("role") != 'admin' )
		{
		 $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                 $pv_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                 $extra_sc_sql = " AND service_calls.user_id=".$this->db->escape($this->session->userdata("user_id")); 
		}
                if( $this->session->userdata("role") == 'installer')
		{
		  $pv_sql = " AND  FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",installer_id)";
                  $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $extra_sc_sql = " AND service_calls.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $data['editjob'] = false;
		}
                  if( $this->session->userdata("role") == 'contractor')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",contractor_id)";
                  $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $data['editjob'] = false;
		}
                 if( $this->session->userdata("role") == 'designer')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",designer_id)";
                  $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $data['editjob'] = false;
		}
                   $pv_sql .= $sql_saleuser.$sql_statususer;

		$config['per_page'] = $limit;
		// get jobs and service calls matching desired dates
		// get jobs and service calls matching desired dates
		$perpage = $this->input->get("per_page")>=1?$this->input->get("per_page"):0;
                $sql_date = "";
                if($data['filterdata']){
                   $sql_date = " AND DATE_FORMAT(jobs.job_date,'%Y%m%d') >= '".$data['yearmonth'].$data['day']."' AND DATE_FORMAT(jobs.job_date,'%Y%m%d') <= '".$data['endyearmonth'].$data['endday']."'" ;
                }
                $sql = "SELECT jobs.*, customers.first_name, customers.last_name, customers.address, customers.city, customers.state, job_types.intials as job_type,users.first_name as userfirstname ,users.last_name as userlastname  FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.current_status!='unscheduled'  $sql_date  $pv_sql   ORDER by jobs.job_date limit ".$perpage." , ".$config['per_page'];
		//die(print($sql));
		$jobs = $this->db->query($sql)->result_array();
                $sql_cnt = "SELECT COUNT(*) AS numrows FROM jobs LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE DATE_FORMAT(jobs.job_date,'%Y%m%d') >= '".$data['yearmonth'].$data['day']."' AND DATE_FORMAT(jobs.job_date,'%Y%m%d') <= '".$data['endyearmonth'].$data['endday']."'   $pv_sql";
                $jobcnt = $this->db->query($sql_cnt)->result_array();
                $config['total_rows'] = $jobcnt[0]["numrows"];
                $this->pagination->initialize($config);
                $data["links"] = $this->pagination->create_links();
                $sql_u = "SELECT jobs.*, customers.first_name, customers.customer_type_id,customers.last_name, customers.address, customers.city, customers.state, job_types.intials as job_type,users.first_name as userfirstname ,users.last_name as userlastname FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE  current_status='unscheduled'  $pv_sql";
		//die(print($sql));
		$jobs_u = $this->db->query($sql_u)->result_array();
                $data['jobs_u'] = $jobs_u;
		$sql = "SELECT service_calls.*, customers.first_name, customers.last_name, customers.address, customers.city, customers.state FROM service_calls LEFT JOIN customers ON service_calls.customer_id=customers.id WHERE DATE_FORMAT(service_calls.date,'%Y%m%d') >= '".$data['endyearmonth'].$data['day']."' AND DATE_FORMAT(service_calls.date,'%Y%m%d') <= '".$data['endyearmonth'].$data['endday']."' $extra_sc_sql";
		$service_calls = $this->db->query($sql)->result_array();
		#die(print_r($jobs));
		$data['jobs'] = array();
                $user_id  = array();
                $salesuser = array();
                $statususer = array();
                $statususer["-1"] = "All";
                $salesuser["-1"] = "All";
		$ppfile = array();
                $pmfile =array();
                $tppfile = array();
                $tpmfile = array();
                $tpermitfile = array();
                $skfile = array();
                $tskfile = array();
                $this->db->order_by("created","desc");
		$ppfile = $this->db->get("genral_files")->result_array();
                foreach($ppfile as $ppfilekey => $ppfilevalue){
                    $tppfile[$ppfilevalue['job_id']] = $ppfilevalue;
                }

                $pp_users = array();
                $this->db->where("type",'designer');
		$ppsql = $this->db->get("users")->result_array();
                $pp_users[0] ="-";
                foreach($ppsql as $ppsqlkey => $ppsqlvalue){
                  $pp_users[$ppsqlvalue['id']] = ucfirst(substr($ppsqlvalue['first_name'],0,1)).ucfirst(substr($ppsqlvalue['last_name'],0,1));
                }

                $data["pp_users"] =  $pp_users;
                $this->db->order_by("created","desc");
		$pmfile = $this->db->get("presale_files")->result_array();
                foreach($pmfile as $pmfilekey => $pmfilevalue){
                  $tpmfile[$pmfilevalue['job_id']] = $pmfilevalue;
                }
                $this->db->order_by("created","desc");
		$permitfile = $this->db->get("permit_files")->result_array();
                foreach($permitfile as $pmfilekey => $pmfilevalue){
                  $tpermitfile[$pmfilevalue['job_id']] = $pmfilevalue;
                }
                $this->db->order_by("created","desc");
		$skfile = $this->db->get("sketch_files")->result_array();
                foreach($skfile as $pmfilekey => $pmfilevalue){
                  $tskfile[$pmfilevalue['job_id']] = $pmfilevalue;
                }
                foreach($jobs as $key => $job)
		{
		    $salesuser[$job['user_id']]  =  ucfirst($job['userfirstname'])." ".ucfirst($job['userlastname'])."(S)";
                    if(isset($job["designer_id"]) && $job["designer_id"]!=""){
                       $exp_user = explode(",",$job["designer_id"]);
                       foreach( $exp_user as $user){
                        if($user==0 || $user=='') continue;
                        $salesuser[$user] = $this->getUserIntial($user,true)."(De)";
                       }
                    }
                    $temp_elec = array();
                    if(isset($job["contractor_id"]) && $job["contractor_id"]!=""){

                        $exp_user = explode(",",$job["contractor_id"]);
                       foreach( $exp_user as $user){
                        if($user==0 || $user=='') continue;
                         $salesuser[$user] = $this->getUserIntial($user,true)."(C)";
                         $temp_elec[]= $this->getUserIntial($user,false);

                       }
                        $job["contractor_id"] = implode(",",$temp_elec);
                    } else{
                        $job["contractor_id"] = "-";
                    }
                    if(isset($job["installer_id"]) && $job["installer_id"]!=""){
                       $exp_user = explode(",",$job["installer_id"]);
                       foreach( $exp_user as $user){
                           if($user==0 || $user=='') continue;
                           $salesuser[$user] = $this->getUserIntial($user,true)."(I)";
                       }
                    }
                     if ($job['current_status']!="" && $job['current_status'] !=null){
                        $statususer[$job['current_status']] = ucfirst($job['current_status']);
                       }
                    if($job['current_status']=='inprogress' || $job['current_status']=="") {
                        $percent_completed = $this->job->percent_completed($job['id']);
                        $jobtimelimit = $this->gettimeLimit($job['id']);
                        $timediff =  (int) ($jobtimelimit-(int)(time()-strtotime($job['created']))/3600);
                        $jobtimelimit1 = $this->getexttimeLimit($job['id']);
                        if($jobtimelimit1){
                          if($timediff>=0){
                             $timediff +=$jobtimelimit1;
                          }else{
                              $timediff = $jobtimelimit1;
                          }

                       }
                        $job['current_status']="<font color='red'>".$percent_completed."%, ".$timediff."hrs remaining</font>";
                      }
                      $output_download = "";
                      if(array_key_exists($job['job_pid'],$tskfile) &&  $this->session->userdata('ofp')==1){
                          $output_download= " <a href='".base_url()."admin/downloadsketch/".$tskfile[$job['job_pid']]['id']."' >Yes</a>";
                      } else {
                          $output_download= "  No";
                      }
                      if(array_key_exists($job['job_pid'],$tpmfile) &&  $this->session->userdata('ofp')==1){
                          if($tpmfile[$job['job_pid']]['notification'])
                          $output_download.= " / <a href='".base_url()."admin/downloadpresale/".$tpmfile[$job['job_pid']]['id']."' class='greendot'>Yes&nbsp;&nbsp;</a>";
                          else
                          $output_download.= " / <a href='".base_url()."admin/downloadpresale/".$tpmfile[$job['job_pid']]['id']."' class='reddot'>Yes&nbsp;&nbsp;</a>";
                      } else{
                          $output_download.= " / No";
                      }
                      if(array_key_exists($job['job_pid'],$tppfile) &&( $this->session->userdata('ppdp')==1 || $this->session->userdata('ppup')==1)){
                          $output_download .= "/ <a href='".base_url()."admin/downloadplan/".$tppfile[$job['job_pid']]['id']."'>Yes</a>";
                      } else {
                          $output_download .= "/ No";
                      }
                     
                      $job["pppm"] = $output_download;

                      $poutput_download = "";
                      $building = false;
                      $netmeter = false;
                      $homeowner = false;
                      $bid = 0;
                      $nid=0;
                      $hid=0;
                      if(array_key_exists($job['job_pid'],$tpermitfile) ){
                          
                          foreach($permitfile as $pmfilekey => $pmfilevalue){
                             if($pmfilevalue['job_id'] == $job['job_pid'] && trim($pmfilevalue['type'])=="building"  ){
                                 $building = true;
                                 $bid = $pmfilevalue['id'];
                             }
                             if($pmfilevalue['job_id'] == $job['job_pid'] && trim($pmfilevalue['type'])=="netmeter"  ){
                                 $netmeter = true;
                                 $nid = $pmfilevalue['id'];
                             }
                             if($pmfilevalue['job_id'] == $job['job_pid'] && trim($pmfilevalue['type'])=="homeowner"  ){
                                 $homeowner = true;
                                 $hid = $pmfilevalue['id'];
                             }
                           }
                      }
                      if($building){
                          $poutput_download= " <a href='".base_url()."admin/downloadpermit/".$bid."' >Yes</a>";
                      } else {
                          $poutput_download= " No";
                      }
                      if($netmeter){
                        $poutput_download.= " / <a href='".base_url()."admin/downloadpermit/".$nid."' >Yes&nbsp;&nbsp;</a>";
                      } else{
                          $poutput_download.= " / No";
                      }
                      if($homeowner){
                          $poutput_download .= "/ <a href='".base_url()."admin/downloadpermit/".$hid."'>Yes</a>";
                      } else {
                          $poutput_download .= "/ No";
                      }
                      $job["pert_file"] = $poutput_download;
                     /** if(isset($job["designer_id"])&& $job["designer_id"] && $job["designer_id"]!=""){
                       $job["designer_id"] = $this->getUserIntial($job["designer_id"],false);
                      }else{
                          $job["designer_id"] = "-";
                      }*/
                      $data['jobs'][strtotime($job['job_date'])][] = $job;
                     
		}
		foreach($service_calls as $key => $service_call)
		{
			$data['jobs'][strtotime($service_call['date'])][] = $service_call;
		}
		ksort($data['jobs']);
		$data['salesuserd'] = $salesuser;
                $data['statususerd'] =$statususer;
		// get unique month/year's logged-in user has jobs on
		$sql = "SELECT DISTINCT DATE_FORMAT(jobs.job_date,'%Y%m') as yearmonth, job_date FROM jobs WHERE id != '0' AND jobs.job_date is not null   $pv_sql ORDER BY yearmonth ASC";
		#die(print($sql));
		$job_months = $this->db->query($sql)->result_array();
		$service_call_months = $this->db->query("SELECT DISTINCT DATE_FORMAT(service_calls.date,'%Y%m')  as yearmonth, date FROM service_calls WHERE id !='0' $extra_sc_sql ORDER BY yearmonth ASC")->result_array();

		$data['calendar_months'] = ($job_months + $service_call_months);
		
		//$data['calendar_months'] = array_unique($data['calendar_months']);
		
		$data['year_month_dd'] = array();
                //$data['year_month_dd'] = array('ALL');
		foreach($data['calendar_months'] as $ym)
		{
			if (@$ym['date']) {
				// only add yearmonth combos that are new
				if(!array_key_exists(date("M Y",strtotime($ym['date'])),$data['year_month_dd']))
				{
					$data['year_month_dd'][$ym['yearmonth']] = date("M Y",strtotime($ym['date']));
				}
			} else {
				if(!array_key_exists(date("M Y",strtotime($ym['job_date'])),$data['year_month_dd']))
				{
					$data['year_month_dd'][$ym['yearmonth']] = date("M Y",strtotime($ym['job_date']));
				}
			}
		}
		
		// day drop down
		$days_count = days_in_month(substr($yearmonth,-2,2),substr($yearmonth,0,4));
		//$data['day_dd'] =  array('All');
                for($i=1; $i<$days_count+1; $i++)
		{
			$data['day_dd'][sprintf("%02d",$i)] = sprintf("%02d",$i);
		}
		
		// limit drop-down
		$data['limit_dd']['5'] = '5';
		$data['limit_dd']['10'] = '10';
		$data['limit_dd']['20'] = '20';
		$data['limit_dd']['30'] = '30';
                $data['limit_dd']['all'] = 'all';
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
		 $data["year"] = date("Y");
                $data["month"] = date("n");
                if(!$this->session->userdata('access')){
                     $data['editjob'] = false;
                }
		$this->load->view("common/header");
		$this->load->view("admin/myjobs",$data);
		$this->load->view("common/footer");
	}
	
	function users()
	{
		if($this->session->userdata("role") != 'admin')
		{
			redirect("admin/error?e=permissions");
		}
		
		$data = array();
		$data['email_sort']='desc';
                $data['firstname_sort']='asc';
                $data['lastname_sort']='desc';
                $data['empno_sort']='desc';
                $data['role_sort']='desc';
                $sortorder = "asc";
                $sort_column = "users.last_name";
                if($this->input->get("q")=="email"  ){
                  $sort_column = "users.email";
                  $sortorder = $this->input->get("email_sort");
                 if($this->input->get("email_sort")=='desc')
                    $data['email_sort']='asc';
                 else
                   $data['email_sort']='desc';
                  
                }else if($this->input->get("q")=="first_name" ){
                    $sort_column = "users.first_name";
                    $sortorder = $this->input->get("firstname_sort");
                    if($this->input->get("firstname_sort")=='asc')
                    $data['firstname_sort']='desc';
                 else
                   $data['firstname_sort']='asc';

                } else if($this->input->get("q")=="last_name" ){
                  $sort_column = "users.last_name";
                  $sortorder = $this->input->get("lastname_sort");
                  if($this->input->get("lastname_sort")=='desc')
                    $data['lastname_sort']='asc';
                 else
                   $data['lastname_sort']='desc';
                } else if($this->input->get("q")=="emp_no"){
                    $sort_column = "users.emp_num";
                    $sortorder = $this->input->get("empno_sort");
                    if($this->input->get("empno_sort")=='desc')
                        $data['empno_sort']='asc';
                    else
                        $data['empno_sort']='desc';
                }
                 else if($this->input->get("q")=="role"){
                    $sort_column = "  CASE type
                                    WHEN 'admin' THEN 1            
                                    WHEN 'conduit' THEN 2
                                    WHEN 'contractor' THEN 3 
                                    WHEN 'installer' THEN 4
                                    WHEN 'sales' THEN 5
                                    END";
                    $sortorder = $this->input->get("role_sort");
                    if($this->input->get("role_sort")=='desc')
                        $data['role_sort']='asc';
                    else
                        $data['role_sort']='desc';
                }
                if ($this->input->get("q")){
                    $data["divshow"] = $this->input->get("q");
                } else {
                   $data["divshow"] = "last_name" ;
                }
		$sql_order = " ORDER BY $sort_column $sortorder";
                $data['users'] = $this->db->query("SELECT users.*, colors.nickname as color, colors.hex,ns.notification FROM users LEFT JOIN colors ON users.color_id=colors.id  LEFT JOIN notification_setting ns ON  users.id = ns.user_id $sql_order")->result_array();
                $this->load->view("common/header");
		$this->load->view("admin/users",$data);
		$this->load->view("common/footer");
	}
	
	function edit_user($user_id='',$updated = false)
	{
		$data = array();
		
		/*if($this->input->get("updated"))
		{
			$data['updated'] = true;
		}*/
		$data['updated'] = $updated;
		if($this->input->post("dosubmit"))
		{
			$this->load->library('validation');

			if($this->input->post("email") != $this->session->userdata("email"))
			{
				$rules['email']	= "required|valid_email|callback_email_exists";
			}
			else
			{
				$rules['email']	= "required|valid_email";
			}

			$rules['first_name']	= "required";
			$rules['last_name']	= "required";
                        $rules['uname']	= "alpha_numeric|callback_uname_exists";
                        $rules['emp_number'] = "numeric|callback_empnumber_exists";
			$this->validation->set_rules($rules);
			$fields['password']	= 'Password';
			$fields['new_password']	= 'New Password';
			$fields['new_password2'] = 'New Password Confirmation';
			$fields['email'] = 'Email Address';
			$fields['first_name'] = 'First Name';
			$fields['last_name'] = 'Last Name';
                        $field['uname'] = "User Name";
                        $field['emp_number'] =  "Employee number";
			$this->validation->set_fields($fields);

			if ($this->validation->run() == FALSE)
			{
				$data['validation_errors'] = true;
			}
			else
			{
                        $row = array();
                        $row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
			$row['color_id'] = $this->input->post("color_id");
			$row['type'] = $this->input->post("type");
			$row['uname'] = $this->input->post("uname");
                        $row['email'] = $this->input->post("email");
                        $row['is_editjob'] = $this->input->post("editjob");
			$row['emp_num']= $this->input->post("emp_number");
			$row['custom_hex'] = $this->input->post("custom_hex");
                        $row['plotplanuploaded'] = $this->input->post("plotplanuploaded");
			$row['plotplandownloaded'] = $this->input->post("plotplandownloaded");
                        $row['otheruploaddown']= $this->input->post("otheruploaddown");
			if ($this->input->post("installer_permissions") == 'y') {
				$row['installer_permissions'] = 'y';
			} else {
				$row['installer_permissions'] = 'n';
			}
			if($this->input->post("password"))
			{
				$row['password'] = md5($this->input->post("password"));
			}
			$this->db->where("id",$user_id);
			$this->db->update("users",$row);
			
			// update session data
			if($user_id == $this->session->userdata("user_id"))
			{
				$sql = "SELECT colors.* FROM colors WHERE id=".$this->db->escape($this->input->post("color_id"));
				$color = $this->db->query($sql)->row_array();
				
				if(@$row['custom_hex'] != '')
				{
					$hex = $row['custom_hex'];
				}
				else
				{
					if(@$row['type'] == 'admin')
					{			
						$hex = '7DBB4C';
					}
					else
					{
						$hex = $color['hex'];
					}
				}
				
				$this->session->set_userdata('role', $row['type']);
				$this->session->set_userdata('hex_color', $hex);
			}
			
			redirect("admin/edit_user/".$user_id."/true");
                        }
		}
		
		$data['user'] = $this->db->query("SELECT users.*, colors.nickname as color, colors.hex FROM users LEFT JOIN colors ON users.color_id=colors.id WHERE users.id=".$this->db->escape($user_id)." ORDER BY users.last_name ASC")->row_array();
                
		$data['roles'] = array();
		$data['roles']['admin'] = 'Admin';
		$data['roles']['sales'] = 'Salesperson';
		$data['roles']['installer'] = 'Installer';
                $data['roles']['contractor'] = 'Contractor';
                $data['roles']['designer'] = 'Designer';
		//$data['roles']['conduit'] = 'Conduit';
		$data['colors'] = $this->db->get("colors")->result_array();

		$this->load->view("common/header");
		$this->load->view("admin/edit_user",$data);
		$this->load->view("common/footer");
	}
	
	function new_user()
	{
		$data = array();
		
		if($this->input->post("dosubmit"))
		{
			$this->load->library('validation');
			
			if($this->input->post("email") != $this->session->userdata("email")) 
			{
				$rules['email']	= "required|valid_email|callback_email_exists";
			} 
			else 
			{
				$rules['email']	= "required|valid_email";
			}

			$rules['first_name']	= "required";
			$rules['last_name']	= "required";
                        $rules['uname']	= "alpha_numeric|callback_uname_exists";
                        $rules['emp_number'] = "numeric|callback_empnumber_exists";
			$this->validation->set_rules($rules);
			$fields['password']	= 'Password';
			$fields['new_password']	= 'New Password';
			$fields['new_password2'] = 'New Password Confirmation';
			$fields['email'] = 'Email Address';
			$fields['first_name'] = 'First Name';
                        $field['uname'] = "User Name";

			$this->validation->set_fields($fields);

			if ($this->validation->run() == FALSE)
			{
				$data['validation_errors'] = true;
			}
			else
			{

                        $row = array();
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
			$row['uname'] = $this->input->post("uname");
                        $row['color_id'] = $this->input->post("color_id");
			$row['type'] = $this->input->post("type");
			$row['email'] = $this->input->post("email");
                        $row['is_editjob'] = $this->input->post("editjob");
			$row['custom_hex'] = $this->input->post("custom_hex");
                        $row['emp_num']= $this->input->post("emp_number");
                        $row['plotplanuploaded'] = $this->input->post("plotplanuploaded");
			$row['plotplandownloaded'] = $this->input->post("plotplandownloaded");
                        $row['otheruploaddown']= $this->input->post("otheruploaddown");
                       	if($this->input->post("password"))
			{
				$row['password'] = md5($this->input->post("password"));
			}

			$this->db->insert("users",$row);
			redirect("admin/users");
                        }
		}

		$data['roles'] = array();
		$data['roles']['admin'] = 'Admin';
		$data['roles']['sales'] = 'Salesperson';
		$data['roles']['installer'] = 'Installer';
                $data['roles']['contractor'] = 'Contractor';
                $data['roles']['designer'] = 'Designer';
		//$data['roles']['conduit '] = 'Conduit ';
		$data['colors'] = $this->db->get("colors")->result_array();

		$this->load->view("common/header");
		$this->load->view("admin/new_user",$data);
		$this->load->view("common/footer");
	}
	
	function delete_user($user_id)
	{
		if($this->session->userdata("role") == 'admin')
		{
			$this->db->where("id",$user_id);
			$this->db->delete("users");
                        $this->db->where("modified_by",$user_id);
                        $row = array();
                        $row['modified_by']=$this->session->userdata("user_id") ;
			$this->db->update("jobs",$row);
                        $this->db->where("user_id",$user_id);
                        $row = array();
                        $row['user_id']=$this->session->userdata("user_id") ;
			$this->db->update("jobs",$row);
			redirect("admin/users");

		}
		else
		{
			redirect("admin/error?e=permissions");
		}
	}
	function delete_customer($cust_id)
	{
		if($this->session->userdata("role") == 'admin')
		{
			$this->db->where("id",$cust_id);
			$this->db->delete("customers");
                        $this->db->where("customer_id",$cust_id);
			$this->db->delete("jobs");
			redirect("admin/jobschedule");
		}
		else
		{
			redirect("admin/error?e=permissions");
		}
	}
	function password_check($password)
	{
		$row = $this->db->query("SELECT * FROM users WHERE password=".($this->db->escape(md5($this->input->post("password"))))." AND email=".$this->db->escape($this->input->post("email")))->row_array();
		
		if (count($row) == 0)
		{
			$this->validation->set_message('password_check', 'Current password is incorrect');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	function email_exists($email)
	{
		$sql_user = "";
                if ($this->input->post("user_id")){
                    $sql_user = " AND id !=".$this->input->post("user_id");
                }
                $row = $this->db->query("SELECT * FROM users WHERE email=".$this->db->escape($this->input->post("email"))."$sql_user")->row_array();
		if (count($row) > 0)
		{
			$this->validation->set_message('email_exists', 'That email address already exists');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	function uname_exists($email)
	{
		$sql_user = "";
                if ($this->input->post("user_id")){
                    $sql_user = " AND id !=".$this->input->post("user_id");
                }
                $row = $this->db->query("SELECT * FROM users WHERE id !=".$this->db->escape($this->session->userdata("user_id"))." AND  uname=".$this->db->escape($this->input->post("uname"))."$sql_user")->row_array();
		if (count($row) > 0)
		{
			$this->validation->set_message('uname_exists', 'That UserName already exists.');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
        function empnumber_exists($empno){
               $sql_user = "";
                if ($this->input->post("user_id")){
                    $sql_user = " AND id !=".$this->input->post("user_id");
                }
                if(!$this->input->post("emp_number")){
                    return true;
                }
                $row = $this->db->query("SELECT * FROM users WHERE id !=".$this->db->escape($this->session->userdata("user_id"))." AND  emp_num=".$this->db->escape($this->input->post("emp_number"))." $sql_user")->row_array();
		if (count($row) > 0)
		{
			$this->validation->set_message('empnumber_exists', 'That Employee Number is  already exists.');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
        }
	function download($file_id='')
	{
		$this->load->helper('download');
		
		$this->db->where('id',$file_id);
		$file = $this->db->get("files")->row_array();
		
		$data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/uploads/".$file['unique_filename']); // Read the file's contents
		$name = $file['original_filename'];

		force_download($name, $data);
	}
        function downloadplan($file_id='')
	{
            $this->load->helper('download');
            $this->db->where('id',$file_id);
            $file = $this->db->get("genral_files")->row_array();
            $data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/uploads/".$file['unique_filename']); // Read the file's contents
            $name = $file['original_filename'];
            force_download($name, $data);
	}
        function downloadsketch($file_id='')
	{
            $this->load->helper('download');
            $this->db->where('id',$file_id);
            $file = $this->db->get("sketch_files")->row_array();
            $data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/uploads/".$file['unique_filename']); // Read the file's contents
            $name = $file['original_filename'];
            force_download($name, $data);
	}
        function downloadpresale($file_id='')
	{
            $this->load->helper('download');
            $this->db->where('id',$file_id);
            $file = $this->db->get("presale_files")->row_array();
            $data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/uploads/".$file['unique_filename']); // Read the file's contents
            $name = $file['original_filename'];
            force_download($name, $data);
	}
        function downloadfiletab($file_id='')
	{
            $this->load->helper('download');
            $this->db->where('id',$file_id);
            $file = $this->db->get("meter_files")->row_array();
            $data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/scheduler/uploads/".$file['unique_filename']); // Read the file's contents
            $name = $file['original_filename'];
            force_download($name, $data);
	}
        function downloadpermit($file_id=''){
            $this->load->helper('download');
            $this->db->where('id',$file_id);
            $file = $this->db->get("permit_files")->row_array();
            $data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/uploads/".$file['unique_filename']); // Read the file's contents
            $name = $file['original_filename'];
            force_download($name, $data);
	}
        function downloadelecphoto($file_id='')
	{
            $this->load->helper('download');
            $this->db->where('id',$file_id);
            $file = $this->db->get("elecphoto_files")->row_array();
            $data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/scheduler/uploads/".$file['unique_filename']); // Read the file's contents
            $name = $file['original_filename'];
            force_download($name, $data);
	}
         function viewelecphotofile($file_id='')
	{
             $this->load->helper("thumbnail_helper");
            $this->db->where('id',$file_id);
            $file = $this->db->get("elecphoto_files")->row_array();
            $src_pth = $file['unique_filename'];
            echo '<img src="'.thumbnail($src_pth, 250, 250).'"/>';
            
	}
	function config()
	{
		if($this->session->userdata("role") != 'admin')
		{
			redirect("admin/error?e=permissions");
		}
		$data = array();
		$data['tables'] = array();
		$data['tables']['fan_brands'] = array('fkey' => 'brand');
		$data['tables']['fan_sizes'] = array('fkey' => 'size');
		$data['tables']['installation_types'] = array('fkey' => 'type');
		//$data['tables']['inverter_brands'] = array('fkey' => 'brand');
		//$data['tables']['inverter_types'] = array('fkey' => 'type');
		//$data['tables']['module_brands'] = array('fkey' => 'brand');
		//$data['tables']['module_powers'] = array('fkey' => 'power');
		$data['tables']['panel_sizes'] = array('fkey' => 'size');
		$data['tables']['panel_types'] = array('fkey' => 'type');
		$data['tables']['piperun_types'] = array('fkey' => 'type');
		$data['tables']['rafter_types'] = array('fkey' => 'type');
		$data['tables']['referral_types'] = array('fkey' => 'type');
		$data['tables']['roof_types'] = array('fkey' => 'type');
		$data['tables']['service_panel_amperages'] = array('fkey' => 'amperage');
		$data['tables']['tank_brands'] = array('fkey' => 'brand');
		$data['tables']['tank_sizes'] = array('fkey' => 'size');
		$data['tables']['fan_brands'] = array('fkey' => 'brand');
		//$data['tables']['wire_run_types'] = array('fkey' => 'type');
		$data['tables']['household_types'] = array('fkey' => 'type');
		//$data['tables']['contractors'] = array('fkey' => 'contractor');
               // $data['tables']['wire_run_distance'] = array('fkey' => 'type');
		$data['tables']['electric_wire_source'] = array('fkey' => 'source');
		$data['tables']['moniter_display'] = array('fkey' => 'type');
		$data['tables']['electric_wire_type'] = array('fkey' => 'type');
		$data['tables']['service_panel_upgrade'] = array('fkey' => 'type');
                //$data['tables']['pipe_run_distance'] = array('fkey' => 'type');
                $data['tables']['panel_numbers'] = array('fkey' => 'type');
		foreach($data['tables'] as $key => $value)
		{
			$this->db->order_by($value['fkey'],'asc');
			$data['tables'][$key]['rows'] = $this->db->get($key)->result_array();
		}
		
		$row = $this->db->get("job_limit")->row_array();
		$data['daily_limit'] = $row['limit'];
		
		for($i=0; $i<20; $i++)
		{
			$data['daily_limits'][$i] = $i;
		}
		
		if($this->input->post("dosubmit"))
		{
			foreach($data['tables'] as $key => $value)
			{
				// explode textbox values into array
				$options = array();
				$options = explode("\n", $this->input->post($key));
				// remove empty options (in case there were additional line breaks)
				foreach($options as $k => $o) 
				{
					if(trim($o) == '')
					{
						unset($options[$k]);
					}
				}
				#die(print_r($options));
				if(count($options) > 0)
				{
					foreach($options as $option)
					{						
						$matched_rows = array();
						$sql = "SELECT * FROM $key WHERE UPPER(".$value['fkey'].") = ".$this->db->escape(strtoupper($option));
						$matched_rows = $this->db->query($sql)->result_array();
						
						// look for new values
						$new = array();
						if(count($matched_rows) == 0)
						{
							$new[$value['fkey']] = $option;
							$this->db->insert($key,$new);
						}
						
						// delete old values
						$existing_rows = array();
						$existing_rows = $this->db->get($key)->result_array();
						foreach($existing_rows as $row)
						{
							if(!in_array($row[$value['fkey']],$options))
							{
								$sql = "DELETE FROM $key WHERE id = ".$this->db->escape($row['id']);
								$this->db->query($sql);
							}
						}
					}
				}
			}
			
			redirect("admin/config");
		}
		  $sql  = "SELECT notification from notification_setting WHERE id=1";
                  $nresult =  $this->db->query($sql)->result_array();
                  if(!$nresult[0]['notification'] ) {
                      $data['notification']=0  ;
                  } else {
                      $data['notification']=1;
                  }
		$this->load->view("common/header");
		$this->load->view("admin/config",$data);
		$this->load->view("common/footer");
	}
	
	function delete_file($file_id='')
	{
		$this->db->where('id',$file_id);
		$file = $this->db->get("files")->row_array();
		
		$this->db->where("id",$file_id);
		$this->db->delete('files');
		
		redirect("admin/job/".$file['job_id']);
	}
        function delete_planfile($file_id='',$file_type="no")
	{
		$this->db->where('id',$file_id);
                if($file_type=="no"){
		 $file = $this->db->get("genral_files")->row_array();
                } else{
                    $file = $this->db->get("meter_files")->row_array();
                }
		$this->db->where("id",$file_id);
		if($file_type=="no"){
                $this->db->delete('genral_files');
                } else {
                 $this->db->delete('meter_files');
                }
		redirect("admin/job/".$file['job_id']);
	}
        function delete_sketchfile($file_id='',$file_type="no")
	{
		$this->db->where('id',$file_id);
                if($file_type=="no"){
		 $file = $this->db->get("sketch_files")->row_array();
                } else{
                    $file = $this->db->get("meter_files")->row_array();
                }
		$this->db->where("id",$file_id);
		if($file_type=="no"){
                $this->db->delete('sketch_files');
                } else {
                 $this->db->delete('meter_files');
                }
		redirect("admin/job/".$file['job_id']);
	}
         function delete_elecphotofile($file_id='')
	{
		$this->db->where('id',$file_id);
                $file = $this->db->get("elecphoto_files")->row_array();
		$this->db->where("id",$file_id);
		$this->db->delete('elecphoto_files');
                redirect("admin/job/".$file['job_id']);
	}
         function delete_presalefile($file_id='',$file_type="no")
	{
		$this->db->where('id',$file_id);
                if($file_type=="no"){
		 $file = $this->db->get("presale_files")->row_array();
                } else{
                    $file = $this->db->get("meter_files")->row_array();
                }
		$this->db->where("id",$file_id);
		if($file_type=="no"){
                $this->db->delete('presale_files');
                } else {
                 $this->db->delete('meter_files');
                }
		redirect("admin/job/".$file['job_id']);
	}
         function delete_permitfile($file_id='',$jobid=1)
	{
		$this->db->where('id',$file_id);
                $this->db->delete('permit_files');
                redirect("admin/permit_job/".$jobid."?msg=file_del");
	}
  function    installer_available($year='', $month='', $uid=0)
	{
                
		$year = (int)$year;
		$month = (int) $month;
                if(!$uid){
                   $uid = $this->session->userdata("user_id");
                }
                $this->load->library("job");
		$this->load->helper("date");
		$data = array();
		$prefs = array (
			'start_day'    => 'sunday',
			'month_type'   => 'long',
			'day_type'     => 'long'
		);

		$jobs = array();
                $day_selected = array();
		if($year=='') {$year = date("Y");}
		if($month=='') {$month = date("m");}
		  //$year = preg_replace("/[^0-9]/","",$year);
		 // $month = preg_replace("/[^0-9]/","",$month);
		$data['year'] = $year;
		$data['month'] = $month;
                $data["uuid"] = $uid;
		// daily job limit
		$daily_limit = $this->db->get("job_limit")->row_array();
		$daily_limit = $daily_limit['limit'];

		// create calendar and year dd values and set which should be preselected
		$data['calendar_months'] = array('01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr', '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Aug', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec');
		$data['calendar_years'] = array();
		for($i=date("Y",strtotime("-2 years")); $i<date("Y",strtotime("+2 years")); $i++)
		{
			$data['calendar_years'][$i] = $i;
		}
		$data['calendar_month'] = $data['month'];
		$data['calendar_year'] = $data['year'];
                $noofday = 1; // split the job
		// get jobs for the current month
		//"SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE DATE_FORMAT(jobs.job_date,'%Y-%c') = '".$year."-".$month."' AND jobs.user_id='".$uid."' ORDER BY jobs.job_date ASC";
                $j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE DATE_FORMAT(jobs.job_date,'%Y-%c') = '".$year."-".$month."'  ORDER BY jobs.job_date ASC")->result_array();

             //print_R($j);
	
    foreach($j as $key => $value)
		{
			$jobs[date("j", strtotime($value['job_date']))][] = $value;
		}
		$days_count = days_in_month($month,$year);

                $session_installer_data = array();
                //print_R($this->session);
                //die;
		if ($this->session->userdata("re_user_id") ) {
                    
                    $session_installer = $this->db->query("SELECT *  FROM  session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")."")->result_array();
                    foreach($session_installer as $key => $value)
                        {
			$session_installer_data[date("j", strtotime($value['date_booked']))][] = $value;
                	}
                }
                
		$adminblock_date = array();
		$inverter_types = $this->db->query("SELECT * FROM admin_block_date WHERE   DATE_FORMAT(block_date,'%Y-%c') = '".$year."-".$month."' ")->result_array();
		foreach($inverter_types as $row => $value){
                     $adminblock_date[date("j",strtotime($value['block_date']))] = $value['message'];
		}
                #die(print(count($service_calls)));
                  $admineditinstaller_date = array();
		$editinstaller = $this->db->query("SELECT * FROM installer_manual WHERE   DATE_FORMAT(day,'%Y-%c') = '".$year."-".$month."' ")->result_array();
		foreach($editinstaller as $row => $value){
                     $admineditinstaller_date[date("j",strtotime($value['day']))] = $value["installer"];
		}
                #die(print(count($service_calls)));
                $number_installer = NUMBEROFINSTALLER;


                
		for($i=0; $i<($days_count+1); $i++)
		{
                    $number_installer = NUMBEROFINSTALLER;
                    if(array_key_exists($i,$admineditinstaller_date)){
                        $number_installer = $admineditinstaller_date[$i];
                     }
                    if(array_key_exists($i,$adminblock_date) ){
                        $data['dates'][$i] = '<div style="background:#333333;" class="booked-day-wrap "><div style="margin-right:110px;">'.$i.'</div><div  style="color:white;"><br/><br/>'.$adminblock_date[$i].'</div></div>';
                        
                        
                    } else  if (array_key_exists($i,$session_installer_data) ){
                       $color = $this->getUserColor($this->session->userdata("re_user_id"));
                       $day_selected[] =  array("bookeddate"=>$session_installer_data[$i][0]['date_booked'], "sessionid" => $session_installer_data[$i][0]['id'] ,"number_of_installer" =>$session_installer_data[$i][0]['number_of_installer']);
                       $noofday = $noofday+1;
                       if(array_key_exists($i,$jobs)){
                           $job_installer = 0;
                           foreach(@$jobs[$i] as $tj)
					{
                                        $job_installer = $job_installer + $tj['no_installer_allocated'] ;
					}
                        $installer_view = $number_installer - $job_installer ;
                        $installer_view = $installer_view-$session_installer_data[$i][0]['number_of_installer'];
                       } else {
                            $installer_view = $number_installer-$session_installer_data[$i][0]['number_of_installer'];
                       }
                       if ($installer_view==0){
                            $color = '#7d7d7d;';
                       }
                       $data['dates'][$i]='<div title="Installer Assigned" class="booked-day-wrap tooltip" style="background: #'.$color.'; cursor: pointer;"><div class="job-count">'.$installer_view.'</div></div><div class="booked-day"><span style="color:#fff;">'.$i.'</span></div>
';

                    }
                     else if(array_key_exists($i,$jobs)){
                         $job_installer = 0;
                           foreach(@$jobs[$i] as $tj)
                            {
                                $job_installer = $job_installer + $tj['no_installer_allocated'] ;
                            }
                        $installer_view = $number_installer - $job_installer ;
                        //$installer_view = $number_installer - $jobs[$i][0]['no_installer_allocated'] ;
                        $color1 = '#59912c;';
                        if ($installer_view==0){
                            $color1 = '#7d7d7d;';
                       }
                        if ($installer_view>=0) {
                                        $data['dates'][$i]='<a class="facebox day-view-url" href="'.base_url().'ajax/day_installerassign/'.$year.'/'.$month.'/'.$i.'/'.$installer_view.'/'.$noofday.'"><div title="Available Installer" class="booked-day-wrap tooltip" style="background: '.$color1.' cursor: pointer;"><div class="job-count">'.$installer_view.'</div></div><div class="booked-day"><span style="color:#fff;">'.$i.'</span></div>
</a>';                      } else {
                          /*      $data['dates'][$i]='<div title="Go To Day View" class="booked-day-wrap tooltip" style="background: none repeat scroll 0% 0% rgb(152, 26, 54); cursor: pointer;"><a class="day-view-url" href="/admin/day/2011/08/2">
</a><div class="job-count"><a class="day-view-url" href="/admin/day/2011/08/2">2</a></div></div><div class="booked-day"><span style="color:#fff;">2</span></div>';
*/

                        }
                    } else{
                            $data['dates'][$i]='<a class="facebox day-view-url" href="'.base_url().'ajax/day_installerassign/'.$year.'/'.$month.'/'.$i.'/'.$number_installer.'/'.$noofday.'"><div title="Available Installer" class="booked-day-wrap tooltip" style="background:#59912c; cursor: pointer;"><div class="job-count">'.$number_installer.'</div></div><div class="booked-day"><span style="color:#fff;">'.$i.'</span></div></a>
';
                    }

		}
		$prefs['template'] = ' {table_open}<table class="calendar" border="0" cellpadding="0" cellspacing="1">{/table_open}

		   {heading_row_start}<tr>{/heading_row_start}

		   {heading_previous_cell}<th><a href="{previous_url}">&lt;&lt;</a></th>{/heading_previous_cell}
		   {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
		   {heading_next_cell}<th><a href="{next_url}">&gt;&gt;</a></th>{/heading_next_cell}

		   {heading_row_end}</tr>{/heading_row_end}

		   {week_row_start}<tr class="week-days">{/week_row_start}
		   {week_day_cell}<td style=background-color:#7d7d7d; border:1px solid #7d7d7d;"><div align="left" style="color:#fff;">{week_day}</div></td>{/week_day_cell}
		   {week_row_end}</tr>{/week_row_end}

		   {cal_row_start}<tr>{/cal_row_start}
		   {cal_cell_start}<td>{/cal_cell_start}
                        {cal_cell_content}
		    <div class="cell-inner-big">
			{content}
			</div>
			{/cal_cell_content}
			{cal_cell_content_today}
			<div class="cell-inner-big">
                        {content}
			</div>
			{/cal_cell_content_today}
			{cal_cell_no_content}
			<div class="cell-inner-big">
			<div class="reserve-job-block">';
       
				$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content}
			{cal_cell_no_content_today}
			<div class="cell-inner-big">
				<div class="reserve-job-block">';
                        
			$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content_today}

		   {cal_cell_blank}&nbsp;{/cal_cell_blank}

		   {cal_cell_end}</td>{/cal_cell_end}
		   {cal_row_end}</tr>{/cal_row_end}

		   {table_close}</table>{/table_close}
		';
                 if($this->session->userdata("in_noi")){
                    $data['availaible_installer']= $this->session->userdata("in_noi");

                 }else if(count($day_selected)==0){
                    $this->session->set_userdata(array("in_noi"=>1));
                    $data['availaible_installer']= 1;

                 } else{
                     $data['availaible_installer']= $this->session->userdata("in_noi");
                 }
                 if($this->session->userdata("in_nod")){
                    $data['no_day'] = $this->session->userdata("in_nod");
                 }else if(count($day_selected)==0) {
                    $this->session->set_userdata(array("no_day"=>1));
                    $data['no_day']=1;
                 }else{
                     $data['no_day'] = $this->session->userdata("in_nod");
                 }
                $data["selected_date"] = $day_selected;
                $data["current_day"] = $noofday ;
                $data["job_id"] = 0;
                $data["job_type"] =null;
                if($this->session->userdata('job_id')){
                  $data["job_id"] = $this->session->userdata('job_id');
                }
                if($this->session->userdata('job_type')){
                  $data["job_type"] = $this->session->userdata('job_type');
                }
		$this->load->library('calendar',$prefs);
		$this->load->view("common/header");
		$this->load->view("admin/installeravailable",$data);
		$this->load->view("common/footer");
  }
  function getCustomerLastname($id){
      if (!$id) return 0;

      $j = $this->db->query("SELECT last_name FROM customers WHERE id=$id")->result_array();
      foreach($j as $key => $value) {
        $lastname = ucfirst($value['last_name']);
      }
      return @$lastname;
  }
  function getCustomerNeighborhood($id){
      if (!$id) return 0;

      $j = $this->db->query("SELECT neighborhood FROM customers WHERE id=$id")->result_array();
      foreach($j as $key => $value) {
        if(isset($value['neighborhood']))
        $neighborhood = ucfirst($value['neighborhood']);
      }
      return @$neighborhood;
  }
 function getUserIntial($id,$fullname=false){
      if (!$id) return 0;
      $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
      foreach($j as $key => $value) {
        $intial = ucfirst($value['first_name'][0]).ucfirst($value['last_name'][0]);
        if($fullname){
         $intial = ucfirst($value['first_name'])." ".ucfirst($value['last_name']);
        }
      }
      return $intial;
 }
 function getUserEmpNo($id,$fullname=false){
      if (!$id) return 0;
      $j = $this->db->query("SELECT emp_num FROM users WHERE id=$id")->result_array();
      if($j[0]['emp_num']>0){
        return $j[0]['emp_num'];
      }

      return $id;
 }
 function getUserColor($id){
      if (!$id) return 0;
      $j = $this->db->query("SELECT custom_hex,color_id FROM users WHERE id=$id")->result_array();
      foreach($j as $key => $value) {
        $color = $value['custom_hex'];
        $color_id = $value['color_id'];
      }
      if (!$color && $color_id){
        $j = $this->db->query("SELECT hex FROM colors WHERE id=$color_id")->result_array();
      foreach($j as $key => $value) {
        $color = $value['hex'];

      }
      }
      if(!$color) {
          $color = "7dbb4b";
      }
      return $color;
 }


   function    installer_edit($year='', $month='', $uid=0)
	{

		if ($this->session->userdata("role") != 'admin'){
                    return "No Access";
                }
                if($year=='') {$year = date("Y");}
		if($month=='') {$month = date("m");}
                $year = (int)$year;
		$month = (int) $month;
                if(!$uid){
                   $uid = $this->session->userdata("user_id");
                }
                $this->load->library("job");
		$this->load->helper("date");
		$data = array();
		$prefs = array (
			'start_day'    => 'sunday',
			'month_type'   => 'long',
			'day_type'     => 'long'
		);

		$jobs = array();
                $day_selected = array();
		
		  //$year = preg_replace("/[^0-9]/","",$year);
		 // $month = preg_replace("/[^0-9]/","",$month);
		$data['year'] = $year;
		$data['month'] = $month;
                $data["uuid"] = $uid;
		// daily job limit
		$daily_limit = $this->db->get("job_limit")->row_array();
		$daily_limit = $daily_limit['limit'];

		// create calendar and year dd values and set which should be preselected
		$data['calendar_months'] = array('01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr', '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Aug', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec');
		$data['calendar_years'] = array();
		for($i=date("Y",strtotime("-2 years")); $i<date("Y",strtotime("+2 years")); $i++)
		{
			$data['calendar_years'][$i] = $i;
		}
		$data['calendar_month'] = $data['month'];
		$data['calendar_year'] = $data['year'];
                $noofday = 1; // split the job
		// get jobs for the current month
		//"SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE DATE_FORMAT(jobs.job_date,'%Y-%c') = '".$year."-".$month."' AND jobs.user_id='".$uid."' ORDER BY jobs.job_date ASC";
                $j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE DATE_FORMAT(jobs.job_date,'%Y-%c') = '".$year."-".$month."'  ORDER BY jobs.job_date ASC")->result_array();

                //print_R($j);

    foreach($j as $key => $value)
		{
			$jobs[date("j", strtotime($value['job_date']))][] = $value;
		}
		$days_count = days_in_month($month,$year);
                $adminblock_date = array();
		$inverter_types = $this->db->query("SELECT * FROM admin_block_date WHERE   DATE_FORMAT(block_date,'%Y-%c') = '".$year."-".$month."' ")->result_array();
		foreach($inverter_types as $row => $value){
                     $adminblock_date[date("j",strtotime($value['block_date']))] = $value['message'];
		}

                $admineditinstaller_date = array();
		$editinstaller = $this->db->query("SELECT * FROM installer_manual WHERE   DATE_FORMAT(day,'%Y-%c') = '".$year."-".$month."' ")->result_array();
		foreach($editinstaller as $row => $value){
                     $admineditinstaller_date[date("j",strtotime($value['day']))] = $value["installer"];
		}
                #die(print(count($service_calls)));
                $number_installer = NUMBEROFINSTALLER;
		for($i=0; $i<($days_count+1); $i++)
		{
                     $number_installer = NUMBEROFINSTALLER;
                    if(array_key_exists($i,$admineditinstaller_date)){
                        $number_installer = $admineditinstaller_date[$i];
                     }

                    if(array_key_exists($i,$adminblock_date) ){
                        $data['dates'][$i] = '<a class="facebox day-view-url" href="'.base_url().'ajax/unblock_day_form/'.$year.'/'.$month.'/'.$i.'" title="Unblock Day" ><div style="background:#333333;" class="booked-day-wrap "><div style="margin-right:110px;">'.$i.'</div><div  style="color:white;"><br/><br/>'.$adminblock_date[$i].'</div></div></a>';


                    } 
                     else if(array_key_exists($i,$jobs)){
                         $job_installer = 0;
                           foreach(@$jobs[$i] as $tj)
                            {
                                $job_installer = $job_installer + $tj['no_installer_allocated'] ;
                            }
                           $installer_view = $number_installer - $job_installer ;
                        //$installer_view = $number_installer - $jobs[$i][0]['no_installer_allocated'] ;

                        if ($installer_view>0) {
                                        $data['dates'][$i]='<a class="facebox day-view-url" href="'.base_url().'ajax/day_installeredit/'.$year.'/'.$month.'/'.$i.'/'.$installer_view.'/'.$job_installer.'"><div title="Available Installer" class="booked-day-wrap tooltip" style="background: #59912c; cursor: pointer;"><div class="job-count">'.$installer_view.'</div></div><div class="booked-day"><span style="color:#fff;">'.$i.'</span></div>
</a>';                      } else if ($installer_view==0) {
                                $data['dates'][$i]='<a class="facebox day-view-url" href="'.base_url().'ajax/day_installeredit/'.$year.'/'.$month.'/'.$i.'/'.$installer_view.'/'.$job_installer.'"><div title="Available Installer" class="booked-day-wrap tooltip" style="background: #7d7d7d; cursor: pointer;"><div class="job-count">'.$installer_view.'</div></div><div class="booked-day"><span style="color:#fff;">'.$i.'</span></div></a>';
    /*      $data['dates'][$i]='<div title="Go To Day View" class="booked-day-wrap tooltip" style="background: none repeat scroll 0% 0% rgb(152, 26, 54); cursor: pointer;"><a class="day-view-url" href="/admin/day/2011/08/2">
</a><div class="job-count"><a class="day-view-url" href="/admin/day/2011/08/2">2</a></div></div><div class="booked-day"><span style="color:#fff;">2</span></div>';
*/

                        }
                    } else{
                            $data['dates'][$i]='<a class="facebox day-view-url" href="'.base_url().'ajax/day_installeredit/'.$year.'/'.$month.'/'.$i.'/'.$number_installer.'/0"><div title="Available Installer" class="booked-day-wrap tooltip" style="background:#59912c; cursor: pointer;"><div class="job-count">'.$number_installer.'</div></div><div class="booked-day"><span style="color:#fff;">'.$i.'</span></div></a>
';
                    }

		}
		$prefs['template'] = ' {table_open}<table class="calendar" border="0" cellpadding="0" cellspacing="1">{/table_open}

		   {heading_row_start}<tr>{/heading_row_start}

		   {heading_previous_cell}<th><a href="{previous_url}">&lt;&lt;</a></th>{/heading_previous_cell}
		   {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
		   {heading_next_cell}<th><a href="{next_url}">&gt;&gt;</a></th>{/heading_next_cell}

		   {heading_row_end}</tr>{/heading_row_end}

		   {week_row_start}<tr class="week-days">{/week_row_start}
		   {week_day_cell}<td style=background-color:#7d7d7d; border:1px solid #7d7d7d;"><div align="left" style="color:#fff;">{week_day}</div></td>{/week_day_cell}
		   {week_row_end}</tr>{/week_row_end}

		   {cal_row_start}<tr>{/cal_row_start}
		   {cal_cell_start}<td>{/cal_cell_start}
                        {cal_cell_content}
		    <div class="cell-inner-big">
			{content}
			</div>
			{/cal_cell_content}
			{cal_cell_content_today}
			<div class="cell-inner-big">
                        {content}
			</div>
			{/cal_cell_content_today}
			{cal_cell_no_content}
			<div class="cell-inner-big">
			<div class="reserve-job-block">';

				$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content}
			{cal_cell_no_content_today}
			<div class="cell-inner-big">
				<div class="reserve-job-block">';

			$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content_today}

		   {cal_cell_blank}&nbsp;{/cal_cell_blank}

		   {cal_cell_end}</td>{/cal_cell_end}
		   {cal_row_end}</tr>{/cal_row_end}

		   {table_close}</table>{/table_close}
		';

                 global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
		$this->load->library('calendar',$prefs);
		$this->load->view("common/header");
		$this->load->view("admin/installeravailableedit",$data);
		$this->load->view("common/footer");
  }
  function createpdf($jobid){
   
   $sql_jobtype = "SELECT job_type_id FROM jobs where id=$jobid";
   $res = mysql_fetch_object(mysql_query($sql_jobtype));
   if ($res->job_type_id == 1) {
       $this->createswhpdf($jobid);
       return;
   }
   if($res->job_type_id == 5 ) {
      $this->createservicepdf($jobid);
      return;
     }
   $html = $this->load->view("admin/createpdfhtml",'',true);
   $j = array();
   $roof_flashing[0] = 'AEI(Eco Fastener)';
   $roof_flashing[1] = 'AEI(Eco Fastener)';
   $roof_flashing[2] = 'Quickmount';
   $roof_flashing[3] = 'Wakaflex';
   $roof_flashing[4] = 'GEOCEL';
   $roof_flashing[5] = 'Lead';
 // include("C:\wamp\www\sites\\trunk\scheduler\MPDF53\mpdf.php");
   //include("C:\wamp\www\sites\\trunk\scheduler\mergepdf\mergepdf.php");
   include("/var/www/vhosts/aeihawaii.com/httpdocs/MPDF531/mpdf.php");
   include("/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/mergepdf/mergepdf.php");
   $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
                        customers.email,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			customers.home_phone,
                        customers.secondary_phone,
                        customers.association,
                        customers.heco_account_number,
                        customers.heco_meter_number,
                        customers.neighborhood,
                        customers.other_neighborhood,
                        job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($jobid)."
		";
     $data = $this->db->query($sql)->row_array();
     
     $userload = $this->getuser($data['user_id']);
     $customername = $data['first_name']." ".$data['last_name'];
    $username = $userload[0]->first_name." ".$userload[0]->last_name;
    $html = str_replace("{salesman_name}" ,$username ,$html);
    $customername_pdf = $data['first_name']."-".$data['last_name'].".pdf";
   /* Customer Information*/
   
   $html = str_replace("{customer_name}" ,$customername ,$html);
   $html = str_replace("{address_customer}" ,$data['address'] ,$html);
   $html = str_replace("{city_customer}" ,$data['city'] ,$html);
   $html = str_replace("{zipcode_customer}" ,$data['zip_code'] ,$html);
   $html = str_replace("{email_customer}" ,$data['email'] ,$html);
   $html = str_replace("{telephone_customer}" ,"'".$data['home_phone']." ".$data['secondary_phone']."'" ,$html);
   $html = str_replace("{assoc_customer}" ,$data['association'], $html);
   if($data['job_date']) {
    $html = str_replace("{installdate_customer}" ,date("F jS, Y ",strtotime($data['job_date'])) ,$html);
   }else {
    $html = str_replace("{installdate_customer}" ,"Unscheduled Job" ,$html);
   }
   $html = str_replace("{dow_customer}" ,date("l",strtotime($data['job_date'])) ,$html);

   /* System Information*/

   $html = str_replace("{nos_system}" ,$data['job_nos'] ,$html);
   $html = str_replace("{ss_system}" ,$data['system_size'] ,$html);
   $html = str_replace("{nom_system}" ,$data['job_nom'] ,$html);
   $html = str_replace("{mt_system}" ,$this->getidothervalue($data['module_brand_id'] ,$data['other_module_brand'] ,'module_brands' ,'brand') ,$html);
   $html = str_replace("{ib_system}" ,$data['inverter_count'] ,$html);
   $html = str_replace("{roofflashing_job}" ,$roof_flashing[$data['roof_flashing']] ,$html);
   $html = str_replace("{neighborhood}" ,$this->getidothervalue($data['neighborhood'] ,$data['other_neighborhood'] ,'neigbhour' ,'neighbour') ,$html);
   $html = str_replace("{it_system}" ,$this->getidothervalue($data['inverter_type_id'] ,$data['other_inverter_type'] ,'inverter_types' ,'type') ,$html);
    if($data['inverter_accessible']=="y")
       $data['inverter_accessible'] = "Yes";
   else
    $data['inverter_accessible'] = "No";
   $html = str_replace("{ia_system}" ,ucfirst($data['inverter_accessible']) ,$html);
   $html = str_replace("{wrd_system}" ,$this->getidothervalue($data['wire_run_distance'] ,$data['other_wire_run_distance'] ,'wire_run_distance' ,'type')." ft" ,$html);
   $html = str_replace("{nosa_system}" ,$data['job_nosa'] ,$html);
   if($data['tilt_kit_needed']=="y")
       $data['tilt_kit_needed'] = "Yes";
   else
       $data['tilt_kit_needed'] = "No";
   $html = str_replace("{tkn_system}" ,$data['tilt_kit_needed'] ,$html);
   $html = str_replace("{ort_system}" ,$data['roof_orientation'] ,$html);
   $html = str_replace("{rp_system}" ,$data['roof_pitch'] ,$html);
   $html = str_replace("{pom_system}" ,$this->getidothervalue($data['installation_type_id'] ,$data['other_installation_type'] ,'installation_types' ,'type') ,$html);
   $html = str_replace("{ms_system}" ,$this->getidothervalue($data['mointer_system'] ,$data['other_mointer_system'] ,'moniter_display' ,'type') ,$html);

   /* job specification */
   $html = str_replace("{rt_job}" ,$this->getidothervalue($data['roof_type_id'] ,$data['other_roof_type'] ,'roof_types' ,'type') ,$html);
   $html = str_replace("{rmt_job}" ,$this->getidothervalue($data['rafter_type_id'] ,$data['other_rafter_type'] ,'rafter_types' ,'type') ,$html);
   $html = str_replace("{dbr_job}" ,$data['rafter_distance'] ,$html);
   $html = str_replace("{rut_job}" ,$this->getidothervalue($data['wire_run_type_id'] ,$data['other_wire_run_type'] ,'wire_run_types' ,'type') ,$html);
   $html = str_replace("{nof_job}" ,$data['stories'] ,$html);
   if($data['is_ladder']=="y")
       $data['is_ladder'] = "Yes";
   else
       $data['is_ladder'] = "No";
   $html = str_replace("{lle_job}" , $data['is_ladder'] ,$html);


   $contractor = $data['contractor_id'];
   $temp =explode(",",$contractor);
   $cnamei = array();
   foreach($temp as $c=>$v) {
    $cnamei[] = $this->getUserIntial($v,true);
   }
   
   $installer_id = $data['installer_id'];
   $temp =explode(",",$installer_id);
   $installname = array();
   foreach($temp as $c=>$v) {
       if($v){
           $installname[] = $this->getUserIntial($v,true)."(".$this->getUserEmpNo($v).")";
       }
   }
  
   $html = str_replace("{technician}",implode(",",$installname),$html);
   /* Electric  specification */
   
   $html = str_replace("{er_elec}" ,implode(",",$cnamei) ,$html);
   $html = str_replace("{hm_elec}" ,$data['heco_meter_number'] ,$html);
   $html = str_replace("{ha_elec}" ,$data['heco_account_number'] ,$html);
   $html = str_replace("{tm_elec}" ,$this->getidothervalue($data['jobs_emt'] ,$data['other_jobs_emt'] ,'electric_wire_type' ,'type') ,$html);
    if($data['job_wssn']=="y")
       $data['job_wssn'] = "Yes";
   else
       $data['job_wssn'] = "No";
   $html = str_replace("{nsn_elec}" ,$data['job_wssn'] ,$html);
   $html = str_replace("{iyws_elec}" ,$data['job_isnws'] ,$html);
   $html = str_replace("{sm_elec}" ,"" ,$html);
   
   $html = str_replace("{spa_elec}" ,$this->getidothervalue($data['service_panel_amperage_id'] ,$data['other_amperage'] ,'service_panel_amperages' ,'amperage') ,$html);
   $html = str_replace("{ews_elec}" ,$this->getidothervalue($data['electric_wire_source'] ,$data['electric_wire_source_other'] ,'electric_wire_source' ,'source') ,$html);
   $un_elec = "";
   if ($data['servicepanelupgrade']==1){
       $un_elec = 'Yes( Size:- '.$data['job_spu'].')';
   } else if($data['servicepanelupgrade']==2){
       $un_elec = 'No';

   } else if($data['servicepanelupgrade']==3){
       $un_elec = 'Upgrade Needed?';
   }
   $html = str_replace("{un_elec}" ,$un_elec,$html);

     if($data['spmsip_job']=="yes")
       $data['spmsip_job'] = "Yes";
   else
       $data['spmsip_job'] = "No";
   $html = str_replace("{spmsip_job}" ,$data['spmsip_job'],$html);
  
   $html = str_replace("{comment_elec}" ,$data['comments'] ,$html);
   
   $pid_job = $this->getparentjobid($jobid);
 $sql_plot = "SELECT * FROM genral_files WHERE job_id=$pid_job AND mime in ('application/pdf','\"application/pdf\"' ) ";
  $plot_files = array();
  $plot_files = $this->db->query($sql_plot)->result_array();
  $htmlappend1 ="";
  $pdfpath = "/var/www/vhosts/aeihawaii.com/httpdocs/uploads/";
  if (count($plot_files)>0 && file_exists($pdfpath.$sketch_files[0]['unique_filename'])){
    $merge_pdfall[1] = $pdfpath.$plot_files[0]['unique_filename'];
    $newpath=$pdfpath.'temp.jpg';
 @unlink($newpath);
 $existpath= $pdfpath.$plot_files[0]['unique_filename'];
//echo $pdfpath.$plot_files[0]['unique_filename'];
   exec ("convert $existpath -append  $newpath  ");
//die;
  $htmlappend1 .='<pagebreak />';
  $htmlappend1 .='<table cellpadding="0" cellspacing="0" align="center" width="100%">';
  $htmlappend1 .='<tr><td></td>
                    <td align="left" width="40%">{planimagesadd}  </td>
                    </tr>
                ';
  $htmlappend1 .='</table>';
  $html = str_replace("{planaddimage}" , $htmlappend1 ,$html);
  $naddimg = "<img src='".$newpath."' /><br/><br/>"; // Read the file's contents
  $html = str_replace("{planimagesadd}" , $naddimg ,$html);
  } else {
   $html = str_replace("{planaddimage}" , "" ,$html);
  }


   $img = "";
   $sql = "SELECT * FROM meter_files WHERE job_id=$jobid AND mime in ('image/jpg' ,'image/jpeg' ,'image/png', 'image/gif' )";
   $plan_files = array();
   $plan_files = $this->db->query($sql)->result_array();
   
   $htmlappend ="";
   $count = 1;
   if(count($plan_files)){
       foreach ($plan_files as $key => $value){
           if ($count == 1 || $count%2 == 1){
            $htmlappend .='<pagebreak />';
            $htmlappend .='<table cellpadding="0" cellspacing="0" align="center" width="100%">';
           }
             $htmlappend .='<tr>
                    <td></td>
                    <td align="left" width="40%">{planimages_'.$count.'}  </td>
                    </tr>
                ';
             if ($count == 1 || $count%2 == 1){
                $htmlappend .='</table>';
             }
        $count = $count + 1;
       }
       $html = str_replace("{strimage}" , $htmlappend ,$html);
       $count = 1;
       foreach ($plan_files as $key => $value){
        $img = "<img src='".base_url()."uploads/".$value['unique_filename']."' /><br/><br/>"; // Read the file's contents
        $html = str_replace("{planimages_".$count."}" , $img ,$html);
        $count = $count + 1;
        }
        
   }else{
       $html = str_replace("{strimage}" , "" ,$html);
   }


  $mpdf=new mPDF('s');
  $mpdf->SetDisplayMode('fullpage');
  
 
   $merge_pdfall =array();
   $mpdf->WriteHTML($html);
   // linux path
   //$pdfpath = "C:/wamp/www/sites/trunk/scheduler/uploads/"; // linux path
   $data =$mpdf->Output($customername_pdf,"D");
  /* $merge_pdfall[0] =$pdfpath.$customername_pdf;
   $pid_job = $this->getparentjobid($jobid);
   /**$sql_sketchfile = "SELECT * FROM sketch_files WHERE job_id=$pid_job AND mime in ('application/pdf' ) ";
   $sketch_files = array();
   $sketch_files = $this->db->query($sql_sketchfile)->result_array();
   if (count($sketch_files)>0 && file_exists($pdfpath.$sketch_files[0]['unique_filename'])  )
    $merge_pdfall[1] = $pdfpath.$sketch_files[0]['unique_filename'];
  
  $sql_presale = "SELECT * FROM presale_files WHERE job_id=$pid_job AND mime in ('application/pdf' ) ";
  $presale_files = array();
  $presale_files = $this->db->query($sql_presale)->result_array();
  if (count($presale_files)>0 && file_exists($pdfpath.$sketch_files[0]['unique_filename']))
    $merge_pdfall[2] = $pdfpath.$presale_files[0]['unique_filename'];
   */
  
  
   $pdf = new concat_pdf(); 
   $pdf->setFiles($merge_pdfall); 
   $pdf->concat(); 
   $pdf->Output($customername_pdf, 'D');
   }
  function getcustomer($id){
       $j = $this->db->query("SELECT customers.* FROM customers  WHERE  id =$id ")->result();
      
       return $j;
  }
  function getuser($id){
       $j = $this->db->query("SELECT users.* FROM users WHERE  id =$id ")->result();
      return $j;
  }
  function getidothervalue($other ,$id ,$tablename , $column ="*"){
   if($other=="other" || $other=="" || !$other){

       return $id;
   }
   
   $j = $this->db->query("SELECT $column  FROM $tablename  WHERE  id =$other")->result();
    
    if(isset($j[0]->$column))
     return $j[0]->$column;
     else
      return "" ;
  }
  function installers($job_id){
    $data = array();

		$data['job_id'] = $job_id;

		$this->load->library("job");
		$this->load->helper("text");

		if($job_id=='') { redirect('admin/error?e=job_id'); }

		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();

		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['job'] = $this->db->query($sql)->row_array();
                $data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
                 if($data['job']['job_type_id'] == 6 ) { $data['titleshow'] = 'PreLag'; }
                 if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Prelag'; }
                $data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);

                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
                // daily job limit
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);

                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();

		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                $install_assign = $data['job']['installer_id'];
                $installer_assign_array = explode("," ,$install_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $data['installer_assign']=array();
                $data['installer_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$installer_assign_array )){
                          $data['installer_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $data['installer_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                    }
                $conduit_assign = $data['job']['conduit_id'];
                $conduit_array = explode("," ,$conduit_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $data['conduit_assign']=array();
                $data['conduit_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$conduit_array )){
                          $data['conduit_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $data['conduit_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                }    
                $data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']!=5){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                $data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
                //$totalinstaller = $this->db->query("SELECT GROUP_CONCAT(installer_id) as totalinstaller FROM jobs   WHERE jobs.job_date = '".$data['job']['job_date']."' GROUP BY jobs.job_date ")->result_array();
		//$data['totalinstallercnt'] = $totalinstaller[0]['totalinstaller'];
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
               
		$this->db->where('type','contractor');
		$contractors = $this->db->get("users")->result_array();
		foreach($contractors as $row) { $data['contractors'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row['last_name']); }
                $this->load->view("common/header");
                $this->load->view("admin/job_installer",$data);
                $this->load->view("common/footer");
  }
  function customer_job($job_id){
        $data = array();
        $data['job_id'] = $job_id;
        $this->load->library("job");
        $data['percent_completed'] = $this->job->percent_completed($job_id);
	$this->load->helper("text");
          if($job_id=='') { redirect('admin/error?e=job_id'); }
            $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
                        customers.first_name1,
			customers.last_name1,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		//$data['percent_completed'] = $this->job->percent_completed($job_id);
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
		// daily job limit
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
                 $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id,'active');
                $data['jobclass'] = $this->job->getjobtabclass($job_id);
                
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                 $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();
                $this->db->order_by("id","asc");
                $data['neighbour']['']="Select neighbour ";
                $data['neighbour']['other']="Other";
		$neighbour_display = $this->db->get("neigbhour")->result_array();
                foreach($neighbour_display as $row) { $data['neighbour'][$row['id']] = $row['neighbour']; }
		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();

               $data['job_statuses'][''] = "- Select a job status -";
               $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']!=5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                 $data['job_statuses']['to be completed'] = "To Be Completed";
                 $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";

                $data['phone'][''] = "- Select a phone -";
                $data['phone']['home'] = "Home";
		$data['phone']['work'] = "work";
		$data['phone']['cell'] = "cell";

                
                $customer_id = $data['job']['customer_id'];
                $data['customer_id'] = $customer_id;
		if($customer_id=='') { redirect('admin/error?e=customer_id'); }

		$data['states'] =  array('' => "- Choose a state -");
		$data['states'] += array('AK'=>"Alaska",'AL'=>"Alabama",'AR'=>"Arkansas",'AZ'=>"Arizona",'CA'=>"California",'CO'=>"Colorado",'CT'=>"Connecticut",'DC'=>"District Of Columbia",'DE'=>"Delaware",'FL'=>"Florida",'GA'=>"Georgia",'HI'=>"Hawaii",'IA'=>"Iowa",'ID'=>"Idaho",'IL'=>"Illinois", 'IN'=>"Indiana",'KS'=>"Kansas",'KY'=>"Kentucky",'LA'=>"Louisiana",'MA'=>"Massachusetts",'MD'=>"Maryland",'ME'=>"Maine",'MI'=>"Michigan",'MN'=>"Minnesota",'MO'=>"Missouri",'MS'=>"Mississippi",'MT'=>"Montana",'NC'=>"North Carolina",'ND'=>"North Dakota",'NE'=>"Nebraska",'NH'=>"New Hampshire",'NJ'=>"New Jersey",'NM'=>"New Mexico",'NV'=>"Nevada",'NY'=>"New York",'OH'=>"Ohio",'OK'=>"Oklahoma", 'OR'=>"Oregon",'PA'=>"Pennsylvania",'RI'=>"Rhode Island",'SC'=>"South Carolina",'SD'=>"South Dakota",'TN'=>"Tennessee",'TX'=>"Texas",'UT'=>"Utah",'VA'=>"Virginia",'VT'=>"Vermont",'WA'=>"Washington",'WI'=>"Wisconsin",'WV'=>"West Virginia",'WY'=>"Wyoming");

		// grab customer info
		$this->db->where("id",$customer_id);
		$data['customer'] = $this->db->get("customers")->row_array();

		// find existing, other customers with this address...
		$this->db->where("address !=",'');
		$this->db->where("city !=",'');
		$this->db->where("state !=",'');
		$this->db->where("address",$data['customer']['address']);
		$this->db->where("city",$data['customer']['city']);
		$this->db->where("state",$data['customer']['state']);
		$this->db->where("id !=", $data['customer']['id']);
		$data['duplicate_customers'] = $this->db->get("customers")->result_array();
		if(count($data['duplicate_customers'])> 0)
		{
			$data['duplicate_addresses'] = true;
		}

		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['customer_type_id'] = $this->input->post("customer_type_id");
			$row['household_type_id'] = $this->input->post("household_type_id");
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
                        $row['first_name1'] = $this->input->post("spouse_firstname");
			$row['last_name1'] = $this->input->post("spouse_lastname");
			$row['home_phone'] = $this->input->post("home_phone");
                        if ($row['home_phone']){
			  $row['secondary_phone'] = $this->input->post("secondary_phone");
                        } else {
                            $row['secondary_phone'] = "";
                        }
                        $row['home_phone1'] = $this->input->post("home_phone1");
			if ($row['home_phone1']){
                            $row['secondary_phone1'] = $this->input->post("secondary_phone1");
                        } else {
                            $row['secondary_phone1'] ="";
                        }

                        $row['home_phone2'] = $this->input->post("home_phone2");
			if($row['home_phone2']){
                            $row['secondary_phone2'] = $this->input->post("secondary_phone2");
                        } else{
                            $row['secondary_phone2'] = "";
                        }

                        if ($this->input->post('neighborhood') == 'other') {
                            $row['neighborhood'] = '';
                            $row['other_neighborhood'] = $this->input->post("other_neighborhood");
			} else {
                            $row['neighborhood'] = $this->input->post("neighborhood");
                            $row['other_neighborhood'] = '';
			}
			$row['email'] = $this->input->post("email");
			$row['address'] = $this->input->post("address");
			$row['city'] = $this->input->post("city");
			$row['state'] = $this->input->post("state");
			$row['zip_code'] = $this->input->post("zip_code");
                        $row['billing_address'] = $this->input->post("billing_address");
			$row['billing_city'] = $this->input->post("billing_city");
			$row['billing_state'] = $this->input->post("billing_state");
			$row['billing_zip_code'] = $this->input->post("billing_zip_code");

			$row['different_billing_address'] = $this->input->post("is_billing_address");
                        $row['neighborhood'] = $this->input->post("neighborhood");
			$row['association'] = $this->input->post("association");
			$row['household_members'] = $this->input->post("household_members");
			$row['avg_electric_bill'] = $this->input->post("avg_electric_bill");
			$row['sun_zone'] = $this->input->post("sun_zone");
			$row['cust_tmk'] = $this->input->post("cust_tmk");
                        $row['cust_bpan'] = $this->input->post("cust_bpan");
                        $row['heco_account_number'] = $this->input->post("heco_account_number");
			$row['heco_meter_number'] = $this->input->post("heco_meter_number");
			$row['comments'] = $this->input->post("comments");
                        $this->db->where("address !=",'');
		        $this->db->where("city !=",'');
		        $this->db->where("state !=",'');
		        $this->db->where("address",$row['address']);
		        $this->db->where("city",$row['city']);
		        $this->db->where("state",$row['state']);
		        $this->db->where("id !=", $customer_id);
		        $data['duplicate_customers'] = $this->db->get("customers")->result_array();
		        if(count($data['duplicate_customers'])> 0)
		        {
                            redirect("admin/customer_job/".$job_id."?errordata=1");
	        	}
			$this->db->where("id",$customer_id);
			$this->db->update("customers",$row);

			redirect("admin/customer_job/".$job_id."?savedata=1");
		}

                /*
		// grab customer's jobs
		$sql = "SELECT jobs.*,job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($customer_id)." LIMIT 3";
		$data['jobs'] = $this->db->query($sql)->result_array();

		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes INNER JOIN jobs ON notes.job_id=jobs.id LEFT JOIN users ON notes.user_id=users.id WHERE jobs.customer_id=".$this->db->escape($customer_id)." LIMIT 3";
		$data['notes'] = $this->db->query($sql)->result_array();

		// grab customer files
		$sql = "SELECT files.* FROM files INNER JOIN jobs ON files.job_id=jobs.id INNER JOIN customers ON jobs.customer_id=customers.id WHERE jobs.customer_id=".$this->db->escape($customer_id)." ORDER BY files.created DESC LIMIT 3";
		$data['customer_files'] = $this->db->query($sql)->result_array();

		// grab household types */
		$sql = "SELECT * FROM household_types ORDER BY `type` ASC";
		$htypes = $this->db->query($sql)->result_array();
		$data['household_types'][] = '- Choose a household type';
		foreach($htypes as $h)
		{
			$data['household_types'][$h['id']] = $h['type'];
		}

		#die(print_r($data['customer_files']));
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $data['savedata'] =  $this->input->get("savedata");
                $data['errordata'] =  $this->input->get("errordata");
                $data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
                if($data['job']['job_type_id'] == 6 ) { $data['titleshow'] = 'PreLag'; }
                $this->load->view("common/header");
                 if($data['job']['job_type_id'] == 5 ){
                    $this->load->view("admin/service_customer",$data);
                }else if ($data['job']['job_type_id'] == 1){
                   $this->load->view("admin/job_swhcustomer",$data);
                } else {
                   $this->load->view("admin/job_customer",$data);
                }


                $this->load->view("common/footer");
  }

  function delete_referral($id){
      $data['id'] = $id;
     $this->load->view("admin/deletereferal",$data);
  }
  function getInstallerDay($year,$month,$day){
    $year = (int)$year;
    $month = (int) $month;
    $day = (int)$day;
    $editinstaller = array();
    $j =array();
     $j = $this->db->query("SELECT sum(no_installer_allocated)as inst FROM  jobs   WHERE DATE_FORMAT(job_date,'%Y-%c-%e') = '".$year."-".$month."-".$day."'  Group By job_date")->result();
     $editinstaller = $this->db->query("SELECT * FROM installer_manual WHERE   DATE_FORMAT(day,'%Y-%c-%e') = '".$year."-".$month."-".$day."'")->result();
    
    $number_installer = NUMBEROFINSTALLER;
    if($editinstaller && $editinstaller[0]->installer){
         $number_installer = $editinstaller[0]->installer;
    }
    if( $j &&  $j[0]->inst){
      $installavail = $number_installer-$j[0]->inst;
    }else{
       $installavail = $number_installer;
     }
     if($installavail<=0) return 0;
       return $installavail;
  }
  function gettimeLimit($jobid){
      $timelimit = 24;
      $resultcnt =  $this->db->query("SELECT * FROM globalconfig  where id = 1")->result_array();
      $timelimit = $resultcnt[0]['globaltimelimit'];
      return $timelimit;
  }
  function getexttimeLimit($jobid){
     $pid = $this->getparentjobid($jobid);
     $resultcnt =  $this->db->query("SELECT timeext as smtimeext,created_on FROM timelimit_manual_extend where jid = '".$pid."' ")->result_array();
     $timelimit = 0;
     if(count($resultcnt)>=1) {
       $timelimit_cal =  (int)(time()-strtotime($resultcnt[0]['created_on']));
       $timelimit = $resultcnt[0]['smtimeext']-round($timelimit_cal/3600);
     }
     return $timelimit;
  }
  function delete_jobcron($jobid){
      $this->db->query("DELETE FROM jobs where  id= '".$jobid."'");
      return;
  }
  function cronjob(){
      $result =  $this->db->query("SELECT * FROM jobs ")->result_array();
            foreach($result as $key => $value){
          $jobtimelimit = $this->gettimeLimit($value['id']);
           $timediff =  (int) ($jobtimelimit-(int)(time()-strtotime($value['created']))/3600);
          
		// daily job limit
                if($timediff<=0){
                    $this->delete_jobcron($value['id']);
                     $j = $this->db->query("SELECT * FROM users WHERE id=".$value['user_id']."")->result();
                    $sname = $j[0]->first_name." ".$j[0]->last_name;
                    $this->deletemail($value['id'],$timediff,$sname,$j[0]->email);

                } else if($timediff>1 && $timediff<3) {
                     $j = $this->db->query("SELECT * FROM users WHERE id=".$value['user_id']."")->result();
                    $sname = $j[0]->first_name." ".$j[0]->last_name;
                    $this->deletebeforemail($value['id'],$timediff,$sname,$j[0]->email);
                }
      }

      return;
  }

  function deletebeforemail($jobid,$timediff,$sname,$mail){
       $ismailsent = $this->globalnotifcation();
       if(!$ismailsent){
        return;
       }
          $this->load->library('email');
          $config['mailtype'] = 'html';
          $this->email->initialize($config);
          $this->email->from('sales@aeihawaii.com', 'Schedular');
          $this->email->to($mail);
          $this->email->subject('AEI Administration:Job Notification');
                   $message = "Dear [$sname],
This is an alert to let you know you have the following jobs awaiting your attention:
 <a href='".base_url()."job/$jobid'>Edit Technical Specification</a>
IMPORTANT NOTICE: YOU HAVE [$timediff HOURS] LEFT TO COMPLETE THE FOLLOWING:
   1.) JOB SPECIFICATIONS
   2.) CUSTOMER INFORMATION
   3.) PRICE INFORMATION
Thank you,
The AEI Administration Team";
  $this->email->message($message);
  $this->email->send();
  }
  function deletemail($jobid,$timediff,$sname,$mail){
          $ismailsent = $this->globalnotifcation();
          if(!$ismailsent){
            return;
          }
          $this->load->library('email');
          $config['mailtype'] = 'html';
          $this->email->initialize($config);
          $this->email->from('sales@aeihawaii.com', 'Schedular');
          $this->email->to($mail);
          $this->email->subject('AEI Administration:Job Created');
                   $message = "Dear [$sname],
This is an alert to let you know you have the following jobs have been removed from the schedule:
[<a href='".base_url()."job/$jobid'>] Job is deleted </a>
If you would like to reschedule your job, please do so here (<a href='".base_url()."admin/jobschedule'>] Schedule Job </a>).
Thank you,
The AEI Administration Teamm";
  $this->email->message($message);
  $this->email->send();
  }

  function job_comment($job_id){
              $data = array();

		$data['job_id'] = $job_id;

		$this->load->library("job");
		$this->load->helper("text");

		if($job_id=='') { redirect('admin/error?e=job_id'); }

		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();
                
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
                if($data['job']['job_type_id'] == 6 ) { $data['titleshow'] = 'PreLag'; }
                $data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
		// daily job limit
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] = $jobtimelimit1;
                   }

                }
                 $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);

                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." ORDER by created desc ";
		$data['job_notes'] = $this->db->query($sql)->result_array();

		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                $install_assign = $data['job']['installer_id'];
                $installer_assign_array = explode("," ,$install_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $data['installer_assign']=array();
                $data['installer_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$installer_assign_array )){
                          $data['installer_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $data['installer_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                    }
                $data['job_statuses'][''] = "- Select a job status -";
               $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']!=5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                $data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $data['editcomment'] = false;
                if ($this->session->userdata("role")=='admin'|| $this->session->userdata("user_id")==$data['job']['user_id']){
                     $data['editcomment'] = true;
                }
                $this->load->view("common/header");
                $this->load->view("admin/job_comment",$data);
                $this->load->view("common/footer");
	
        
  }
  function createswhpdf($jobid){
   $html = $this->load->view("admin/SWHpdf.php",'',true);

   $j = array();
   include("/var/www/vhosts/aeihawaii.com/httpdocs/MPDF531/mpdf.php");
   $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
                        customers.email,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			customers.home_phone,
                        customers.secondary_phone,
                        customers.association,
                        customers.sun_zone,
                        customers.heco_account_number,
                        customers.heco_meter_number,
                        customers.neighborhood,
                        customers.household_members,
                        job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($jobid)."
		";


	 $data = $this->db->query($sql)->row_array();

   $userload = $this->getuser($data['user_id']);
   $customername = $data['first_name']." ".$data['last_name'];
   $username = $userload[0]->first_name." ".$userload[0]->last_name;
   $html = str_replace("{salesman_name}" ,$username ,$html);
   $customername_pdf = $data['first_name']."-".$data['last_name'].".pdf";
   /* Customer Information*/

   $html = str_replace("{customer_name}" ,$customername ,$html);
   $html = str_replace("{address_customer}" ,$data['address'] ,$html);
   $html = str_replace("{city_customer}" ,$data['city'] ,$html);
   $html = str_replace("{zipcode_customer}" ,$data['zip_code'] ,$html);
   $html = str_replace("{email_customer}" ,$data['email'] ,$html);
   $html = str_replace("{telephone_customer}" ," ' ".$data['home_phone']." '".$data['secondary_phone'] ,$html);
   $html = str_replace("{assoc_customer}" ,$data['association'], $html);
   $html = str_replace("{cust_neigh}" ,$data['neighborhood'], $html);
   $html = str_replace("{job_residents}" ,$data['household_members'], $html);

   $html = str_replace("{job_needelec}" ,$this->changevalue($data['elec_insp_quote']), $html);
   $html = str_replace("{job_reason}" ,$data['elec_comments'], $html);
   $html = str_replace("{job_gfi}" ,$this->changevalue($data['gutter_installation']), $html);
   $html = str_replace("{job_retank}" ,$this->changevalue($data['relocate_old_tank']), $html);
   $html = str_replace("{job_drin}" ,$data['tank_distance']." ft" , $html);
   $html = str_replace("{job_pcn}" ,$this->changevalue($data['tilt_kit_needed']), $html);

   $html = str_replace("{cust_zone}" ,$data['sun_zone'], $html);
   if($data['job_date']){
    $html = str_replace("{installdate_customer}" ,date("F jS, Y ",strtotime($data['job_date'])) ,$html);
   }else{
    $html = str_replace("{installdate_customer}" ,"Unscheduled Job" ,$html);
   }
   $html = str_replace("{dow_customer}" ,date("l",strtotime($data['job_date'])) ,$html);


   /* job specification */
   $html = str_replace("{job_tanksize}" ,$this->getidothervalue($data['tank_size_id'] ,$data['other_tank_size'] ,'tank_sizes' ,'size') ,$html);
	 $html = str_replace("{job_topanels}" ,$this->getidothervalue($data['panel_type_id'] ,$data['other_panel_type'] ,'panel_types' ,'type') ,$html);
          $html = str_replace("{it_type}" ,$this->getidothervalue($data['installation_type_id'] ,$data['other_installation_type'] ,'installation_types' ,'type') ,$html);

   $html = str_replace("{job_nopanels}" ,$data['panel_count'] ,$html);


	 $html = str_replace("{job_sizepanels}" ,$this->getidothervalue($data['panel_size_id'] ,$data['other_panel_size'] ,'panel_sizes' ,'size') ,$html);

	 $html = str_replace("{job_gasheater}" ,$data['heater_location'] ,$html);
	 $html = str_replace("{job_loexistheater}" ,$data['existing_heater_location'] ,$html);


	 if($data['remove_old_tank']=="y")
       $data['remove_old_tank'] = "Yes";
   else
       $data['remove_old_tank'] = "No";

	 $html = str_replace("{job_rotank}" , $data['remove_old_tank'] ,$html);

	  if($data['relocate_old_tank']=="y")
       $data['relocate_old_tank'] = "Yes";
   else
       $data['relocate_old_tank'] = "No";

	 $html = str_replace("{job_rotank}" , $data['relocate_old_tank'] ,$html);

	   if($data['relocate_old_tank']=="y")
       $data['relocate_old_tank'] = "Yes";
   else
       $data['relocate_old_tank'] = "No";

	 $html = str_replace("{job_tankaccess}" , $this->changevalue($data['solar_tank_accessible']) ,$html);
	 $html = str_replace("{job_sprd}" ,$this->getidothervalue($data['piperun_length'] ,$data['otherpiperun_length'] ,'pipe_run_distance' ,'type')." ft"  ,$html);
   $html = str_replace("{job_tpr}" ,$this->getidothervalue($data['piperun_type_id'] ,$data['other_piperun_type'] ,'piperun_types' ,'type') ,$html);
	 $html = str_replace("{job_or}" ,$data['roof_orientation'] ,$html);
	 $html = str_replace("{job_pr}" ,$data['roof_pitch'] ,$html);

	 $html = str_replace("{rt_job}" ,$this->getidothervalue($data['roof_type_id'] ,$data['roof_type_id'] ,'roof_types' ,'type') ,$html);

	 $html = str_replace("{rmt_job}" ,$this->getidothervalue($data['rafter_type_id'] ,$data['other_rafter_type'] ,'rafter_types' ,'type') ,$html);
        $html = str_replace("{dbr_job}" ,$data['rafter_distance']." ft"  ,$html);


	 $html = str_replace("{job_colorroof}" ,$data['roof_color'] ,$html);
	 $html = str_replace("{nof_job}" ,$data['stories'] ,$html);
         if($data['pump_type_id']==1){
            $data['pump_type_id'] = 'DC';
         }else if($data['pump_type_id']==2){
            $data['pump_type_id'] = 'AC';
         }
         $html = str_replace("{job_top}" ,$data['pump_type_id'] ,$html);



   $contractor = $data['contractor_id'];
   $temp =explode(",",$contractor);
   $cnamei = array();
   foreach($temp as $c=>$v) {
    $cnamei[] = $this->getUserIntial($v,true);
   }
   /* Electric  specification */

   $html = str_replace("{un_elec}" ," ",$html);
   
   $html = str_replace("{comment_elec}" ,$data['comments'] ,$html);


   $sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['customer_id'])." AND jobs.id!=".$this->db->escape($jobid)." ORDER BY jobs.job_date ASC";


         $otherjob = array();
	 $other_jobs = $this->db->query($sql)->result_array();
         $other_data = "";
         foreach ($other_jobs as $key => $value){
	  $other_data .='<a href="'.base_url().'admin/job/'.$value['id'].'">'.$value['job_type'].'('.date("M j, Y",strtotime($value['job_date'])).')</a><br />';
	 }
	 $html = str_replace("{job_others}" ,$other_data , $html);

	 $img = "";
   $this->db->where("job_id",$jobid);
   $this->db->order_by("created","desc");
   $mpdf=new mPDF('s');
   $mpdf->SetDisplayMode('fullpage');
   $mpdf->WriteHTML($html);
   $data =$mpdf->Output($customername_pdf,'D');

   }
   function tabstatusjob($job_id){
  $this->load->library("job");
  $this->load->helper("text");
  $json['finaceclass'] = $this->job->getfinancetabclass($job_id);
  $json['customerclass'] = $this->job->getcustomertabclass($job_id);
  $json['jobclass'] = $this->job->getjobtabclass($job_id,'active');
  $json['percent_completed'] = $this->job->percent_completed($job_id);
  echo json_encode($json);
  }
  function tabstatusfinance($job_id){
  $this->load->library("job");
  $this->load->helper("text");
  $json['finaceclass'] = $this->job->getfinancetabclass($job_id,'active');
  $json['customerclass'] = $this->job->getcustomertabclass($job_id);
  $json['jobclass'] = $this->job->getjobtabclass($job_id);
  $json['percent_completed'] = $this->job->percent_completed($job_id);
  echo json_encode($json);
  }
  function tabstatuscustomer($job_id){
  $this->load->library("job");
  $this->load->helper("text");
  $json['finaceclass'] = $this->job->getfinancetabclass($job_id);
  $json['customerclass'] = $this->job->getcustomertabclass($job_id,'active');
  $json['jobclass'] = $this->job->getjobtabclass($job_id);
  $json['percent_completed'] = $this->job->percent_completed($job_id);
  echo json_encode($json);
  }
 
  function tabstatusgenral($job_id){
  $this->load->library("job");
  $this->load->helper("text");
  $json['finaceclass'] = $this->job->getfinancetabclass($job_id);
  $json['customerclass'] = $this->job->getcustomertabclass($job_id);
  $json['jobclass'] = $this->job->getjobtabclass($job_id);
  $json['percent_completed'] = $this->job->percent_completed($job_id);
  echo json_encode($json);
  }
 function getparentjobid($job_id){
   $resultcnt =  $this->db->query("SELECT job_pid FROM jobs  where id = $job_id")->result_array();
   $pid = $resultcnt[0]['job_pid'];
   if(!$pid){
    $pid =$job_id;
   }
   return $pid;
 }
 function job_file($job_id){
    $data = array();

		$data['job_id'] = $job_id;

		$this->load->library("job");
		$this->load->helper("text");

		if($job_id=='') { redirect('admin/error?e=job_id'); }

		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();

		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['titlejob'] = "Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Prelag'; }
                $data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
		// daily job limit
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);

                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();

		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                $install_assign = $data['job']['installer_id'];
                $installer_assign_array = explode("," ,$install_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $data['installer_assign']=array();
                $data['installer_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$installer_assign_array )){
                          $data['installer_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $data['installer_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                    }
                $data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']!=5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                $data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $this->load->view("common/header");
                $data['error'] = '';
                $this->load->view("admin/job_file",$data);
                $this->load->view("common/footer");
  }
  public function do_upload($job_id) {
	$upload_path_url = base_url().'uploads/';
	$config['upload_path'] = FCPATH.'uploads/';
        $config['encrypt_name'] = true;
	$config['allowed_types'] = 'pdf|docx|doc|txt|jpg|jpeg|png|gif';
       // $config['allowed_types'] = 'gif|jpg|png';
        $config['max_size'] = 10485760;
       
  	$this->load->library('upload', $config);
        
        if ( !$this->upload->do_upload()){
            
            $error = array('error' => $this->upload->display_errors());
           
            $this->load->view('admin/error_file', $error);
  	}
  	else {
	   $data = $this->upload->data();
           $row['original_filename'] = $data['orig_name'];
           $row['unique_filename'] = $data['file_name'];
           $row['mime'] = $data['file_type'];
           $row['created'] = date("Y-m-d h:i:s");
           $pid_job = $this->getparentjobid($job_id);
           $row['job_id'] = $pid_job;
           $row['file_size'] = $data['file_size']*1024;
           $row['title'] = $data['orig_name'];
           $row['desc'] =  $data['orig_name'];
           $this->db->insert("meter_files",$row);
           $this->load->helper('text');
           $file_id = $this->db->insert_id();
           $info->name = $data['orig_name'];
           $info->size = $data['file_size']*1024;
           $info->type = $data['file_type'];
           $info->url =  $upload_path_url .$data['file_name'];
           $info->imagedetailurl = base_url().'admin/filedetails'."/".$file_id;
           if ($data['file_type']=="image/jpeg" || $data['file_type']=="image/jpeg" || $data['file_type']=="image/png" || $data['file_type']=="image/gif" ) {
               $rowp['spmsip_job']= 'yes';
               $this->db->where('id', $job_id);
               $this->db->update('jobs', $rowp);
               $info->thumbnail_url = $upload_path_url .$data['file_name'];//I set this to original file since I did not create thumbs.  change to thumbnail directory if you do = $upload_path_url .'/thumbs' .$data[file_name]
           } else if($data['file_type']=="application/pdf" ||$data['file_type']== '"application/pdf"' ){
                $info->thumbnail_url = base_url()."/assets/images/file_pdf.ico";
           } else if($data['file_type']=="text/plain" || $data['file_type']=="application/msword"){
               $info->thumbnail_url = base_url()."/assets/images/doc_files.ico";
           }
           $info->delete_url = base_url().'admin/deleteImage/'.$data['file_name']."/".$file_id;
           $info->delete_type = 'DELETE';
           echo json_encode(array($info));
           exit;
           if (IS_AJAX) {   //this is why we put this in the constants to pass only json data
                   
	           
                    //this has to be the only the only data returned or you will get an error.
                    //if you don't give this a json array it will give you a Empty file upload result error
                    //it you set this without the if(IS_AJAX)...else... you get ERROR:TRUE (my experience anyway)
                      }
	else {   // so that this will still work if javascript is not enabled
		  	$file_data['upload_data'] = $this->upload->data();
		  	$this->load->view('admin/upload_success', $file_data);
		}

	 }

}


public function deleteImage($file,$file_id=0)//gets the job done but you might want to add error checking and security
	{
		if(!$file){
                    $sql = "SELECT * FROM  meter_files WHERE id=".$file_id;
                    $data = $this->db->query($sql)->row_array();
                    $file  = $data['unique_filename'];
                }
                if($file_id){
                 $this->db->where("id",$file_id);
                 $this->db->delete('meter_files');
                }
                
                $success =@unlink(FCPATH.'uploads/' .$file);
		//info to see if it is doing what it is supposed to
		$info->sucess =$success;
		$info->path =base_url().'uploads/' .$file;
		$info->file =is_file(FCPATH.'uploads/' .$file);
	if (IS_AJAX) {//I don't think it matters if this is set but good for error checking in the console/firebug
	    echo json_encode(array($info));}
	else {     //here you will need to decide what you want to show for a successful delete
		redirect("admin/fileview_job/".$data['job_id']."?savedata=1");
	   }
}
public function filedetails($file_id, $reload=0){
  $data['file_id']= $file_id;
  if($file_id){
     $sql = "SELECT * FROM  meter_files WHERE id=".$file_id;
     $data['file'] = $this->db->query($sql)->row_array();
  }

  $data['reload'] = $reload;
  $this->load->view('admin/filedetails', $data);

  
}
public function  savefiledetails($file_id){
$data['file_id']= $file_id;
  $row['title'] = $this->input->post("title");
  $row['desc'] = $this->input->post("desc");
  $this->db->where("id",$file_id);
  $this->db->update("meter_files",$row);
  $json['success'] = true;
  echo json_encode($json);
}
function fileview_job($job_id){
     $data = array();

		$data['job_id'] = $job_id;

		$this->load->library("job");
		$this->load->helper("text");
                $this->load->helper("thumbnail_helper");

		if($job_id=='') { redirect('admin/error?e=job_id'); }

		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();

		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
                 if($data['job']['job_type_id'] == 6 ) { $data['titleshow'] = 'PreLag'; }
                $data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
		// daily job limit
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);

                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();

		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                $pid_job = $this->getparentjobid($job_id);
                $this->db->where("job_id",$pid_job);
		$this->db->order_by("created","desc");
		$data['files'] = $this->db->get("meter_files")->result_array();

                $install_assign = $data['job']['installer_id'];
                $installer_assign_array = explode("," ,$install_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $data['installer_assign']=array();
                $data['installer_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$installer_assign_array )){
                          $data['installer_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $data['installer_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                    }
                $data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']!=5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                $data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $this->load->view("common/header");
                $this->load->view("admin/fileview",$data);
                $this->load->view("common/footer");
}
 function showimage($file_id){
     $this->load->helper("thumbnail_helper");
     echo  "<style>#facebox .footer {
      border-top: none !important;
     }</style>";
   if($file_id) {
     $sql = "SELECT * FROM  meter_files WHERE id=".$file_id;
     $data['file'] = $this->db->query($sql)->row_array();
     $imagedim = getimagesize(base_url().'/uploads/'.$data['file']['unique_filename']);
     if ($imagedim[0]<=600 ||$imagedim[0]<=400){
        echo  '<img src="'.base_url().'/uploads/'.$data['file']['unique_filename'].'"  width="400" />';
     } else{
               echo  '<img src="'.thumbnail($data['file']['unique_filename'], 600, 400).'"  width="400" />';
     } 
 }
 }

function scheduleprint($year='',$month=''){
    if($year=='') {
        $year = date("Y");
    }
    if($month=='') {
        $month = date("m");
        $year = preg_replace("/[^0-9]/","",$year);
	$month = preg_replace("/[^0-9]/","",$month);
    }
    $data['year'] = $year;
    $data['month'] = $month;
    $j = array();
    $jobs = array();
    
    $j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id ,users.first_name as ufirstname , 
            users.last_name ulastname, cs.first_name as csfirstname ,
            cs.last_name as cslastname ,cs.address as csstate,cs.city as cscity,cs.association as  csassociation,
            job_types.intials as job_type
            FROM jobs 
            LEFT JOIN job_types ON job_types.id=jobs.job_type_id
            LEFT JOIN  customers cs ON jobs.customer_id = cs.id  
            LEFT JOIN users ON jobs.user_id=users.id 
            LEFT JOIN colors ON users.color_id=colors.id 
            WHERE DATE_FORMAT(jobs.job_date,'%Y-%m') = '".$year."-".$month."' ORDER BY jobs.job_date ASC")->result_array();
    
     $this->db->where("type","installer");
     $this->db->order_by("first_name","desc");
     $installeruser = $this->db->get("users")->result_array();
     $installer_data = array();
     
     foreach($installeruser as $rowdata){
      $installer_data[] = $rowdata['id'];

    }
    $r_jobsplit = $this->db->query("select  job_pid ,count(job_pid) as cntjob from jobs where id!=job_pid group by job_pid ")->result_array();
    $rsplitjob = array();
    foreach($r_jobsplit as $key1 => $value1){
        $rsplitjob[$value1["job_pid"]]= $value1["cntjob"]; 
    }
    $arr_splitjob= array();
    foreach($j as $key => $value){
     $conductid_arr = array();
     
     if(array_key_exists($value["job_pid"],$rsplitjob)){
       if (in_array($value["job_pid"],$arr_splitjob)){
           $temp_array = array();
           $temp_array = array_keys($arr_splitjob,$value["job_pid"]);
           if(count($temp_array)==1){
            $value['cslastname'].= " <br/>(Day 2) ";   
           }
           if(count($temp_array)==2){
            $value['cslastname'].= " <br/>(Day 3) ";   
           }
           $arr_splitjob[] =$value["job_pid"];
           
       }else{
            $value['cslastname'].= " <br/>(Day 1) "; 
            $arr_splitjob[] = $value["job_pid"];
       }
       
        /*if ($value["job_pid"]==$value["id"]){
            $value['cslastname'].= " (Day 1) "; 
        }else if ($rsplitjob[$value["job_pid"]]==1){
           $value['cslastname'].= " (Day 2)"; 
        }else if ($rsplitjob[$value["job_pid"]]>1){
          $value['cslastname'].= $this->splitjobday($value["job_pid"],$value["job_date"]) ; 
        } */  
     }
     if($value['conduit_id']){
     $conductid_arr = explode(",",$value['conduit_id']);
     $value['conduit_id']  = '';
     $temp = array();
     foreach ($conductid_arr as $arr){
        $temp[]= $this->getUserEmpNo($arr);
     }
     $value['conduit_id']= implode(",",$temp )    ;
     } else{
         $value['conduit_id']  = '';
     }
     if($value['contractor_id']){
        $contractor_arr = array();
        $contractor_arr = explode(",",$value['contractor_id']);
        $value['contractor_id']  = '';
        $temp = array();
        foreach ($contractor_arr as $arr){
          $temp[] = $this->getUserIntial($arr);
        }
        $value['contractor_id']  = implode(",",$temp); 
     }


        $installer_id_table = array();
        $installer_id_table = explode(",",$this->getdayinstaller($value['job_date']));
        
        $noassignedinstaller = array_diff($installer_data,$installer_id_table );
        $newnoassign = array();
        foreach($noassignedinstaller as $id){
          $newnoassign[] = $this->getUserEmpNo($id);
        }
       
        $value['off'] = implode(",",$newnoassign);
        $installer_no = explode(",",$value['installer_id']);

        $newinsatller_no = array();
        foreach($installer_no as $id){
          $newinsatller_no[] = $this->getUserEmpNo($id);
        }
        $temp = implode(",",$newinsatller_no);
        if($temp){
        $value['installer_id'] = $temp;
        } else{
            $value['installer_id'] = "";
        }
        $value['roof_type_id'] = $this->getidothervalue($value['roof_type_id'] ,$value['other_roof_type'] ,'roof_types' ,'type');
        $value['jobs_emt'] = $this->getidothervalue($value['jobs_emt'] ,$value['other_jobs_emt'] ,'electric_wire_type' ,'type');
        $jobs[date("j", strtotime($value['job_date']))][] = $value;

    }
    $data["j"] = $j;
    $data["jobs"] = $jobs;
    $this->load->view("admin/printschedule",$data);
 }
  function printyearmonth(){
      $data['calendar_months'] = array('01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr', '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Aug', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec');
      $data['calendar_years'] = array();
      for($i=date("Y",strtotime("-2 years")); $i<date("Y",strtotime("+2 years")); $i++){
	$data['calendar_years'][$i] = $i;
      }
      $this->load->view("admin/printyearmonth",$data);
  }
  function getdayinstaller($job_date){
     $rs = $this->db->query("SELECT installer_id FROM jobs WHERE  job_date='$job_date' ")->result_array();
     $temp = array();
     foreach ($rs as $key=>$value){
        $temp[] = $value['installer_id'];
     }
     if(count($temp)){
       return implode(",",$temp);
     }

  }
  function splitjobday($job_id,$job_date){
     $rs = $this->db->query("SELECT count(*) as cntjob FROM jobs WHERE job_pid=$job_id && job_date<'$job_date' ")->result_array();
     if ($rs[0]["cntjob"]>0){
        return "(Day 3)";           
     } else {
       return "(Day 2)";   
     }
  }
  function permit_job($job_id){
    $data = array();
    
		$data['job_id'] = $job_id;

		$this->load->library("job");
		$this->load->helper("text");

		if($job_id=='') { redirect('admin/error?e=job_id'); }

		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();

		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
                if($data['job']['job_type_id'] == 6 ) { $data['titleshow'] = 'PreLag'; }
                
                $data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
		// daily job limit

                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] = $jobtimelimit1;
                   }

                }
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);

                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();

		$pid = $this->getparentjobid($job_id);
                // grab job files
		$this->db->where("job_id",$pid);
                $this->db->where("type",'building');
                $this->db->order_by("created","desc");
                $data['permit_file_building'] = array();
		$data['permit_file_building'] = $this->db->get("permit_files")->result_array();
                
                // grab job files
		$this->db->where("job_id",$pid);
                $this->db->where("type",'netmeter');
		$this->db->order_by("created","desc");
                $data['permit_file_netmeter'] = array();
		$data['permit_file_netmeter'] = $this->db->get("permit_files")->result_array();
                
                // grab job files
		$this->db->where("job_id",$pid);
                $this->db->where("type",'homeowner');
		$this->db->order_by("created","desc");
                $data['permit_file_homeowner'] = array();
		$data['permit_file_homeowner'] = $this->db->get("permit_files")->result_array();
                
                // grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                
               
                $this->db->where("type","designer");
		$this->db->order_by("first_name","desc");
		$designeruser = $this->db->get("users")->result_array();
                $data['designer_user'] = array();
                foreach($designeruser as $row) {
                    $data['designer_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                }
                $data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']!=5){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                $data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
                //$totalinstaller = $this->db->query("SELECT GROUP_CONCAT(installer_id) as totalinstaller FROM jobs   WHERE jobs.job_date = '".$data['job']['job_date']."' GROUP BY jobs.job_date ")->result_array();
		//$data['totalinstallercnt'] = $totalinstaller[0]['totalinstaller'];
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $this->load->view("common/header");
                $this->load->view("admin/job_permit",$data);
                $this->load->view("common/footer");
  }
  
  function createservicepdf($jobid){
  
   $html = $this->load->view("admin/createpdfhtml_service",'',true);
   $j = array();
 // include("C:\wamp\www\sites\\trunk\scheduler\MPDF53\mpdf.php");
   //include("C:\wamp\www\sites\\trunk\scheduler\mergepdf\mergepdf.php");
   include("/var/www/vhosts/aeihawaii.com/httpdocs/MPDF531/mpdf.php");
   include("/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/mergepdf/mergepdf.php");
   $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
                        customers.email,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			customers.home_phone,
                        customers.secondary_phone,
                        customers.association,
                        customers.heco_account_number,
                        customers.heco_meter_number,
                        job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($jobid)."
		";
     $data = $this->db->query($sql)->row_array();
    
     $userload = $this->getuser($data['user_id']);
     $customername = $data['first_name']." ".$data['last_name'];
    $username = $userload[0]->first_name." ".$userload[0]->last_name;
    $html = str_replace("{salesman_name}" ,$username ,$html);
    $customername_pdf = $data['first_name']."-".$data['last_name'].".pdf";
   /* Customer Information*/
   
   $html = str_replace("{customer_name}" ,$customername ,$html);
   $html = str_replace("{address_customer}" ,$data['address'] ,$html);
   $html = str_replace("{city_customer}" ,$data['city'] ,$html);
   $html = str_replace("{zipcode_customer}" ,$data['zip_code'] ,$html);
   $html = str_replace("{email_customer}" ,$data['email'] ,$html);
   $html = str_replace("{telephone_customer}" ,"'".$data['home_phone']." ".$data['secondary_phone']."'" ,$html);
   $html = str_replace("{assoc_customer}" ,$data['association'], $html);
   if($data['job_date']) {
    $html = str_replace("{installdate_customer}" ,date("F jS, Y ",strtotime($data['job_date'])) ,$html);
   }else {
    $html = str_replace("{installdate_customer}" ,"Unscheduled Job" ,$html);
   }
   $html = str_replace("{dow_customer}" ,date("l",strtotime($data['job_date'])) ,$html);

   /* System Information*/

   $html = str_replace("{tor}" ,$data['repair_time'] ,$html);
   $html = str_replace("{tyor}" ,$data['repair_type'] ,$html);
   $html = str_replace("{dopn}" ,$data['servicedesc'] ,$html);
    $contractor = $data['contractor_id'];
   $temp =explode(",",$contractor);
   $cnamei = array();
   foreach($temp as $c=>$v) {
    $u_name =  $this->getUserIntial($v,true);
    if($u_name)
        $cnamei[] = $u_name;
    }
   $html = str_replace("{contractor}" ,implode(",",$cnamei) , $html );
   
   
   $html = str_replace("{comments}" ,$data['comments'] ,$html);
    
 
  $mpdf=new mPDF('s');
  $mpdf->WriteHTML($html);
  $mpdf->Output($customername_pdf,"D");
  
   }
   function  issendnotification($user_id){
   $sql = "SELECT user_id FROM  notification_setting WHERE user_id = $user_id";
   $rowe = array();
   $rowe = $this->db->query($sql)->result_array();
   if(count($rowe)>1 && $rowe[0]['user_id']){
      return true;
   }else{
        $row['user_id'] = $user_id;
        return false;
   }

 }
 function globalnotifcation(){
   $sql  = "SELECT notification from notification_setting WHERE id=1";
   $nresult =  $this->db->query($sql)->result_array();
   if(!$nresult[0]['notification']) return 'false' ;
 }
 function changevalue($value){
     if($value=='y') return 'Yes';
     return 'No';
  }
 function setjobschedule(){
     $result =  $this->db->query("SELECT * FROM jobs ")->result_array();
      $this->load->library("job");
      foreach($result as $key => $value){
        	 $per = (int)$this->job->percent_completed($value['id']);
                 if( $per == 97){
                     
                     $sql_presale = "SELECT count(*) as cnt from sketch_files where job_id=".$value['job_pid'];
                     $result1 = mysql_query($sql_presale);
                     $res = @mysql_fetch_object($result1);
                     $is_sketch_exit = false;
                     if(@$res->cnt){
                        $is_sketch_exit = true;
                      }
                      if(!$is_sketch_exit){
                          $resultcnt =  $this->db->query("SELECT * FROM timelimit_manual_extend where jid = '".$value['job_pid']."'")->result_array();
                          if(count($resultcnt)>=1) {
                            $row['timeext'] =  168;
                            $row['created_on'] = date("Y-m-d h:i:s");
                            $this->db->where('jid',$value['job_pid']);
                            $this->db->update('timelimit_manual_extend', $row);

                         } else{
                        $row['timeext'] =  168;
                        $row['jid']=$value['job_pid'];
                        $row['created_on'] = date("Y-m-d h:i:s");
                        $this->db->insert("timelimit_manual_extend",$row);
                        }
                        $sql = "UPDATE jobs set current_status='inprogress' WHERE job_pid=".$value['job_pid'];
                        $this->db->query($sql);
                      }
                  }
      }
      return;
  }
}
?>