<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

Class Acproposal extends Controller {

    function Acproposal() {

        parent::Controller();
        error_reporting(E_ALL);
        if (!$this->session->userdata('logged_in') || !$this->session->userdata('proposal_access')) {
            redirect("login?ref=acproposal");
        }


        // if user is an installer, redirect them to an error page if
        // they're trying to do something they do have permissions to do

        $this->load->helper(array('form', 'url'));
    }

    function countValidZone($proposal_id) {
        $sql = "SELECT count(id) as total FROM acproposalzone WHERE acproposal_id = '" . $proposal_id . "' AND price>0 ORDER BY zone_type";
        $rs = $this->db->query($sql)->row_array();
        return $rs['total'];
    }

    function getAcProposalCityList() {
        $sql = "SELECT city FROM acproposal GROUP BY city ORDER BY city";
        return $this->db->query($sql)->result_array();
    }

    function getAllSalesUser() {
        $sql = "SELECT user_id FROM acproposal GROUP BY user_id ORDER BY user_id";
        return $this->db->query($sql)->result_array();
    }

    function getZoneList($proposal_id) {
        $sql = "SELECT * FROM acproposalzone WHERE acproposal_id = '" . $proposal_id . "' ORDER BY zone_type";
        return $this->db->query($sql)->result_array();
    }

    function getZonealoneList($proposal_id) {
        $sql = "SELECT * FROM acproposalzone WHERE acproposal_id = '" . $proposal_id . "' AND  zone_type=1";
        return $this->db->query($sql)->result_array();
    }

    function index() {
        $data = array();
        $this->load->library('pagination');
        $this->load->helper('url');
        $limit = $this->input->get("limit");
        $urlstring = array();
		$data['proposal']=array();
        //set the status of proposal to archive older then 30 days
        //$this->set_proposal_arch();
        $urlstring = explode("&per_page=", $_SERVER["QUERY_STRING"]);
        if (count($urlstring) == 1) {
            $urlstring[0] = "q=0" . $urlstring[0];
        }
        $config['base_url'] = base_url() . "acproposal/index?" . $urlstring[0];
        if ($limit > 30) {
            $limit = 30;
        }
        if ($limit == 'all') {
            $limit = '9999';
        }
        if ($limit == '' || !isset($limit)) {
            $limit = 30;
        }
        $data['limit'] = $limit;
        if ($limit == '9999') {
            $data['limit'] = 'all';
        }
        //$data["statususerd"] = array("0"=>"status1","1"=>"status2","2"=>"status3");
        $config['per_page'] = $limit;
        $where = '';
        if (strtotime($this->input->get('datepicker1_txt'))) {
            $where .= ' AND AC.created >= "' . date('Y-m-d', strtotime($this->input->get('datepicker1_txt'))) . '"';
        }
        if (strtotime($this->input->get('datepicker2_txt'))) {
            $where .= ' AND AC.created <= "' . date('Y-m-d', strtotime($this->input->get('datepicker2_txt'))) . '"';
        }
        if ($this->input->get('cityname') != '' && $this->input->get('cityname') != '-1') {
            $where .= " AND AC.city = '" . $this->input->get('cityname') . "'";
        }
        if ($this->input->get('salesuser') != '' && $this->input->get('salesuser') != '-1') {
            $where .= " AND AC.user_id = '" . $this->input->get('salesuser') . "'";
        }
        if (strtotime($this->input->get('datepicker3_txt'))) {
            $where .= ' AND AC.created = "' . date('Y-m-d', strtotime($this->input->get('datepicker3_txt'))) . '"';
        }
        if ($this->input->get('name_dpp') != '') {
            if (count(explode(' ', $this->input->get('name_dpp'))) > 1) {
                $name = explode(' ', $this->input->get('name_dpp'));
                $where .= ' AND (AC.first_name like "%' . $name[0] . '%" OR AC.last_name like "%' . $name[1] . '%")';
            } else
                $where .= ' AND AC.first_name like "%' . $this->input->get('name_dpp') . '%"';
        }
		 $user_filter="";
         if($this->session->userdata('role') != 'admin'){
           $user_filter =  " AND user_id=".$this->session->userdata("user_id");
         }
        $sqlc = "SELECT count(*) as  numrows FROM acproposal AC WHERE 1=1 $where $user_filter";
        $jobcnt = $this->db->query($sqlc)->result_array();
        $config['total_rows'] = $jobcnt[0]["numrows"];
        $perpage = $this->input->get("per_page") >= 1 ? $this->input->get("per_page") : 0;
        $this->pagination->initialize($config);
        $sql = "SELECT * FROM acproposal AS AC WHERE 1=1 and is_delete=0  $user_filter $where order by AC.id desc limit " . $perpage . " , " . $config['per_page'];
        // $data['proposal'] = $this->db->query($sql)->result_array();
        $data['proposal_t'] = $this->db->query($sql)->result_array();
        $data["links"] = $this->pagination->create_links();
        $city_arr = array();
        $city_arr["-1"] = "All";
        foreach ($this->getAcProposalCityList() as $city) {
            $city_arr[urlencode($city['city'])] = urlencode($city['city']);
        }

        $data['city_arr'] = $city_arr;
        $salesuserarr['-1'] = 'Select Salesman';
        foreach ($this->getAllSalesUser() as $saleuser) {

            $saleuser_name = $this->getUserIntial($saleuser["user_id"]);
            $salesuserarr[$saleuser["user_id"]] = $saleuser_name;
        }
        $data['saleuser'] = $salesuserarr;
        $data['limit_dd']['5'] = '5';
        $data['limit_dd']['10'] = '10';
        $data['limit_dd']['20'] = '20';
        $data['limit_dd']['30'] = '30';
        $data['limit_dd']['all'] = 'all';
        foreach ($data['proposal_t'] as $proposal) {
            $proposal['booking_date'] = $this->getjobBookingdate($proposal['id']);
            $proposal["saleuser_name"] = $this->getUserIntial($proposal["user_id"]);
            $salesuser[$proposal["user_id"]] = $proposal["saleuser_name"];
            $city_arr[urlencode($proposal['city'])] = ucfirst($proposal['city']);

            if ($proposal['is_schedule']) {
                $proposal['scheduled_date'] = $this->getjobdate($proposal['id']);
            } else {
                $proposal['scheduled_date'] = "";
            }
            $data['proposal'][] = $proposal;
        }
        $this->load->view("common/header");

        $this->load->view("acproposal/index", $data);
        $this->load->view("common/footer");
    }

    function proposal_basic() {
        $dealtype[''] = 'Select deal type';
        $dealtype[1] = 'Alternate Energy - HVAC';
        $unittype[''] = 'Select Unit Type';
        $unittype['1'] = 'Mitsubishi M-Series Ductless Split AC';
        $unittype['2'] = 'Fujitsu';
        $data['dealtype'] = $dealtype;
        $data['unittype'] = $unittype;
        $aeispecial[''] = 'Select an AEI Special';
        $aeispecial['1'] = 'AEI Special 1';
        $aeispecial['2'] = 'AEI Special 2';
        $data['aeispecial'] = $aeispecial;
        $data['states'] = array('' => "- Choose a state -");
        $arr_state = array_keys(array('AK' => "Alaska", 'AL' => "Alabama", 'AR' => "Arkansas", 'AZ' => "Arizona", 'CA' => "California", 'CO' => "Colorado", 'CT' => "Connecticut", 'DC' => "District Of Columbia", 'DE' => "Delaware", 'FL' => "Florida", 'GA' => "Georgia", 'HI' => "Hawaii", 'IA' => "Iowa", 'ID' => "Idaho", 'IL' => "Illinois", 'IN' => "Indiana", 'KS' => "Kansas", 'KY' => "Kentucky", 'LA' => "Louisiana", 'MA' => "Massachusetts", 'MD' => "Maryland", 'ME' => "Maine", 'MI' => "Michigan", 'MN' => "Minnesota", 'MO' => "Missouri", 'MS' => "Mississippi", 'MT' => "Montana", 'NC' => "North Carolina", 'ND' => "North Dakota", 'NE' => "Nebraska", 'NH' => "New Hampshire", 'NJ' => "New Jersey", 'NM' => "New Mexico", 'NV' => "Nevada", 'NY' => "New York", 'OH' => "Ohio", 'OK' => "Oklahoma", 'OR' => "Oregon", 'PA' => "Pennsylvania", 'RI' => "Rhode Island", 'SC' => "South Carolina", 'SD' => "South Dakota", 'TN' => "Tennessee", 'TX' => "Texas", 'UT' => "Utah", 'VA' => "Virginia", 'VT' => "Vermont", 'WA' => "Washington", 'WI' => "Wisconsin", 'WV' => "West Virginia", 'WY' => "Wyoming"));
        $data['states'] +=array_combine($arr_state, $arr_state);
        $data['mzone'] = array('' => 'Select Multi-Zone', 1 => 'MZ1', 2 => 'MZ2', 3 => 'MZ3');
        $data['neighbour'][''] = "Select Geographical Area ";
        $this->db->where('is_new =', 1);
        $neighbour_display = $this->db->get("neigbhour")->result_array();
        foreach ($neighbour_display as $row) {
            $data['neighbour'][$row['id']] = $row['neighbour'];
        }
        $this->session->unset_userdata('tabs_selected');
        if (is_numeric($this->input->get('id'))) {
            $sql = "SELECT * FROM acproposal WHERE id = '" . $this->input->get('id') . "'";
            $data["proposal"] = $this->db->query($sql)->row_array();
        }
        $this->load->view("acproposal/proposal_basic", $data);
    }

    // checking if customer exists or not
    function checkexistcustomer() {
        $sql = "SELECT id FROM acproposal WHERE user_id!=" . $this->session->userdata('user_id') . " AND address = '" . $this->input->post("address") . "' AND
			 									   city = '" . $this->input->post("city") . "' AND
												   state = '" . $this->input->post("state") . "' AND
												   zip = '" . $this->input->post("zip") . "'";
        $address = $this->db->query($sql)->result_array();
        $json['success'] = true;
        $json['success_admin'] = false;
        if (count($address)) {
            $json['success'] = false;
            if ($this->session->userdata("role") == 'admin') {
                $json['msg'] = "A proposal already created with same address,Please confirm";
                $json['success_admin'] = true;
                $json['success'] = true;
            } else
                $json['msg'] = "A Proposal is already created for this customer by other Saleuser, please contact to admin";
        }
        echo json_encode($json);
        return;
    }

    // showing sales user name
    function getUserIntial($id, $fullname = false) {
        if (!$id)
            return 0;
        $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
        $intial = "";
        foreach ($j as $key => $value) {
            $intial = ucfirst($value['first_name'][0]) . ucfirst($value['last_name'][0]);
            if ($fullname) {
                $intial = ucfirst($value['first_name']) . " " . ucfirst($value['last_name']);
            }
        }
        return $intial;
    }

    // validating proposal basic here 
    function validate_propbasic() {

        $this->load->library('validation');
        $new_customer = false;
        // set validation rules
        $rules['re_first_name'] = "required";
        $rules['re_first_name'] = "required";
        $rules['address'] = "required";
        $rules['city'] = "required|alphabet";
        $rules['state'] = "required";
        $rules['zip'] = "required|alpha_numeric";
        $rules['neighborhood'] = "required";
        $rules['avgzoneenergy'] = "required|numeric";
        $other_name = $this->input->post("is_married");

        if ($other_name == 1 || $other_name == 2 || $other_name == 3) {
            $rules['re_ot_first_name'] = "required";
            $rules['re_ot_last_name'] = "required";
        }
        // set field "real" names
        $fields['deal_type'] = "Deal Type";
        $fields['unittype'] = "Unit Type";
        $fields['re_first_name'] = "First Name";
        $fields['re_last_name'] = "Last Name";
        $fields['re_ot_first_name'] = "First Name(Other)";
        $fields['re_ot_last_name'] = "Last Name(Other";
        $fields['address'] = "Address";
        $fields['state'] = "State";
        $fields['city'] = "City";
        $fields['zip'] = "Zip";

        $fields['neighborhood'] = "Geographical Area";
        $fields['avgzoneenergy'] = "Solar Sunshine Zone";

        $this->validation->set_message('alpha_numeric', 'There is an illegal character being used, please check that there are no spaces or non-alpha-numeric characters.');
        $this->validation->set_rules($rules);
        $this->validation->set_fields($fields);
        if ($this->validation->run() == FALSE) {
            $json['success'] = false;
            $json['msg'] = $this->validation->error_string;
            echo json_encode($json);
            //  return ;
        } else {
            $row['customer_id'] = $this->input->post("customer_id");
            $row['customer_exist'] = $this->input->post("customer_exist");
            $inc_sys_comp = $this->input->post('inc_sys_comp') ? 1 : 0;
            if ($this->input->post('if')) {

                $sql = "UPDATE acproposal SET first_name = '" . $this->input->post('re_first_name') . "',
														last_name = '" . $this->input->post('re_last_name') . "',
														address = '" . $this->input->post('address') . "',
														state = '" . $this->input->post('state') . "',
														city = '" . $this->input->post('city') . "',
														zip = '" . $this->input->post('zip') . "',
														email	= '" . $this->input->post('email') . "',
														customer_id = '" . $this->input->post("customer_id") . "',
														customer_exist = '" . $this->input->post("customer_exist") . "',
														neighborhood = '" . $this->input->post("neighborhood") . "',
														avgzoneenergy = '" . $this->input->post("avgzoneenergy") . "',
														phone = '" . $this->input->post("phone") . "',
														updated = '" . date('Y-m-d') . "' WHERE id = '" . $this->input->post('if') . "'";
                $this->db->query($sql);
                $json['id'] = $this->input->post('if');
                $json['success'] = true;
                echo json_encode($json);
            } else {
                $sql = "INSERT INTO acproposal SET first_name = '" . $this->input->post('re_first_name') . "',
														last_name = '" . $this->input->post('re_last_name') . "',
														address = '" . $this->input->post('address') . "',
														state = '" . $this->input->post('state') . "',
														city = '" . $this->input->post('city') . "',
														zip = '" . $this->input->post('zip') . "',
														deal_type = '" . $this->input->post('deal_type') . "',
														unittype = '" . $this->input->post('unittype') . "',
														aeioffer = '" . $this->input->post('aeioffer') . "',
														email	= '" . $this->input->post('email') . "',
														cur_ele_rate	= '" . $this->input->post('cur_ele_rate') . "',
														cur_eg_use	= '" . $this->input->post('cur_eg_use') . "',
														customer_id = '" . $this->input->post("customer_id") . "',
														customer_exist = '" . $this->input->post("customer_exist") . "',
														inc_sys_comp	= '" . $inc_sys_comp . "',
														created = '" . date('Y-m-d') . "',
														neighborhood = '" . $this->input->post("neighborhood") . "',
														avgzoneenergy = '" . $this->input->post("avgzoneenergy") . "',
														phone = '" . $this->input->post("phone") . "',
														user_id = '" . $this->session->userdata("user_id") . "'";
                $this->db->query($sql);
                $json['id'] = $this->db->insert_id();
                $json['success'] = true;
                echo json_encode($json);
            }
        }
    }

    function systempricelist() {
        $sql = "SELECT * from ac_system_price ORDER by type desc ";
        $data["system_var"] = $this->db->query($sql)->result_array();
        $this->load->view("common/header");
        $this->load->view("acproposal/system_price", $data);
        $this->load->view("common/footer");
    }

    function createzone($proposal_id) {
        $data['mop'][''] = '- Select an Expected Payment Method  -';
        $data['mop']['amex'] = 'AMEX';
        $data['mop']['visa'] = 'VISA';
        $data['mop']['mc'] = 'MC';
        $data['mop']['cash/Check'] = 'Cash/Check';
        $data['mop']['financing'] = 'Financing';
        $data['mop']['other'] = 'Other';

        $data['costadj'][''] = '- Select an Cost Adjustment  -';
        $data['costadj']['0'] = 'COST AJ1';
        $data['costadj']['1'] = 'COST AJ2';
        $data['costadj']['2'] = 'COST AJ3';

        // coundit zone
        $data['counduit'][''] = 'SELECT Lineset Run Length';
        $data['counduit'][1] = '0 to 30';
        $data['counduit'][2] = '31 to 50';
        $data['counduit'][3] = '51 to 75';
        $data['counduit'][4] = '76 to 100';
        $data['counduit'][5] = '100+';


        $dealtype[''] = 'Select deal type';
        $dealtype[1] = 'Alternate Energy - HVAC';
        $unittype[''] = 'Select Unit Type';
        $unittype['1'] = 'Mitsubishi M-Series Ductless Split AC';
        //$unittype['2'] = 'Fujitsu';
        $data['dealtype'] = $dealtype;
        $data['unittype'] = $unittype;
        $data["proposal_id"] = $proposal_id;
        $roomname[''] = 'Select Room Type';
        $roomname[1] = 'Living Room';
        $roomname[2] = 'Bed Room';
        $data['roomname'] = $roomname;
        $aeispecial[''] = 'Select an AEI Special';
        //$aeispecial['1'] = 'No specials currently';
        $aeispecial['2'] = 'AEI Customer AC Special';
		$aeispecial['3'] = 'Aei Mitsubishi hvac special';
        $data['aeispecial'] = $aeispecial;
        $room_exposure_longest_wall[''] = 'Select ROOM EXPOSURE--Longest wall';
        $room_exposure_longest_wall['4'] = 'West';
        $room_exposure_longest_wall['3'] = 'East';
        $room_exposure_longest_wall['6'] = 'South';
        $room_exposure_longest_wall['5'] = 'North';
        $data['room_exposure_longest_wall'] = $room_exposure_longest_wall;
        $data['mzone'] = array('' => 'Select Multi-Zone', 1 => 'MZ1', 2 => 'MZ2', 3 => 'MZ3');

        $sql_unitout1 = "SELECT * FROM  acsystem_price_proposal WHERE proposal_id=$proposal_id and type='mitsubishiunitsin'";
        $result_unitout1 = $this->db->query($sql_unitout1)->result_array();
        $data["misoutunit1"][0] = "Change Recommended unit";
        foreach ($result_unitout1 as $value) {
            $data["misoutunit1"][$value["id"]] = $value["title"];
        }
        $sql_unitout2 = "SELECT * FROM  acsystem_price_proposal WHERE proposal_id=$proposal_id and type='mitsubishiunitsin1'";
        $result_unitout2 = $this->db->query($sql_unitout2)->result_array();
        $data["misoutunit2"][0] = "Change Additional unit";
        foreach ($result_unitout2 as $value) {
            $data["misoutunit2"][$value["id"]] = $value["title"];
        }

        $sql_price = "SELECT * FROM  acsystem_price_proposal WHERE proposal_id=$proposal_id";
        $result_price = $this->db->query($sql_price)->result_array();
        $data['system_price'] = $result_price;
        if (count($result_price) < 2) {
            $sql_propsoal_price = "INSERT INTO `acsystem_price_proposal`(`proposal_id`,id, `type`, `title`, `price`, `created`, `select_id`, `modified`, `formula`) SELECT  $proposal_id,`id`,`type`, `title`, `price`, `created`, `select_id`, `modified`, `formula` FROM ac_system_price where is_show=1;";
            $this->db->query($sql_propsoal_price);
            $sql_price = "SELECT * FROM  acsystem_price_proposal WHERE proposal_id=$proposal_id";
            $data['system_price'] = $this->db->query($sql_price)->result_array();
        }
        $system_price_json = array();
        foreach ($data['system_price'] as $value) {
            $system_price_json[$value['id']] = $value;
        }
        $data['systemprice_json'] = json_encode($system_price_json);
        if (is_numeric($this->input->get('id'))) {
            $sql = "SELECT * FROM acproposal WHERE id = '" . $this->input->get('id') . "'";
            $data['proposal'] = $this->db->query($sql)->row_array();
            if ($this->input->get('zone_id')) {
                $sql = "SELECT * FROM acproposalzone WHERE id = '" . $this->input->get('zone_id') . "'";
                $data['zone'] = $this->db->query($sql)->row_array();
            }
            $this->load->view("acproposal/zoneform", $data);
        } else
            echo 'Invalid Proposal';
    }

    function updatevariable($variableid) {
        if (!$variableid) {
            redirect("admin/error?e=permissions");
        }
        $sql_variable = "SELECT * from ac_system_price where id=" . $variableid;
        $data["variable"] = $this->db->query($sql_variable)->row_array();
        $data["systemprice_id"] = $variableid;
        $this->load->view("acproposal/edit_systemprice", $data);
    }

    function validate_updatevariable() {
        $this->load->library('validation');
        $new_customer = false;
        // set validation rules
        $rules['title'] = "required";
        //  $rules['price']	= "numeric";
        // set field "real" names
        $fields['title'] = "Title";
        $fields['price'] = "Price";
        $this->validation->set_rules($rules);
        $this->validation->set_fields($fields);
        if ($this->validation->run() == FALSE) {
            $json['success'] = false;
            $json['msg'] = $this->validation->error_string;
            echo json_encode($json);
            return;
        } else {
            $row = array();
            $row['title'] = $this->input->post('title');
            $row['price'] = $this->input->post('price');
            $row['formula'] = $this->input->post('formula');
            $id = $this->input->post('id');
            $this->db->where('id', $id);
            $this->db->update("ac_system_price", $row);

            $json['success'] = true;
            $json['msg'] = "System Price has been updated Successfully.";
            echo json_encode($json);
        }
    }

    function updatevartitle($variableid) {
        if (!$variableid) {
            redirect("admin/error?e=permissions");
        }
        $data["systemprice_id"] = $variableid;
        $sql_variable = "SELECT * from ac_system_price where id=" . $variableid;
        $data["variable"] = $this->db->query($sql_variable)->row_array();
        $this->load->view("acproposal/edit_vartitle", $data);
    }

    function validate_updatevartitle() {
        $this->load->library('validation');
        $rules['title'] = "required";
        $fields['title'] = "Title";
        $this->validation->set_rules($rules);
        $this->validation->set_fields($fields);
        if ($this->validation->run() == FALSE) {
            $json['success'] = false;
            $json['msg'] = $this->validation->error_string;
            echo json_encode($json);
            return;
        } else {
            $row = array();
            $row['title'] = $this->input->post('title');
            $id = $this->input->post('id');
            $this->db->where('id', $id);
            $this->db->update("ac_system_price", $row);
            $json['success'] = true;
            $json['msg'] = "Title has been updated Successfully.";
            echo json_encode($json);
        }
    }

    function updatevarprice($variableid) {
        if (!$variableid) {
            redirect("admin/error?e=permissions");
        }
        $data["systemprice_id"] = $variableid;
        $sql_variable = "SELECT * from ac_system_price where id=" . $variableid;
        $data["variable"] = $this->db->query($sql_variable)->row_array();
        $this->load->view("acproposal/edit_varprice", $data);
    }

    function validate_updatevarprice() {
        $row = array();
        $row['price'] = $this->input->post('price');
        $id = $this->input->post('id');
        $this->db->where('id', $id);
        $this->db->update("ac_system_price", $row);

        $json['success'] = true;
        $json['msg'] = "System Price has been updated Successfully.";
        echo json_encode($json);
    }

    function updateformula($variableid) {
        if (!$variableid) {
            redirect("admin/error?e=permissions");
        }
        $data["systemprice_id"] = $variableid;
        $sql_variable = "SELECT * from ac_system_price where id=" . $variableid;
        $data["variable"] = $this->db->query($sql_variable)->row_array();
        $this->load->view("acproposal/edit_varformula", $data);
    }

    function validate_updateformula() {
        $row = array();
        $row['formula'] = $this->input->post('formula');
        $id = $this->input->post('id');
        $this->db->where('id', $id);
        $this->db->update("ac_system_price", $row);
        $json['success'] = true;
        $json['msg'] = "Formula has been updated Successfully.";
        echo json_encode($json);
    }

    function savezone() {
        $this->load->library('validation');
        $rules['zone_title'] = "required";
        $fields['zone_title'] = "Zone Title";
        $rules['deal_type'] = "required";
        $fields['deal_type'] = "Deal Type";
        $rules['unittype'] = "required";
        $fields['unittype'] = "Unit Type";


        $rules['room_square_footage'] = "required|numeric";
        $fields['room_square_footage'] = "Square footage";
        $rules['nopeople'] = "required|numeric";
        $fields['nopeople'] = "No of people";
        $rules['room_exposure_longest_wall'] = "required";
        $fields['room_exposure_longest_wall'] = "ROOM EXPOSURE--Longest wall";
        $rules['room_btu'] = "required";
        $fields['room_btu'] = "Room BUT";
        $zone_type = $this->input->post('zone_type_calc');
        $this->validation->set_rules($rules);
        $this->validation->set_fields($fields);
        if ($this->validation->run() == FALSE && $zone_type != 2) {
            $json['success'] = false;
            $json['msg'] = $this->validation->error_string;
            echo json_encode($json);
            return;
        } else {
            $data['acproposal_id'] = $this->input->post('proposal_id');
            $data['deal_type'] = $this->input->post('deal_type');
            $data['unittype'] = $this->input->post('unittype');
            //$data['aeioffer'] = $this->input->post('aeioffer');
            $data['roomname'] = $this->input->post('roomname');
            $data['room_square_footage'] = $this->input->post('room_square_footage');
            $data['nopeople'] = $this->input->post('nopeople');
            $data['room_exposure_longest_wall'] = $this->input->post('room_exposure_longest_wall');
            $data['room_on_top_floor'] = $this->input->post('room_on_top_floor');
            $data['room_insulated'] = $this->input->post('room_insulated');
            $data['room_btu'] = $this->input->post('room_btu');
            $data['kitchen_in_the_room'] = $this->input->post('kitchen_in_the_room');
            $data['comm_preview'] = $this->input->post('comm_preview');
            $data['is_delete'] = 0;

            $data['reccomended_unit_1'] = $this->input->post('reccomended_unit_1');
            $data['additional_unit_1'] = $this->input->post('additional_unit_1');


            $data['reccomended_unit_id'] = $this->input->post('reccomended_unit_id');
            $data['additional_unit_id'] = $this->input->post('additional_unit_id');


            $data['add_work_required'] = $this->input->post('add_work_required');
            $data['add_cost'] = $this->input->post('add_cost');
            $data['over_pipe_run'] = $this->input->post('over_pipe_run');
            $data['extra_distance'] = $this->input->post('extra_distance');
            $data['discount'] = $this->input->post('discount');
            $data['upcharge'] = $this->input->post('upcharge');
            $data['zone_title'] = $this->input->post('zone_title');
            $data['price'] = $this->input->post('price');
            $data['reccomended_unit_1_price'] = $this->input->post('reccomended_unit_1_price');
            $data['additional_unit_1_price'] = $this->input->post('additional_unit_1_price');
            $data['reccomended_unit_1_coolingbtu'] = $this->input->post('reccomended_unit_1_coolingbtu');
            $data['additional_unit_1_coolingbtu'] = $this->input->post('additional_unit_1_coolingbtu');
            $data['comments'] = $this->input->post('comments');

            $proposal['deal_type'] = $this->input->post('deal_type');
            $proposal['unittype'] = $this->input->post('unittype');
            $proposal['aeioffer'] = $this->input->post('aeioffer');
            $proposal['cur_ele_rate'] = $this->input->post('cur_ele_rate');
            $proposal['cur_eg_use'] = $this->input->post('cur_eg_use');
            $proposal['inc_sys_comp'] = $this->input->post('inc_sys_comp');
            $proposal['finish'] = $this->input->post('finishbtn');
            $proposal['updated'] = date('Y-m-d H:i:s');

            $data['mz_total_btu'] = $this->input->post('mz_total_btu');
            $data['mz_indoor_unit'] = $this->input->post('mz_indoor_unit');
            $data['mz_outdoor_unit'] = $this->input->post('mz_outdoor_unit');
            $data['additional_unit_delete'] = $this->input->post('additional_unit_delete');
            $data['reccomended_unit_delete'] = $this->input->post('reccomended_unit_delete');
            $data['additional_unit_edit'] = $this->input->post('additional_unit_edit');
            $data['reccomended_unit_edit'] = $this->input->post('reccomended_unit_edit');
            $data['additional_ounit_id'] = $this->input->post('additional_ounit_id');
            $data['reccomended_ounit_id'] = $this->input->post('reccomended_ounit_id');


            $this->db->where('id', $this->input->post('proposal_id'));
            $this->db->update('acproposal', $proposal);

            if (is_numeric($this->input->post('zone_id')) && $this->input->post('zone_id') != '') {
                $data['modified'] = date('Y-m-d H:i:s');
                $this->db->where('id', $this->input->post('zone_id'));
                $this->db->update('acproposalzone', $data);
            } else {
                $data['created'] = date('Y-m-d H:i:s');
                $this->db->insert('acproposalzone', $data);
            }
            $json['success'] = true;
            echo json_encode($json);
        }
    }

    function custname() {
        $sql_user = " AND user_id=" . $this->session->userdata("user_id") . " AND ";
        if ($this->session->userdata("role") == 'admin') {
            $sql_user = "";
        }
        $input = trim($this->input->post("query"));
        $sql = "SELECT * from  acproposal where 1 = 1 $sql_user AND (first_name  like '$input%' or last_name LIKE '$input%' or id like '$input%' ) ";
        $row_customer = $this->db->query($sql)->result_array();
        $cust_arr = array();
        $json_arr = array();
        $json_arr["success"] = false;
        $json_arr["query"] = "Unit";
        foreach ($row_customer as $rowdata) {
            $cust_arr = array();
            $cust_arr['value'] = $rowdata['id'];
            $cust_arr['data'] = $rowdata['first_name'] . " " . $rowdata['last_name'];
            $json_arr["suggestions"][] = $cust_arr;
        }
        if (count($cust_arr) > 1) {
            $json_arr["success"] = true;
        }
        //$new_json_arr[]=$json_arr;
        echo json_encode($json_arr);
    }

    function deletezone() {
        if ($this->input->post('id') && is_numeric($this->input->post('id'))) {
            $this->db->where('id', $this->input->post('id'));
            $this->db->delete('acproposalzone');
            $json_arr["success"] = true;
            echo json_encode($json_arr);
        }
    }

    // creating copy of proposal


    function makecopy() {

        if (is_numeric($this->input->post('id'))) {
            $this->load->library('validation');
            $rules['deal_type'] = "required";
            $fields['deal_type'] = "Deal Type";
            $rules['unittype'] = "required";
            $fields['unittype'] = "Unit Type";
            $this->validation->set_rules($rules);
            $this->validation->set_fields($fields);
            if ($this->validation->run() == FALSE) {
                $json['success'] = false;
                $json['msg'] = $this->validation->error_string;
                echo json_encode($json);
                return;
            } else {
                $sql = "SELECT * FROM acproposal WHERE id ='" . $this->input->post('id') . "'";

                $data = $this->db->query($sql)->row_array();
                $ids = $data['id'];
				$sql = "INSERT INTO acproposal SET proposal_pid = '" . $this->input->post('id') . "',
		 									first_name = '" . $data['first_name'] . "',
											last_name = '" . $data['last_name'] . "',
											email = '" . $data['email'] . "',
											address = '" . $data['address'] . "',
											city = '" . $data['city'] . "',
											state = '" . $data['state'] . "',
											zip = '" . $data['zip'] . "',
                                            neighborhood = '" . $data['neighborhood'] . "',
                                            phone = '" . $data['phone'] . "',
                                            avgzoneenergy = '" . $data['avgzoneenergy'] . "',
											user_id = '" . $this->session->userdata('user_id') . "',
											created = '" . date('Y-m-d H:i:s') . "',
											deal_type = '" . $this->input->post('deal_type') . "',
											unittype = '" . $this->input->post('unittype') . "',
											aeioffer = '" . $this->input->post('aeioffer') . "',
											cur_ele_rate = '" . $this->input->post('cur_ele_rate') . "',
											cur_eg_use = '" . $this->input->post('cur_eg_use') . "',
                                            inc_sys_comp = '" . $this->input->post('inc_sys_comp') . "', apply_permit_fee=".$data['apply_permit_fee']."";

                $this->db->query($sql);
                $id = $this->db->insert_id();
                $last_id = $this->db->insert_id();


                
                $json_arr["id"] = $last_id;
                $json_arr["success"] = true;
                echo json_encode($json_arr);
            }
        }
    }

    function copyzone() {
        $this->load->library('validation');

        //$rules['deal_type'] = "required";
        //$fields['deal_type'] = "Deal Type";
        //$rules['unittype'] = "required";
        //$fields['unittype'] = "Unit Type";
        //$rules['room_square_footage'] = "required|numeric";
        //$fields['room_square_footage'] = "Square footage";
        //$rules['nopeople'] = "required|numeric";
        //$fields['nopeople'] = "No of people";
        //$rules['room_exposure_longest_wall'] = "required";
        //$fields['room_exposure_longest_wall'] = "ROOM EXPOSURE--Longest wall";
        $rules['add_work_required'] = "required";
        $fields['room_btu'] = "Additional Work Required?";

        $this->validation->set_rules($rules);
        $this->validation->set_fields($fields);
        if ($this->validation->run() == FALSE) {
            $json['success'] = false;
            $json['msg'] = $this->validation->error_string;
            echo json_encode($json);
            return;
        } else {
            $data['acproposal_id'] = $this->input->post('proposal_id');
            $data['acproposal_id'] = $this->input->post('proposal_id');
            $data['deal_type'] = $this->input->post('deal_type');
            $data['unittype'] = $this->input->post('unittype');
            $data['roomname'] = $this->input->post('roomname');
            $data['room_square_footage'] = $this->input->post('room_square_footage');
            $data['nopeople'] = $this->input->post('nopeople');
            $data['room_exposure_longest_wall'] = $this->input->post('room_exposure_longest_wall');
            $data['room_on_top_floor'] = $this->input->post('room_on_top_floor');
            $data['room_insulated'] = $this->input->post('room_insulated');
            $data['room_btu'] = $this->input->post('room_btu');
            $data['kitchen_in_the_room'] = $this->input->post('kitchen_in_the_room');

            $data['is_delete'] = 0;

            $data['reccomended_unit_1'] = $this->input->post('reccomended_unit_1');
            $data['additional_unit_1'] = $this->input->post('additional_unit_1');

            $data['reccomended_unit_id'] = $this->input->post('reccomended_unit_id');
            $data['additional_unit_id'] = $this->input->post('additional_unit_id');

            $data['add_work_required'] = $this->input->post('add_work_required');
            $data['add_cost'] = $this->input->post('add_cost');
            $data['over_pipe_run'] = $this->input->post('over_pipe_run');
            $data['extra_distance'] = $this->input->post('extra_distance');
            $data['discount'] = $this->input->post('discount');
            $data['upcharge'] = $this->input->post('upcharge');
            $data['zone_title'] = $this->input->post('zone_title');
            $data['price'] = $this->input->post('price');
            $data['reccomended_unit_1_price'] = $this->input->post('reccomended_unit_1_price');
            $data['additional_unit_1_price'] = $this->input->post('additional_unit_1_price');
            $data['reccomended_unit_1_coolingbtu'] = $this->input->post('reccomended_unit_1_coolingbtu');
            $data['additional_unit_1_coolingbtu'] = $this->input->post('additional_unit_1_coolingbtu');
            $data['comments'] = $this->input->post('comments');
            $data['comm_preview'] = $this->input->post('comm_preview');
            $proposal['deal_type'] = $this->input->post('deal_type');
            $proposal['unittype'] = $this->input->post('unittype');
            $proposal['aeioffer'] = $this->input->post('aeioffer');
            $proposal['cur_ele_rate'] = $this->input->post('cur_ele_rate');
            $proposal['cur_eg_use'] = $this->input->post('cur_eg_use');
            $proposal['inc_sys_comp'] = $this->input->post('inc_sys_comp');
            $proposal['updated'] = date('Y-m-d H:i:s');

            $data['mz_total_btu'] = $this->input->post('mz_total_btu');
            $data['mz_indoor_unit'] = $this->input->post('mz_indoor_unit');
            $data['mz_outdoor_unit'] = $this->input->post('mz_outdoor_unit');

            $data['additional_unit_delete'] = $this->input->post('additional_unit_delete');
            $data['reccomended_unit_delete'] = $this->input->post('reccomended_unit_delete');
            $data['additional_unit_edit'] = $this->input->post('additional_unit_edit');
            $data['reccomended_unit_edit'] = $this->input->post('reccomended_unit_edit');
            $data['additional_ounit_id'] = $this->input->post('additional_ounit_id');
            $data['reccomended_ounit_id'] = $this->input->post('reccomended_ounit_id');

            $data['created'] = date('Y-m-d H:i:s');
            $this->db->insert('acproposalzone', $data);
            $json['success'] = true;
            echo json_encode($json);
        }
    }

    function createpdfdesign() {
        $this->load->helper('download');
        $this->load->helper("thumbnail_helper");
        $proposal_id = $this->input->get('id');
        if (!$proposal_id) {
            redirect("admin/error?e=permissions");
        }
        $sql = "SELECT * from acproposal where id=" . $proposal_id;
        $data["proposal"] = $this->db->query($sql)->row_array();
        $data["proposal_month"] = $this->db->query("SELECT * from proposal_month where proposal_id=$proposal_id ORDER BY id")->result_array();
        $data["sales_user"] = $this->db->query("SELECT * from users where id=" . $data["proposal"]["user_id"] . " ")->row_array();

        $sql_mtype = "SELECT device_desc from acvariable where type='ac' and select_id=1";
        $data_mtype = $this->db->query($sql_mtype)->row_array();
        $data['moduletypedesc'] = $data_mtype['device_desc'];

        $sql_recktype1 = "SELECT device_desc from acvariable where type='reck_types' and select_id=1";
        $data_recktype1 = $this->db->query($sql_recktype1)->row_array();
        $data['reckone1'] = $data_recktype1['device_desc'];
        $sql_recktype2 = "SELECT device_desc from acvariable where type='reck_types' and select_id=2";
        $data_recktype2 = $this->db->query($sql_recktype2)->row_array();
        $data['reckone2'] = $data_recktype2['device_desc'];
        $sql_recktype3 = "SELECT device_desc from acvariable where type='reck_types' and select_id=3";
        $data_recktype3 = $this->db->query($sql_recktype3)->row_array();
        $data['reckone3'] = $data_recktype3['device_desc'];
        $data["zones"] = $this->db->query("SELECT * from acproposalzone where acproposal_id=$proposal_id")->result_array();

        $sql_unitout1 = "SELECT * FROM  acsystem_price_proposal WHERE proposal_id=$proposal_id and type='mitsubishiunitsout'";
        $result_unitout1 = $this->db->query($sql_unitout1)->result_array();
        $data["misoutunit1"][0] = "";
        foreach ($result_unitout1 as $value) {
            $data["misoutunit1"][$value["id"]] = $value["title"];
        }

        $sql_unitout2 = "SELECT * FROM  acsystem_price_proposal WHERE proposal_id=$proposal_id and type='mitsubishiunitsout1'";
        $result_unitout2 = $this->db->query($sql_unitout2)->result_array();
        $data["misoutunit2"][0] = "";
        foreach ($result_unitout2 as $value) {
            $data["misoutunit2"][$value["id"]] = $value["title"];
        }

        $sql_unitin1 = "SELECT * FROM  acsystem_price_proposal WHERE proposal_id=$proposal_id and type='mitsubishiunitsin'";
        $result_unitin1 = $this->db->query($sql_unitin1)->result_array();
        $data["misinunit1"][0] = "";
        foreach ($result_unitin1 as $value) {
            $data["misinunit1"][$value["id"]] = $value["title"];
        }

        $sql_unitin2 = "SELECT * FROM  acsystem_price_proposal WHERE proposal_id=$proposal_id and type='mitsubishiunitsin1'";
        $result_unitin2 = $this->db->query($sql_unitout2)->result_array();
        $data["misinunit2"][0] = "";
        foreach ($result_unitout2 as $value) {
            $data["misinunit2"][$value["id"]] = $value["title"];
        }

        $html = $this->load->view("acproposal/index-energy_d", $data, true);



        if ($this->session->userdata("user_id") == 35) {
            echo $html;
            die;
        }
        //  echo $html;
        //die;
        $t = rand(1, 99999);
        $fp = fopen(FCPATH . "pdftemp/temp$t-$proposal_id.html", "w+");
        fputs($fp, $html);
        fclose($fp);
        if ($data["proposal"]["deal_type"] == 1 || $data["proposal"]["deal_type"] == 2) {
            $footer_html = $this->load->view("proposal/footerhtml", $data, true);
        } else if ($data["proposal"]["deal_type"] == 3 || $data["proposal"]["deal_type"] == 4) {
            $footer_html = $this->load->view("proposal/footerhtml_discount", $data, true);
        }


        $footer_t = rand(1, 99999);
        $footer_fp = fopen(FCPATH . "pdftemp/footer$footer_t-$proposal_id.html", "w+");
        fputs($footer_fp, $footer_html);
        fclose($footer_fp);
        $footerhtml = FCPATH . "pdftemp/footer$footer_t-$proposal_id.html";
        exec("/var/www/vhosts/aeihawaii.com/httpdocs/page/wkhtmltopdf-i386 -B 20  --page-size A4 " . FCPATH . "pdftemp/temp$t-$proposal_id.html   --footer-html  $footerhtml  " . FCPATH . "pdftemp/proposal$t-$proposal_id.pdf ");
        if ($is_mail) {
            return FCPATH . "pdftemp/proposal$t-$proposal_id.pdf";
        } else {
            $data_file = file_get_contents(FCPATH . "pdftemp/proposal$t-$proposal_id.pdf"); // Read the file's contents
            @$name = "" . str_replace('"', "", $data["proposal"]["last_name"]) . "-" . str_replace('"', "", $data["proposal"]["first_name"]) . "-proposal" . $proposal_id . ".pdf";

            force_download($name, $data_file);
            unlink(FCPATH . "pdftemp/temp$t.html");
            unlink(FCPATH . "pdftemp/proposal$t.pdf");
        }
        //echo $html;
    }

    function proposal_savetempvariable($proposal_id, $variable_id, $price, $quantity, $unit, $zone_id) {
        $row = array();
        if (!$proposal_id) {
            if (!$this->session->userdata('proposal_id')) {
                $this->session->set_userdata(array('proposal_id' => $proposal_id));
            } else if ($this->session->userdata('proposal_id') != $proposal_id) {
                $sql = "DELETE FROM actemp_variable_job WHERE proposal_id=" . $this->session->userdata('proposal_id');
                $this->db->query($sql);
                $this->session->set_userdata(array('proposal_id' => $proposal_id));
            }
        }

        $row['proposal_id'] = $proposal_id;
        $row['variable_id'] = $variable_id;
        $row['price'] = $price;
        $row['quantity'] = $quantity;
        $row['unit'] = $unit;
        $row['zone_id'] = $zone_id;
        $row['created'] = time();
        $sql_isexist = "SELECT id FROM actemp_variable_job where proposal_id=$proposal_id AND variable_id=$variable_id AND zone_id = $zone_id";
        $is_variable = $this->db->query($sql_isexist)->row_array();
        if (isset($is_variable['id'])) {
            $this->db->where('id', $is_variable['id']);
            $this->db->update("actemp_variable_job", $row);
        } else {
            $this->db->insert("actemp_variable_job", $row);
        }
        $json['success'] = true;
        echo json_encode($json);
    }

    function proposal_savevariable($proposal_id) {
        $sql = "DELETE FROM acvariable_job WHERE proposal_id=" . $proposal_id;
        $this->db->query($sql);
        $sql = "INSERT INTO acvariable_job (variable_id,quantity,unit,price,proposal_id,created,zone_id) SELECT t.variable_id,t.quantity,t.unit,t.price,t.proposal_id,t.created,t.zone_id  FROM actemp_variable_job t WHERE t.proposal_id=$proposal_id";
        $this->db->query($sql);
        $sql = "DELETE FROM actemp_variable_job WHERE proposal_id=" . $proposal_id;
        $this->db->query($sql);
        $json['success'] = true;
        echo json_encode($json);
    }

    function createpdfpart($proposal_id, $job_type = 1) {
        if ($this->session->userdata("role") != 'admin') {
            redirect("admin/error?e=permissions");
        }
        ini_set("display_errors", "1");
        if ($this->session->userdata('user_id') == 167) {
            $arr["superadmin"] = 1;
            $this->session->set_userdata($arr);
        }
        $this->load->helper('download');
        $data = array();
        if (!$proposal_id) {
            redirect("admin/error?e=permissions");
        }
        $sql_proposal = "SELECT * from acproposal where id=$proposal_id";
        $data['proposals'] = $this->db->query($sql_proposal)->row_array();
        $sql = "SELECT	*
		FROM
			acproposal

		WHERE id=" . $this->db->escape($proposal_id) . "";
        $data_job = $this->db->query($sql)->row_array();

        $data["show_cost"] = 0;
        if ($job_type == 4) {
            $job_type = 1;
            $data["show_cost"] = 1;
        }
        $job_type_arr = array("0" => "Select Job Type", "1" => "Full Install", "2" => "Pre-lagged Pv install", "3" => "Prelag", "4" => "Full install with Full Cost");
        $data["job_type_arr"] = $job_type_arr;
        $data["job_type"] = $job_type;
        if ($data_job["is_schedule"]) {

            if ($job_type == 3) {
                $data_proposal_job = $this->db->query("SELECT contractor_id,installer_id,job_date,inv_commit FROM jobs where job_type_id=6 AND proposal_id=$proposal_id")->row_array();
            } else {
                $data_proposal_job = $this->db->query("SELECT contractor_id,installer_id,job_date,inv_commit FROM jobs  where  job_type_id=2  AND proposal_id=$proposal_id")->row_array();
            }
            $contractor = @$data_proposal_job['contractor_id'];
            $data["job_date"] = @$data_proposal_job['job_date'];
            $data["invcommit"] = @$data_proposal_job['inv_commit'];
            $temp = explode(",", $contractor);
            $cnamei = array();
            foreach ($temp as $c => $v) {
                $tech = $this->getUserIntial($v, true);
                if ($tech)
                    $cnamei[] = $tech;
            }
            $installer_id = @$data_proposal_job['installer_id'];
            $temp = explode(",", $installer_id);
            $installname = array();
            foreach ($temp as $c => $v) {
                if ($v) {
                    $installern = $this->getUserIntial($v, true);
                    if ($installern)
                        $installname[] = $installern;
                }
            }

            $data["installer"] = implode(",", $installname);
            $data["technicain"] = implode(",", $cnamei);
        }
        $data['job'] = $data_job;
        $data["neighborhood"] = "";
        /* if($data_job["neighborhood"]){
          $sql = "SELECT neighbour from  neigbhour where id=".$data_job['neighborhood'];
          $row_neighbour = $this->db->query($sql)->row_array();
          $data["neighborhood"] = ucfirst($row_neighbour['neighbour']);

          } */
        $data["sales_man"] = $this->getUserIntial($data_job["user_id"], true);

        $sql_price = "SELECT * FROM  acsystem_price_proposal WHERE proposal_id=$proposal_id";
        $result_price = $this->db->query($sql_price)->result_array();
        if (count($result_price) < 2) {
            $sql_propsoal_price = "INSERT INTO `acsystem_price_proposal`(`proposal_id`,id, `type`, `title`, `price`, `created`, `select_id`, `modified`, `formula`) SELECT  $proposal_id,`id`,`type`, `title`, `price`, `created`, `select_id`, `modified`, `formula` FROM ac_system_price;";
            $this->db->query($sql_propsoal_price);
        }
        $sql = "SELECT id,zone_type FROM acproposalzone WHERE acproposal_id = '" . $proposal_id . "' ORDER BY zone_type";
        $data['zones'] = $this->db->query($sql)->result_array();
        // zone query start here --
        foreach ($data['zones'] as $zone_data) {

            $sql = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job  LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . " order by variable_job.id ";
            //die;

            $data["pdf_data"][$zone_data['id']] = $this->db->query($sql)->result_array();

            $data["pdf_data_mitsubishi_outputunits"][$zone_data['id']] = array();

            $sql_module = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job LEFT JOIN acsystem_price_proposal  as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . " AND  variable_job.variable_id in (1,7,8,9,10,11,12,43,44,45,46,47,48,49,62,63,64,65,66)  order by variable_job.id ";
            //die;
            $data["pdf_data_mitsubishi_outputunits"][$zone_data['id']] = $this->db->query($sql_module)->result_array();


            $data["pdf_data_mitsubishi_inputunits"][$zone_data['id']] = array();

            $sql_inverter = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . " AND  variable_job.variable_id in (13,14,15,16,17,18,19,51,52,53,54,55,56,57,67,68,69,70,71)  order by variable_job.id ";
            //die;
            $data["pdf_data_mitsubishi_inputunits"][$zone_data['id']] = $this->db->query($sql_inverter)->result_array();

            $data["pdf_fujitsu_units"][$zone_data['id']] = array();

            $sql_fujitsu_units = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . "  AND variable_job.variable_id in (20,21,22,23,24,25)  order by variable_job.variable_id  asc";
            //die;
            $data["pdf_fujitsu_units"][$zone_data['id']] = $this->db->query($sql_fujitsu_units)->result_array();

            $data["pdf_adders"][$zone_data['id']] = array();

            $sql_adders = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . "  AND  variable_job.variable_id in (26,27,28,29)  order by variable_job.variable_id";

            $data["pdf_adders"][$zone_data['id']] = $this->db->query($sql_adders)->result_array();

            $data["pdf_labor"][$zone_data['id']] = array();

            $sql_labor = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . "  AND  variable_job.variable_id in (34,35,36,37)  order by variable_job.variable_id ";
            $data["pdf_labor"][$zone_data['id']] = $this->db->query($sql_labor)->result_array();

            $data["pdf_electrical_parts"][$zone_data['id']] = array();
            $sql_electrical_parts = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . "  AND  variable_job.variable_id in (30,31,32,33)  order by variable_job.variable_id ";
            $data["pdf_electrical_parts"][$zone_data['id']] = $this->db->query($sql_electrical_parts)->result_array();

            $data["pdf_referral"][$zone_data['id']] = array();
            $sql_referral = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . "  AND  variable_job.variable_id in (58)  order by variable_job.id ";
            $data["pdf_referral"][$zone_data['id']] = $this->db->query($sql_referral)->result_array();


            $data["pdf_overhead"][$zone_data['id']] = array();

            $sql_overhead = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . "  AND  variable_job.variable_id in (38) AND system_price_proposal.title is not null  order by variable_job.id ";
            //die;
            $data["pdf_overhead"][$zone_data['id']] = $this->db->query($sql_overhead)->result_array();
            $data["pdf_profitmargin"][$zone_data['id']] = array();

            $sql_profitmargin = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . "  AND  variable_job.variable_id in (39) AND system_price_proposal.title is not null  order by variable_job.id ";
            //die;
            $data["pdf_profitmargin"][$zone_data['id']] = $this->db->query($sql_profitmargin)->result_array();

            $data["pdf_commission"][$zone_data['id']] = array();
            $sql_commission = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . "  AND  variable_job.variable_id in (40)  order by variable_job.id ";
            //die;
            $data["pdf_commission"][$zone_data['id']] = $this->db->query($sql_commission)->result_array();

            $data["pdf_getax"][$zone_data['id']] = array();
            $sql_getax = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . "  AND  variable_job.variable_id in (41)  order by variable_job.id ";

            //die;
            $data["pdf_getax"][$zone_data['id']] = $this->db->query($sql_getax)->result_array();

            $data["pdf_ccprice"][$zone_data['id']] = array();
            $sql_ccprice = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job  LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . "  AND  variable_job.variable_id in (59)  order by variable_job.id ";
            //die;
            $data["pdf_ccprice"][$zone_data['id']] = $this->db->query($sql_ccprice)->result_array();


            $data["pdf_fprice"][$zone_data['id']] = array();

            $sql_fprice = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . "  AND  variable_job.variable_id in (60)  order by variable_job.id ";

            //die;
            $data["pdf_fprice"][$zone_data['id']] = $this->db->query($sql_fprice)->result_array();
            $data["pdf_permit"][$zone_data['id']] = array();

            $sql_permit = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . "  AND  variable_job.variable_id in (42)  order by variable_job.zone_id, variable_job.id ";

            //die;
            $data["pdf_permit"][$zone_data['id']] = $this->db->query($sql_permit)->result_array();
            $sql_service = "SELECT variable_job.*,system_price_proposal.title FROM acvariable_job as variable_job LEFT JOIN acsystem_price_proposal as system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.zone_id=" . $zone_data['id'] . "  AND  variable_job.variable_id in (103)  order by variable_job.zone_id, variable_job.id ";

            //die;
            $data["pdf_service"][$zone_data['id']] = $this->db->query($sql_service)->result_array();
        }
        $html = $this->load->view("acproposal/pdfpart", $data, true);
        
        $t = rand(1, 99999);
        $fp = fopen(FCPATH . "pdftemp/partpdf$t-$proposal_id.html", "w+");
        fputs($fp, $html);

        fclose($fp);
        exec("/var/www/vhosts/aeihawaii.com/httpdocs/page/wkhtmltopdf-i386 -B 20 " . FCPATH . "pdftemp/partpdf$t-$proposal_id.html     " . FCPATH . "pdftemp/partpdf$t-$proposal_id.pdf ");
        $data_file = file_get_contents(FCPATH . "pdftemp/partpdf$t-$proposal_id.pdf"); // Read the file's contents
        @$name = "" . $data["proposal"]["last_name"] . "-" . $data["proposal"]["first_name"] . "-partpdf" . $proposal_id . ".pdf";
        force_download($name, $data_file);
    }

    function savemzonetype() {
        $json['success'] = false;
        $mzonelist = array('' => 'Select Multi-Zone', 1 => 'MZ1', 2 => 'MZ2', 3 => 'MZ3');
        if ($this->input->post('mzonefor') && $this->input->post('mzoneid') && $this->input->post('zone_id')) {
            $sql = "SELECT acproposal_id FROM acproposalzone WHERE id = " . $this->input->post('zone_id');
            $proposal = $this->db->query($sql)->row_array();
            $sql = "SELECT count(id) totalrow FROM acproposalzone WHERE acproposal_id = '" . $proposal['acproposal_id'] . "' AND zone_type = '2' AND mzone_id = " . $this->input->post('mzoneid');
            $mzone = $this->db->query($sql)->row_array();
            if ($mzone['totalrow'] == 0) {
                $sql = "SELECT * FROM  acproposalzone WHERE id = '" . $this->input->post('zone_id') . "'";
                $zone = $this->db->query($sql)->row_array();
                $insertsql = "INSERT INTO acproposalzone SET acproposal_id	=	'" . $zone['acproposal_id'] . "',deal_type	=	'" . $zone['deal_type'] . "'";
                $this->db->query($insertsql);
                $id = $this->db->insert_id();
                $sqlup = "UPDATE acproposalzone SET zone_type = '2',mzone_id=" . $this->input->post('mzoneid') . " WHERE id = " . $id;
                $this->db->query($sqlup);
                if ($this->input->post('mzonefor') == 1)
                    $zonefor = 'mzone_rec1_id';
                else
                    $zonefor = 'mzone_rec2_id';
                $updatezone = "UPDATE acproposalzone SET $zonefor = " . $this->input->post('mzoneid') . " WHERE id = " . $this->input->post('zone_id');
                $this->db->query($updatezone);


                $json['msg'] = '<a href="javascript:void(0);" onclick="showChangeMZ(\'1\',' . $this->input->post('zone_id') . ')" style="color:#418E1C">' . $mzonelist[$this->input->post('mzoneid')] . '</a><span><a href="javascript:void(0);" style="color:red" onclick="deleteMzone(' . $this->input->post('mzonefor') . ',' . $this->input->post('zone_id') . ')">X</a></span>';
                $json['success'] = true;
            }
            else {
                if ($this->input->post('mzonefor') == 1)
                    $zonefor = 'mzone_rec1_id';
                else
                    $zonefor = 'mzone_rec2_id';
                $updatezone = "UPDATE acproposalzone SET $zonefor = " . $this->input->post('mzoneid') . " WHERE id = " . $this->input->post('zone_id');
                $this->db->query($updatezone);
                $json['msg'] = '<a href="javascript:void(0);" onclick="showChangeMZ(1,' . $this->input->post('zone_id') . ')" style="color:#418E1C">' . $mzonelist[$this->input->post('mzoneid')] . '</a><span><a href="javascript:void(0);" style="color:red" onclick="deleteMzone(' . $this->input->post('mzonefor') . ',' . $this->input->post('zone_id') . ')">X</a></span>';
                $json['success'] = true;
            }
        }
        echo json_encode($json);
    }

    function delmzone() {
        $json['success'] = false;
        $mzonelist = array('' => 'Select Multi-Zone', 1 => 'MZ1', 2 => 'MZ2', 3 => 'MZ3');
        if ($this->input->post('mzonefor') && $this->input->post('zone_id')) {
            if ($this->input->post('mzonefor') == 1)
                $zonefor = 'mzone_rec1_id';
            else
                $zonefor = 'mzone_rec2_id';
            $updatezone = "UPDATE acproposalzone SET $zonefor = '' WHERE id = " . $this->input->post('zone_id');
            $this->db->query($updatezone);
            $json['success'] = true;
        }
        echo json_encode($json);
    }

    function updatesummary() {
        $json['success'] = false;
        if ($this->input->post('proposal_id')) {
            if ($this->input->post('apply_permit_fee'))
                $apply_permit_fee = 1;
            else
                $apply_permit_fee = 0;
            $update = "UPDATE acproposal SET additional_discount = '" . $this->input->post('additional_discount') . "',
												 additional_cost = '" . $this->input->post('additional_cost') . "',
												 promotion_code = '" . $this->input->post('promotion_code') . "',
												 note = '" . $this->input->post('note') . "',
												 payment_note = '" . $this->input->post('payment_note') . "',
												 mop = '" . $this->input->post('mop') . "',
												 other_mop = '" . $this->input->post('other_mop') . "',
												 finacing_mop = '" . $this->input->post('finacing_mop') . "',
												 apply_permit_fee = '" . $apply_permit_fee . "',
												 price = '" . $this->input->post('price') . "',
												 costadj = '" . $this->input->post('costadj') . "' WHERE id = '" . $this->input->post('proposal_id') . "'";
            $this->db->query($update);
            $json['success'] = true;
        }
        echo json_encode($json);
    }

    function tabsession() {
        if ($this->input->post('tab')) {
            $this->session->set_userdata('tabs_selected', $this->input->post('tab'));
        }
    }

    function commission_form($proposal_id) {
        if (!$this->session->userdata('access') || !$proposal_id) {
            redirect("admin/error?e=permissions");
        }
        $data = array();
        @$data['financed_price'] = $this->getEstimateValue($proposal_id);
        $sql = "SELECT * from acproposal WHERE id=$proposal_id";
        $data["acproposal"] = $this->db->query($sql)->row_array();

        $data["proposal_id"]=$proposal_id;
        $data['asb_financing'] = Array("1" => "N0", "2" => "Yes");
        $data['referral_job'] = Array("1" => "N0", "2" => "Yes");
        $data['states'] = array('' => "- Choose a state -");
        $arr_state = array_keys(array('AK' => "Alaska", 'AL' => "Alabama", 'AR' => "Arkansas", 'AZ' => "Arizona", 'CA' => "California", 'CO' => "Colorado", 'CT' => "Connecticut", 'DC' => "District Of Columbia", 'DE' => "Delaware", 'FL' => "Florida", 'GA' => "Georgia", 'HI' => "Hawaii", 'IA' => "Iowa", 'ID' => "Idaho", 'IL' => "Illinois", 'IN' => "Indiana", 'KS' => "Kansas", 'KY' => "Kentucky", 'LA' => "Louisiana", 'MA' => "Massachusetts", 'MD' => "Maryland", 'ME' => "Maine", 'MI' => "Michigan", 'MN' => "Minnesota", 'MO' => "Missouri", 'MS' => "Mississippi", 'MT' => "Montana", 'NC' => "North Carolina", 'ND' => "North Dakota", 'NE' => "Nebraska", 'NH' => "New Hampshire", 'NJ' => "New Jersey", 'NM' => "New Mexico", 'NV' => "Nevada", 'NY' => "New York", 'OH' => "Ohio", 'OK' => "Oklahoma", 'OR' => "Oregon", 'PA' => "Pennsylvania", 'RI' => "Rhode Island", 'SC' => "South Carolina", 'SD' => "South Dakota", 'TN' => "Tennessee", 'TX' => "Texas", 'UT' => "Utah", 'VA' => "Virginia", 'VT' => "Vermont", 'WA' => "Washington", 'WI' => "Wisconsin", 'WV' => "West Virginia", 'WY' => "Wyoming"));
        $data['states'] +=array_combine($arr_state, $arr_state);
        $this->load->view("acproposal/commission_form", $data);
    }

    function commission($proposal_id) {
        $this->load->helper('download');
        $data[] = array();
        $sql = "SELECT * from acproposal WHERE id=$proposal_id";
        $data["proposal"] = $this->db->query($sql)->row_array();
        $sql = "SELECT SUM(add_cost) as add_cost,SUM(discount) as discount,SUM(upcharge) as upcharge FROM acproposalzone WHERE acproposal_id = $proposal_id";
        $data["zone"] = $this->db->query($sql)->row_array();


        $data['job_install'] = "";
        if ($data['proposal']['is_schedule']) {
            $jobdate = $this->db->query("SELECT job_date,job_pid FROM jobs WHERE proposal_id=$proposal_id")->result_array();
            $date_array = array();
            foreach ($jobdate as $jobdata) {
                $date_array[] = date("F jS, Y", strtotime($jobdata['job_date']));
                $jobpid = $jobdata['job_pid'];
            }
            $data['job_install'] = implode(" , ", $date_array);
            $data['job_pid'] = $jobpid;
        }
        //$data['job_install']="";
        $data['salesman'] = $this->getUserIntial($data['proposal']['user_id'], true);
        $elite_user = $this->db->query("SELECT elite_agent,sale_support,sale_support_value from users where id=" . $data["proposal"]["user_id"])->row_array();
        $data["elite_agent"] = @$elite_user['elite_agent'];
        $data["sale_support"] = @$elite_user['sale_support'];
        $data["sale_support_value"] = @$elite_user['sale_support_value'];
        $data['asb_financing'] = Array("1" => "N0", "2" => "Yes");
        $data['referral_job'] = Array("1" => "N0", "2" => "Yes");

        $sql_commission = "SELECT sum(quantity) as sumcm FROM acvariable_job WHERE variable_id=40 AND proposal_id=$proposal_id  group by proposal_id";
        @$data['commission'] = $this->db->query($sql_commission)->row_array();

        
        @$data['financed_price']['sumfp'] = $this->getEstimateValue($proposal_id);

        $sql_financed_price = "SELECT sum(quantity) as sumcc FROM acvariable_job WHERE variable_id=59 AND proposal_id=$proposal_id  group by proposal_id";
        @$data['cash_collected'] = $this->db->query($sql_financed_price)->row_array();

        //$sql_commission = "SELECT sum(quantity) as sumcm FROM acvariable_job WHERE variable_id=40 AND proposal_id=$proposal_id  group by proposal_id";
        //@$variable_record=$this->db->query($sql_commission)->row_array();
// here we getting the commission price
        //$data['commission'] = @$variable_record["sumcm"];
        //$data['financed_price'] = @$variable_frecord['sumfp'];
        $data['cleaningcharge'] = 0;
        if (@$data["proposal"]["cleaning_contract"] == 1) {
            $sql_clean = "SELECT * FROM variable_job WHERE variable_id=76 AND proposal_id=$proposal_id ";
            @$variable_record_clean = $this->db->query($sql_clean)->row_array();
            $data['cleaningcharge'] = @$variable_record_clean["quantity"] * @$variable_record_clean["price"];
        }
        $html = $this->load->view("acproposal/commsion", $data, true);
       
        $t = rand(1, 99999);
        $fp = fopen(FCPATH . "pdftemp/commission$t-$proposal_id.html", "w+");
        fputs($fp, $html);
        fclose($fp);
        //$footer_html = $this->load->view("proposal/footerhtml",$data,true);
        //$footer_t = rand(1, 99999);
        //$footer_fp = fopen(FCPATH . "pdftemp/footer$footer_t-$proposal_id.html","w+");
        //fputs ($footer_fp, $footer_html);
        //fclose ($footer_fp);
        //$footerhtml =FCPATH . "pdftemp/footer$footer_t-$proposal_id.html";
        exec("/var/www/vhosts/aeihawaii.com/httpdocs/page/wkhtmltopdf-i386 -B 20 " . FCPATH . "pdftemp/commission$t-$proposal_id.html     " . FCPATH . "pdftemp/commission$t-$proposal_id.pdf ");
        $data_file = file_get_contents(FCPATH . "pdftemp/commission$t-$proposal_id.pdf"); // Read the file's contents
        @$name = "" . $data["proposal"]["last_name"] . "-" . $data["proposal"]["first_name"] . "-commission" . $proposal_id . ".pdf";
        force_download($name, $data_file);
    }

    function save_commission_form($proposal_id, $total_amount_collected, $asb_financing = 1, $referral_job = 1) {
        if (!$this->session->userdata('access') || !$proposal_id) {
            redirect("admin/error?e=permissions");
        }
        $row_commission = array();
        if ($referral_job == 1) {
            $row_commission['ag_first_name'] = '';
            $row_commission['ag_last_name'] = '';
            $row_commission['ag_street'] = '';
            $row_commission['ag_city'] = '';
            $row_commission['ag_state'] = '';
            $row_commission['ag_zip'] = '';
            $row_commission['w9'] = '';
        } else {
            $row_commission['ag_first_name'] = $this->input->post("ag_first_name");
            $row_commission['ag_last_name'] = $this->input->post("ag_last_name");
            $row_commission['ag_street'] = $this->input->post("ag_street");
            $row_commission['ag_city'] = $this->input->post("ag_city");
            $row_commission['ag_state'] = $this->input->post("ag_state");
            $row_commission['ag_zip'] = $this->input->post("ag_zip");
            $row_commission['w9'] = $this->input->post("w9");
        }
        $sql = "select id from commission_agent_information where proposal_id=$proposal_id";
        $row_aggent = $this->db->query($sql)->row_array();
        if (@$row_aggent['id'] > 0) {
            $this->db->where("id", $row_aggent['id']);
            $this->db->update("commission_agent_information", $row_commission);
        } else {
            $row_commission['proposal_id'] = $proposal_id;
            $this->db->insert("commission_agent_information", $row_commission);
        }
        $row = array();
        $row['referral_job'] = $referral_job;
        $row['asb_financing'] = $asb_financing;
        $row['total_amount_collected'] = $total_amount_collected;
        $this->db->where("id", $proposal_id);
        $this->db->update("acproposal", $row);
        $json = array();
        $json["success"] = true;
        echo json_encode($json);
        return;
    }

    function variable_add() {
        if (!$this->session->userdata('access')) {
            redirect("admin/error?e=permissions");
        }
        $data = array();
        $sql = "SELECT * from acvariable WHERE is_show=1 ORDER BY type ";
        $data['variable'] = $this->db->query($sql)->result_array();

        $sql = "SELECT distinct type from acvariable order by type";
        $data['var_type'] = $this->db->query($sql)->result_array();
        $select_box_array = array();
        //$select_box_array["-999"]="Please Select";
        $select_type = array();
        $select_type["-999"] = "Please Select";
        $brand_box_array = array();
        //$select_box_array["-999"]="Please Select";
        $brand_type = array();
        $brand_type["-999"] = "Please Select";
        foreach ($data['var_type'] as $datatype) {
            $select_type[$datatype['type']] = ucfirst($datatype['type']);
            $select_box_array[$datatype['type']][-9999] = "Select the Product";
            $select_box_array[$datatype['type']][9999] = "Add New";
            foreach ($data['variable'] as $datavarible) {
                if ($datavarible['type'] == $datatype['type'])
                    $select_box_array[$datavarible['type']][$datavarible['id']] = $datavarible['title'];
            }
            $temp_type = array();
            $temp_type = explode("_brands", $datatype['type']);

            if (count($temp_type) > 1) {
                $brand_type[$datatype['type']] = ucfirst($datatype['type']);
                $brand_box_array[$datatype['type']][-9999] = "Select the Brand";
                foreach ($data['variable'] as $datavarible) {
                    if ($datavarible['type'] == $datatype['type'])
                        $brand_box_array[$datavarible['type']][$datavarible['id']] = $datavarible['title'];
                }
            }
        }

        $data["select_array"] = $select_box_array;
        $data["select_type"] = $select_type;
        $data["brand_array"] = $brand_box_array;
        $data["brand_type"] = $brand_type;
        $data["aselect_type"] = $select_type;
        $data["aselect_array"] = $select_box_array;
        //print_R($data);
        // die;
        //
            $this->load->view("common/header");
        $this->load->view("acproposal/variable", $data);
        $this->load->view("common/footer");
    }

    function variable_submit() {
        $variable_id = $this->input->post("variable_id");
        $type = $this->input->post("type");
        $is_exist = $this->input->post($type);
        if ($type == "-999" || $type == "") {
            $json['success'] = false;
            $json['msg'] = "Please Select type";
            echo json_encode($json);
            return;
        }
        $row = array();
        $row['type'] = $type;
        if ($is_exist == "") {
            $json['success'] = false;
            $json['msg'] = "Please Select type";
            echo json_encode($json);
            return;
        }
        if ($is_exist == 9999) {
            $title = $this->input->post("title");
            $row['type'] = $type;
            $row['title'] = $title;
            $row['price'] = $this->input->post("price");
            $row['device_desc'] = $this->input->post("desc");
            $sql_mappingid = "SELECT max(select_id) as sid FROM  acvariable  WHERE type='$type'";
            $row_id = array();
            $row_id = $this->db->query($sql_mappingid)->row_array();
            if (count($row_id) > 0 && $row_id['sid']) {
                $row['select_id'] = $row_id['sid'] + 1;
            } else {
                $row['select_id'] = 1;
            }
            $this->db->insert("variable", $row);
            $is_new = true;
        } else {
            $title = $this->input->post("title");
            $row['title'] = $title;
            $row['price'] = $this->input->post("price");
            $row['device_desc'] = $this->input->post("desc");
            $this->db->where('id', $is_exist);
            $this->db->update("acvariable", $row);
        }
        $json['success'] = true;
        echo json_encode($json);
    }

    function geettileprice($productid) {
        if (!$productid) {
            $json['success'] = false;
            $json['msg'] = "Please Select type or product type";
            echo json_encode($json);
            return;
        }
        $sql = "SELECT price,title,device_desc,mapping_id from acvariable  WHERE id=$productid";
        $row['preloaded'] = $this->db->query($sql)->row_array();
        if ($row['preloaded']['mapping_id']) {
            $sqlm = "SELECT type,id from acvariable WHERE id=" . $row['prloaded']['mapping_id'];
            $row['mappingpreloaded'] = $this->db->query($sql)->row_array();
            $json['mtype'] = $row['mappingpreloaded']['type'];
            $json['product_id'] = $row['mappingpreloaded']['id'];
        }
        $json['price'] = $row['preloaded']['price'];
        $json['title'] = $row['preloaded']['title'];
        $json['desc'] = $row['preloaded']['device_desc'];
        $json['success'] = true;
        echo json_encode($json);
        return;
    }

    function saveproposal() {
        $json["success"] = false;
        if ($this->input->post('proposal_id') && $this->input->post('unittype')) {
            $row = array();
            $row['unittype'] = $this->input->post('unittype');

            $this->db->where("id", $this->input->post('proposal_id'));
            $this->db->update("acproposal", $row);
            $json = array();
            $json["success"] = true;
        }
        echo json_encode($json);
    }

    function getjobdate($proposal_id, $date = 0) {

        $sql_job = "SELECT id,job_date from jobs WHERE job_type_id=16 AND proposal_id=$proposal_id";
        $job_array = $this->db->query($sql_job)->result_array();
        if (!$date) {
            $jobdate = array();
            //$jobdate[]='';
            foreach ($job_array as $jobdata) {
                if (strtotime($jobdata['job_date']))
                    $jobdate[] = '<a href="' . base_url() . 'admin/job_comment/' . $jobdata['id'] . '">' . date("m/d/y", strtotime($jobdata['job_date'])) . '</a>';
                else
                    $jobdate[] = 'Unscheduled';
            }
            return implode(",", $jobdate);
        } else {
            if (strtotime(@$job_array[0]['job_date']))
                return @$job_array[0]['job_date'];
            else
                return 'Unscheduled';
        }
    }

    function getjobBookingdate($proposal_id) {
        $sql_job = "SELECT id,created from jobs WHERE job_type_id=16 AND proposal_id=$proposal_id";
        $job_array = $this->db->query($sql_job)->result_array();

        if (@$job_array[0]['created'] != "") {
            return @date("m/d/y", strtotime($job_array[0]['created']));
        } else {
            return "--";
        }
    }

    function getallsalesuser1($pjob_id, $user_id) {
        $sql = "SELECT * FROM users WHERE  type='sales'";
        $data['users'] = $this->db->query($sql)->result_array();
        $user_select = array();
        foreach ($data['users'] as $users) {
            $user_select[$users['id']] = ucfirst($users['first_name']) . " " . ucfirst($users['last_name']);
        }
        $data['pjob_id'] = $pjob_id;
        $data['user_id'] = $user_id;
        $data['saleuser'] = $user_select;
        $this->load->view("acproposal/salesuser", $data);
    }

    function getSalesUsers($pjob_id, $user_id) {
        $sql = "SELECT * FROM users WHERE  type='sales'";
        $data['users'] = $this->db->query($sql)->result_array();
        $user_select = array();
        foreach ($data['users'] as $users) {
            $user_select[$users['id']] = ucfirst($users['first_name']) . " " . ucfirst($users['last_name']);
        }
        $data['pjob_id'] = $pjob_id;
        $data['user_id'] = $user_id;
        $data['saleuser'] = $user_select;
        $this->load->view("acproposal/salesuser", $data);
    }

    function updateproposaluser($proposal_id, $uid) {
        $row = array();
        $row['user_id'] = $uid;
        $sql = "SELECT is_schedule FROM acproposal WHERE id = '" . $proposal_id . "'";
        $rs = $this->db->query($sql)->row_array();
        if ($rs['is_schedule'] == 0) {
            $this->db->where("id", $proposal_id);
            $this->db->update("acproposal", $row);
        } else {
            $sql = "SELECT id FROM jobs WHERE proposal_id = '" . $proposal_id . "' AND job_type_id = 16";
            $rs = $this->db->query($sql)->row_array();
            if ($rs['id'] != '') {
                $sql = "SELECT job_pid FROM jobs WHERE id = '" . $rs['id'] . "'";
                $res = $this->db->query($sql)->row_array();
                if ($res['job_pid'] != '') {
                    $sql = "SELECT id FROM jobs WHERE job_pid = '" . $res['job_pid'] . "'";
                    $rs = $this->db->query($sql)->result_array();
                    foreach ($rs as $val) {
                        $this->db->where("id", $val['id']);
                        $this->db->update("jobs", $row);
                        //Create activity log for update job
                        $this->load->library("activitylog");
                        //($activity_type ,$table_name, $job_id, $user_id, $customer_id)
                        $this->activitylog->createlog("Update", "jobs", $val['id'], $this->session->userdata("user_id"));
                    }
                }
                $this->db->where("id", $proposal_id);
                $this->db->update("acproposal", $row);
            }
        }
        $json['success'] = true;
        echo json_encode($json);
    }

    function updateSummaryPermit($value, $id) {
        $row['apply_permit_fee'] = $value;

        $this->db->where('id', $id);
        $this->db->update('acproposal', $row);
        $json['success'] = true;
        echo json_encode($json);
    }
    function getEstimateValue($id)
    {
        $sql="select sum(price) as price,sum(upcharge) as upcharge,sum(add_cost) as add_cost,sum(discount) as discount from acproposalzone where acproposal_id=$id group by acproposal_id ";
        $dVal=$this->db->query($sql)->result_array();
        $total=@$dVal[0]['price'] + @$dVal[0]['upcharge'] + @$dVal[0]['add_cost'] - @$dVal[0]['discount'] ;
        return $total;
    }
    function deleteproposalm($proposal_id,$url){
            $output = "<br/>&nbsp&nbsp;&nbsp;&nbsp;Are you sure to delete Proposal?<br/>&nbsp;&nbsp;&nbsp;<button class='yessave'>OK</button>&nbsp;<button class='cancel-facebox'>Cancel</button>";
            $output .= "<script>\$(document).ready(function() { \$('.yessave').click(function() { alert('Proposal has been deleted.'); location.href='".base_url()."acproposal/deleteproposal/$proposal_id/$url'}); });</script>";
            echo $output;
        }
        function deleteproposal($proposal_id,$url){
             $sql = "update acproposal set is_delete=1 WHERE id=".$proposal_id;

             $this->db->query($sql);
             //$sql_m = "DELETE FROM proposal_month WHERE proposal_id=".$proposal_id;
            // $this->db->query($sql_m);
             if($url!="0"){
               $url=base64_decode($url);
             }else{
                 $url="msg=1";
             }
             redirect("acproposal?$url");
        }

function makeProposalCopy($id){
        $this->db->trans_start();
        $sql = "SELECT * from acproposal WHERE id=$id";
        $data  = $this->db->query($sql)->row_array();        
        $data['proposal_pid']=$data['id'];       
        $data = array_slice($data, 1);        
        $this->db->insert('acproposal',$data);
        $pid=$this->db->insert_id(); 
        $data1= $this->getZonealoneList($id);
        foreach ($data1 as $key => $val)
        {
         $data1["$key"]['acproposal_id']=$pid;  
         $data1["$key"] = array_slice($data1["$key"], 1);
         $this->db->insert('acproposalzone',$data1["$key"]); 
        }   
        $this->db->trans_complete();
        
        if ($this->db->trans_status() === FALSE)
        {
           $json['success']=false;
        echo json_encode($json);
        }         
        else 
        {
        $json['success']=true;
        echo json_encode($json);
        }
    }

	function getProductValue($id){
        $sql="select reccomended_unit_1,additional_unit_1 from acproposalzone where acproposal_id=$id ";
        $vals=$this->db->query($sql)->result_array();       
        foreach ($vals as $val){
            $reccomended_unit_1=$val['reccomended_unit_1'];
            if($reccomended_unit_1!='')
            $data[]=$this->getProductValueId(@$reccomended_unit_1);
            $additional_unit_1=$val['additional_unit_1'];
            if($additional_unit_1!='')
            $data[]=$this->getProductValueId(@$additional_unit_1);
        }
      //print_r($data);
       return @$data;
        
    }
	
	function getProductValueId($val=FALSE){
        $unit=array('09'=>'MSY-GE09NA-8','12'=>'MSY-GE12NA-8','15'=>'MSY-GE15NA-8','36'=>'MSY-D36NA-8','18'=>'MSY-GE18NA-8','30'=>'MSY-D30NA-8','24'=>'MSY-GE24NA');
        foreach ($unit as $key => $unit)
        {
            if($unit==$val)
            {
                return $key;
            }
        }
        return;
    }

}
?>

