<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
 * -------------------------------------------------------------------------
 * Smarty Thumbnail config
 * -------------------------------------------------------------------------
 * This file allows you to configure folders for temp files used with thumbnail
 */
/* Base folder used to find image files, will be prepended to the image src */
$config['thumbnail_base_folder'] = $_SERVER['DOCUMENT_ROOT']."/scheduler/uploads/";

/* How to save cached files
 *  same_path: Save in the same folder, with dimention added at the end of the file name.
 *  subfolder: Save in a sub folder of the original file's folder
 *  folder: Save in the cache folder, each file must have an unique name, or you'll have.
 *  folder_md5: Save in the cache folder, with name that is an md5 of the image path
 */
$config['thumbnail_cache_type'] = 'subfolder';

# CONFIG used for 'same_path' and 'subfolder' mode #
/* The url path corresponding to the folder, can be any valid http directory */
$config['thumbnail_base_url'] = site_url().'uploads';

# CONFIG used for 'subfolder' mode #
/* The url path corresponding to the folder, can be any valid http directory */
$config['thumbnail_subfolder_name'] = 'thumbnails';

# CONFIG used for 'folder' and 'folder_md5' #
/* The cache folder where resized images will be saved, must be accessible from the web */
$config['thumbnail_cache_folder'] = APPPATH."/thumbnails/";

/* The url path corresponding to the cache folder */
$config['thumbnail_cache_url'] = site_url()."uplaods/thumbnails/";

/* Set to true to force recaching each time */
$config['thumbnail_disable_caching'] = false;
?>
