<!--
View "Service Calls"

- Ability to view all scheduled Service Calls for the day
- Ability to add a new service call or edit any existing service calls

- width of all overlays should be the same, although its not necessary to keep it the same width in the mockups
-->

<!--
Job Detail Page - Add New Job Note 1
-->

<div class="view-job-notes">
	<div class="header">
		<div class="title">Service Calls for <span class="underline"><?=strtoupper(date("M",$calendar_date))?> <?=date("j",$calendar_date)?>, <?=date("Y",$calendar_date)?></span></div>
		<div class="close-button"><a href="#">&times;</a></div>
		<div class="clear-both"></div>
	</div>
	<div class="info">
		
		<div style="height:300px; width:380px; overflow:scroll;">
			<?php foreach ($service_calls as $key => $value): ?>
			<div class="ajax-service-call">
				<button class="edit-service-call" onclick="location.href='<?=base_url()?>admin/service_call/<?=$value['id']?>';">EDIT</button>
				<strong><?=substr($value['first_name'],0,1)?>. <?=$value['last_name']?>, <!--10:00am--></strong>, <?=character_limiter($value['description'],15)?><br />
				<span><?=$value['address']?>, <?=$value['city']?></span>
			</div>
			<?php endforeach ?>
			<?php if (count($service_calls) == 0): ?>
			<div style="height:300px; line-height:300px; text-align:center; background:#efefef;">
				no service calls scheduled
			</div>
			<?php endif ?>
		</div>
		<br />
		<div style="float:left;">
			<button class="cancel-facebox">Cancel</button>
		</div>
		<div style="float:right;">
			<div align="right">
				<button onclick="location.href='<?=base_url()?>admin/day/<?=date("Y",$calendar_date)?>/<?=date("m",$calendar_date)?>/<?=date("d",$calendar_date)?>'">Day View</button>
				<button onclick="$.get('<?=base_url()?>ajax/reserve_job/<?=date("Y",$calendar_date)?>/<?=date("m",$calendar_date)?>/<?=date("d",$calendar_date)?>?preselect=service_call', function(d) { $.facebox(d); })">Reserve a New Service Call</button>
			</div>
		</div>
		<div class="clear-both"></div>
	</div>
</div>