# Design Sheet PDF Text Readability Fix

**Date:** January 15, 2026
**Issue:** Gray text in Design Sheet PDFs was difficult to read when printed

## Problem Description

When users created new Design Sheets for PV Systems and AC (SAF) Systems via the "Create New Design Sheet" button, the generated PDFs contained light gray text that was difficult to read when printed. This affected:

- Field labels (Customer Name:, Street Address:, City:, etc.)
- Field values (the actual customer data)
- Section headings
- Table content

## Root Cause

The PDF templates used:
1. **Gray color codes** (`#404040`, `#404041`, `#231f20`) instead of black (`#000000`)
2. **Ultra-light font weights** (`font-weight: 100`, `200`, `300`, `lighter`) which rendered text very thin and hard to read

## Files Modified

### 1. Main CSS File
**File:** `assets/propdf/css/style.css`

**Changes:** Changed all gray text colors to black (`#000000`)

| Selector | Original Color | New Color |
|----------|---------------|-----------|
| `body` | `#404041` | `#000000` |
| `.borB` border | `#404041` | `#000000` |
| `.header h1 span` | `#404040` | `#000000` |
| `.header h2 span` | `#404040` | `#000000` |
| `.section .heading` | `#404040` | `#000000` |
| `.section .heading` border | `#404041` | `#000000` |
| `table.detsils td` | `#231f20` | `#000000` |
| `table.detsils2 td` | `#404040` | `#000000` |
| `table.detsils3 td` | `#404040` | `#000000` |
| `table.detsils3-inner td` | `#404040` | `#000000` |
| `table.detsils3 .whiteBG td` | `#404040` | `#000000` |
| `table.notes td` | `#404040` | `#000000` |
| `table.notes td` border | `#404041` | `#000000` |

### 2. PV System Design Sheet Template
**File:** `system/application/views/proposalpdf/index.php`

**Changes (inline styles):**

| Class | Original | New |
|-------|----------|-----|
| `.idtStyle` | `font-weight:100` | `font-weight:bold; color:#000000` |
| `.idtStyleInput` | `font-weight:300` | `font-weight:normal; color:#000000` |
| `.ssStyle` | `font-weight:lighter` | `font-weight:bold; color:#000000` |
| `.ssStyleInput` | `font-weight:300` | `font-weight:normal; color:#000000` |
| `table.detsils2 td` | `font-weight:100` | `font-weight:normal; color:#000000` |
| `.header h1 span` | `font-weight:200` | `font-weight:normal; color:#000000` |
| `table.detsils3-inner td` | `font-weight:300` | `font-weight:normal; color:#000000` |
| `td.greenCon` | `font-weight:100` | `font-weight:bold` |

### 3. SAF (AC) System Design Sheet Template
**File:** `system/application/views/safpdf/index.php`

**Changes:** Same as PV template above

## Testing

To verify the fix:
1. Navigate to a job in the scheduler
2. Click "Create New Design Sheet" button
3. Download the generated PDF
4. Verify that all text is now black and readable
5. Print the PDF and confirm text is clearly visible

## Affected URLs

- `http://aeihawaii.com/scheduler/admin/createnewdesignpdf/{job_id}`

## Technical Notes

- The templates use `wkhtmltopdf` for PDF generation
- Both templates share the same CSS file (`assets/propdf/css/style.css`)
- Font-weight values: 100-300 are very light; 400 is normal; 700 is bold
- The green highlight sections (`greenCon` class) retain their green background but now have bold white text for better contrast
