# CLI Feature Testing Plan

## Overview
Comprehensive testing of all RDF CLI features.

**Environment:** Linux (WSL2)

---

## Phase 1: Environment & CLI Verification

### 1.1 Python Environment
- [ ] Python version check (3.10+)
- [ ] Required packages installed
- [ ] NLTK data available

### 1.2 Database Connection
- [ ] PostgreSQL connection
- [ ] pgvector extension
- [ ] Required tables exist

### 1.3 RDF CLI Setup
- [ ] `rdf` script is executable
- [ ] `./rdf --help` works
- [ ] `./rdf commands` returns JSON

---

## Phase 2: Document Ingestion

### 2.1 Basic Ingestion
```bash
./rdf ingest NEW_DOCS/
./rdf ingest document.pdf
./rdf ingest NEW_DOCS/ --force
./rdf ingest NEW_DOCS/ --format json
```

### Tests
- [ ] Ingest single PDF document
- [ ] Ingest multiple documents from directory
- [ ] Force re-processing works (`--force`)
- [ ] JSON output format works (`--format json`)

### 2.2 OCR Options
```bash
./rdf ingest old_scan.pdf --ocr-profile standard
```

- [ ] OCR profile option works

---

## Phase 3: Search & Retrieval

### 3.1 Search Commands
```bash
./rdf search "query" --limit 10
./rdf search "query" --mode semantic
./rdf search "query" --mode hybrid
./rdf search "query" --summary
./rdf search "query" --format json
```

### Tests
- [ ] Basic keyword search
- [ ] Semantic search mode
- [ ] Hybrid search mode
- [ ] Summary output (token-efficient)
- [ ] JSON output format

### 3.2 Fetch Command
```bash
./rdf fetch chunk_id
./rdf fetch chunk_id --max-chars 2000
./rdf fetch result_id --from-search
./rdf fetch chunk_id --format json
```

### Tests
- [ ] Fetch chunk by ID
- [ ] Max chars limit works
- [ ] From-search option works
- [ ] JSON output format

---

## Phase 4: Research Commands

### 4.1 Research Agent
```bash
./rdf research "question" --strict
./rdf research "question" --allow-web
./rdf research "question" --max-iterations 5
./rdf research "question" -o report.md
./rdf research "question" --format json
```

### Tests
- [ ] Basic research (library only)
- [ ] Max iterations limit
- [ ] Output to file
- [ ] JSON output format

### 4.2 Quote Extraction
```bash
./rdf quotes "topic" --max 30
./rdf quotes "topic" --min-length 100
./rdf quotes "topic" --format json
```

### Tests
- [ ] Quote extraction works
- [ ] Max quotes limit
- [ ] Minimum length filter
- [ ] JSON output format

---

## Phase 5: Writing Workflows

### 5.1 Essay Command
```bash
./rdf essay "topic" --pages 10
./rdf essay "topic" --pages 15 --style academic
./rdf essay "topic" --evidence-first
./rdf essay "topic" --autonomy full
./rdf essay "topic" --format json
```

### Tests
- [ ] Basic essay generation
- [ ] Page count option
- [ ] Style presets
- [ ] Evidence-first mode
- [ ] Autonomy levels

### 5.2 Outline Command
```bash
./rdf outline "topic" --chapters 5 --pages 100
./rdf outline "topic" --chapters 3 --style academic
./rdf outline "topic" --preview
./rdf outline "topic" --format json
```

### Tests
- [ ] Outline generation
- [ ] Chapter count option
- [ ] Page target option
- [ ] Preview mode
- [ ] JSON output format

### 5.3 Book Command
```bash
./rdf book book_projects/BOOK_xxx/outline.yaml
./rdf book outline.yaml --autonomy full
./rdf book outline.yaml --autonomy supervised
./rdf book --resume BOOK_xxx --phases 5
./rdf book outline.yaml --plan
./rdf book outline.yaml --format json
```

### Tests
- [ ] Book compilation works
- [ ] Autonomy levels work
- [ ] Resume capability
- [ ] Plan preview
- [ ] JSON output format

### 5.4 Write Command (Universal)
```bash
./rdf write "topic" --pages 20
./rdf write "topic" --chapters 5
./rdf write "topic" --type essay
./rdf write "topic" --type book --chapters 3
```

### Tests
- [ ] Infers essay mode (no chapters)
- [ ] Infers book mode (with chapters)
- [ ] Explicit type override

---

## Phase 6: Validation & Polish

### 6.1 Validate Command
```bash
./rdf validate chapter.md
./rdf validate chapter.md --top-k 5
./rdf validate chapter.md --format json
```

### Tests
- [ ] Validation runs
- [ ] Top-k sources option
- [ ] JSON output format

### 6.2 Polish Command
```bash
./rdf polish chapter.md --preset academic
./rdf polish chapter.md --preset accessible
./rdf polish chapter.md --reference-style sample.txt
./rdf polish chapter.md --format json
```

### Tests
- [ ] Polish with preset
- [ ] Reference style option
- [ ] JSON output format

---

## Phase 7: Queue Management

### 7.1 Queue Commands
```bash
./rdf queue list
./rdf queue list validation
./rdf queue list gap
./rdf queue approve item_id
./rdf queue reject item_id --reason hallucination
./rdf queue stats
./rdf queue list --format json
```

### Tests
- [ ] List all queues
- [ ] List specific queue type
- [ ] Approve item
- [ ] Reject item with reason
- [ ] Queue statistics
- [ ] JSON output format

---

## Phase 8: Utility Commands

### 8.1 Status Command
```bash
./rdf status
./rdf status --last BOOK_xxx
./rdf status --type book
./rdf status --format json
```

### Tests
- [ ] Show all workflows
- [ ] Filter by ID
- [ ] Filter by type
- [ ] JSON output format

### 8.2 Health Command
```bash
./rdf health
./rdf health --format json
```

### Tests
- [ ] Health scan runs
- [ ] JSON output format

### 8.3 Assess Command
```bash
./rdf assess DOC_xxx
./rdf assess DOC_xxx --format json
```

### Tests
- [ ] Document assessment works
- [ ] Returns OCR quality, language, page count
- [ ] JSON output format

### 8.4 Diff Command
```bash
./rdf diff file_a file_b
./rdf diff file_a file_b --format json
./rdf diff file_a file_b --format unified
```

### Tests
- [ ] Unified diff output
- [ ] JSON diff output

### 8.5 Edit Metadata Command
```bash
./rdf edit-meta DOC_xxx --title "New Title"
./rdf edit-meta DOC_xxx --author "Author Name"
```

### Tests
- [ ] Edit title
- [ ] Edit author

### 8.6 Graph Query Command
```bash
./rdf graph query "concept"
./rdf graph query "concept" --format json
```

### Tests
- [ ] Graph query works
- [ ] JSON output format

---

## Phase 9: JSON Output Contract

### 9.1 Success Response
All commands with `--format json` should return:
```json
{
  "status": "success",
  "code": "SUCCESS",
  "message": "...",
  "data": {}
}
```

### 9.2 Error Response
Errors should return:
```json
{
  "status": "error",
  "code": "ERROR_CODE",
  "message": "...",
  "actionable_advice": "..."
}
```

### 9.3 Pause Response
Supervised workflows should return:
```json
{
  "status": "success",
  "code": "PAUSED_FOR_REVIEW",
  "message": "...",
  "data": {
    "checkpoint": "...",
    "resume_token": "..."
  }
}
```

### Tests
- [ ] Success responses have correct structure
- [ ] Error responses have correct structure
- [ ] Pause responses have correct structure

---

## Test Results Summary

| Phase | Tests | Passed | Failed | Notes |
|-------|-------|--------|--------|-------|
| 1     |       |        |        |       |
| 2     |       |        |        |       |
| 3     |       |        |        |       |
| 4     |       |        |        |       |
| 5     |       |        |        |       |
| 6     |       |        |        |       |
| 7     |       |        |        |       |
| 8     |       |        |        |       |
| 9     |       |        |        |       |

---

## Issues Found

(To be populated during testing)

---

## Recommendations

(To be populated after testing)
