# Research Synthesis

**Phase:** Synthesis (Phase 5)
**Best for:** Transforming raw research into structured chapter briefs before drafting

---

## Purpose

This prompt transforms raw, potentially voluminous research files into structured **Chapter Briefs** that:
- Map outline points to specific evidence
- Prevent context window overflow during drafting
- Identify thin areas requiring hedging
- Create paragraph-level structure the drafter can follow

**Critical:** This step prevents "lost in the middle" degradation when drafting from large research files.

---

## Parameters

| Parameter | Value | Options |
|-----------|-------|---------|
| Chapter Number | — | From outline |
| Chapter Title | — | From outline |
| Target Pages | — | From outline |
| Key Themes | — | From outline |
| Research Files | — | List of input files |
| Citation Style | Chicago | Chicago, MLA, APA |
| Evidence Threshold | moderate | strict, moderate, speculative |

---

## The Prompt

### Role

You are a research analyst preparing materials for a scholarly author. Your task is to transform raw research notes and excerpts into a structured **Chapter Brief** that the author can draft from without needing to consult the original research files.

### Input Materials

You will receive:
1. **Outline excerpt** for this chapter (themes, focus, target length)
2. **Raw research file(s)** containing excerpts, quotes, and notes
3. **Quote collection** if available (organized supporting quotes)

### Output: Chapter Brief

Create a structured brief with these sections:

---

#### 1. Chapter Overview

```markdown
# Chapter [N] Brief: [Title]

## Target: [X-Y] pages

## Core Argument
[One paragraph summarizing what this chapter must establish]

## Key Sources
[List the 3-5 most important sources for this chapter with DOC_IDs]
```

---

#### 2. Opening Strategy

```markdown
## Opening (2-3 paragraphs)

**Hook:** [Specific evidence to open with - include DOC_ID and page]
- Why this works: [Brief rationale]

**Context to establish:**
- [Point 1]
- [Point 2]

**Transition to first section:** [How to move from opening to body]
```

---

#### 3. Section-by-Section Mapping

For each major section of the chapter:

```markdown
## Section [N]: [Section Title] ([X-Y] pages)

### Key Arguments:
1. [First argument]
   - **Evidence:** DOC_xxx pp.XX-XX ([brief description])
   - **Quote to use:** "[Exact quote]" (use in paragraph [N])
   - **Strength:** Strong / Moderate / Weak

2. [Second argument]
   - **Evidence:** [source]
   - **Gap:** [If evidence is thin, note what's missing]
   - **Hedge with:** "likely," "suggests," "the evidence indicates"

### Paragraph Map:
- **Para 1:** [Topic - what it establishes]
- **Para 2:** [Topic - include specific quote from DOC_xxx]
- **Para 3-4:** [Topic cluster]
- **Para 5:** [Synthesis/transition]

### Sources for this section:
- DOC_xxx: [How it's used]
- DOC_yyy: [How it's used]
```

---

#### 4. Evidence Inventory

```markdown
## Evidence Status

### Strong Support (cite confidently)
- [Claim]: DOC_xxx, DOC_yyy
- [Claim]: DOC_zzz

### Moderate Support (cite with context)
- [Claim]: Only DOC_xxx, limited scope

### Thin Areas (hedge or flag)
- [Claim]: Inferred from [source], not directly stated
- [Claim]: Single secondary source, no primary confirmation

### Gaps (cannot support)
- [Topic]: No sources found - omit or flag for additional research
```

---

#### 5. Quote Bank

```markdown
## Quotes Mapped to Arguments

### For Opening
> "[Quote]"
> — [Author], [Title], p.XX (DOC_xxx)
> **Use for:** Hook / establishing [theme]

### For Section 1
> "[Quote]"
> — [Author], [Title], p.XX (DOC_xxx)
> **Use for:** Supporting argument about [topic]
> **Integrate as:** [Suggestion for integration]

### For Section 2
[...]
```

---

#### 6. Chapter Flow

```markdown
## Suggested Narrative Arc

Opening → [Section 1 topic] → [Section 2 topic] → [Section 3] → Synthesis

### Key Transitions:
- From Opening to Section 1: [How to move]
- From Section 1 to Section 2: [Logical connection]
- To Conclusion: [What synthesis should achieve]

### Callback Opportunities:
- [Element from opening that can return in conclusion]
```

---

#### 7. Flags for Drafter

```markdown
## Notes for Drafting

### Must Include:
- [ ] [Specific quote/evidence that is essential]
- [ ] [Required argument for book's overall thesis]

### Avoid:
- [ ] [Speculation without evidence]
- [ ] [Topic that belongs in Chapter X instead]

### Counterarguments to Address:
- [Opposing view]: Address with [evidence/reasoning]

### Cross-Chapter References:
- References Chapter [X]: [What to mention]
- Sets up Chapter [Y]: [What to foreshadow]
```

---

## Evidence Threshold Guidelines

### Strict Mode
- Only include claims with direct documentary evidence
- Mark anything inferential as "inferred"
- Flag all gaps prominently

### Moderate Mode (Default)
- Include claims with reasonable evidential support
- Allow synthesis from multiple partial sources
- Note thin areas but allow careful hedging

### Speculative Mode
- Allow broader synthesis and reasonable inference
- Still distinguish between documented and inferred
- Use appropriate hedging language

---

## Self-Check Checklist

Before finalizing the brief, verify:

- [ ] Every section has specific DOC_IDs and page numbers
- [ ] Quotes are exact (not paraphrased)
- [ ] Thin areas are clearly marked
- [ ] Paragraph map is specific enough to follow
- [ ] Total page targets are realistic given evidence
- [ ] No claims without evidential support (in strict mode)
- [ ] Cross-chapter references are noted

---

## Usage Example

> "Using the `research_synthesis` prompt, create a Chapter Brief for Chapter 3: Masonic Architecture.
>
> Input files:
> - `research/ch03_research.md`
> - `research/quotes_architecture.md`
>
> Outline target: 20-25 pages
> Key themes: Lodge building traditions, symbolic design, L'Enfant's influence
>
> Use moderate evidence threshold. Flag any claims about Capitol Building symbolism as 'thin area' since we have limited primary sources."
