# Synthesis Prompts

Prompts for transforming raw research into structured documents ready for drafting.

## Purpose

Synthesis is the critical bridge between **research** (potentially 50+ pages of raw excerpts) and **drafting** (focused writing from a clear plan). Without synthesis, drafting suffers from:

- Context window overflow
- "Lost in the middle" degradation
- Inconsistent evidence usage
- Missing citations

## Available Prompts

| Prompt | Purpose | Output |
|--------|---------|--------|
| `research_synthesis` | Transform raw research into chapter brief | Structured brief with evidence mapping |

## Workflow Position

```
Phase 3: Research Assembly
         ↓
    [Raw research files: 50+ pages each]
         ↓
Phase 5: SYNTHESIS  ← You are here
         ↓
    [Chapter Briefs: ~5 pages each, structured]
         ↓
Phase 6: Drafting
```

## Key Concept: The Chapter Brief

A Chapter Brief is NOT:
- A summary of the research
- An outline of the chapter
- A list of sources

A Chapter Brief IS:
- A **map** from outline points to specific evidence
- A **paragraph-level structure** with assigned quotes
- An **evidence inventory** marking strong, moderate, and thin areas
- A **drafting guide** the LLM can follow without consulting raw research

## Usage

**Tell Claude:**

> "Create a Chapter Brief for Chapter [N] using the `research_synthesis` prompt.
>
> Input: `research/ch0N_research.md`
> Evidence threshold: moderate
> Target pages: [from outline]"

## See Also

- [Writing Project Workflow](../../docs/WRITING_PROJECT_WORKFLOW.md) - Phase 5 details
- [Drafting Prompts](../drafting/) - Use briefs for drafting
