# Review Prompts

Prompts for comprehensive editorial review at the manuscript level.

## Purpose

Review prompts operate on the **complete manuscript**, catching issues invisible at the chapter level:

- Cross-chapter consistency
- Citation integrity across the work
- Narrative arc and pacing
- Terminology standardization

## Available Prompts

| Prompt | Purpose | When to Use |
|--------|---------|-------------|
| `book_editor_review` | Comprehensive pre-production review | Phase 9, before final export |

## Workflow Position

```
Phase 8: Polish
         ↓
    [All chapters polished]
         ↓
Phase 9: Compilation
         ↓
    [Manuscript assembled]
         ↓
    REVIEW  ← You are here
         ↓
    [Final corrections]
         ↓
    Export
```

## Difference from Revision

| Revision (Phase 7) | Review (Phase 9) |
|--------------------|------------------|
| Single chapter at a time | Whole manuscript |
| Focus on prose quality | Focus on consistency |
| Improves writing | Catches errors |
| Creates `revised/` files | Creates issue report |

## Usage

**Tell Claude:**

> "Perform final editorial review using the `book_editor_review` prompt.
>
> Review depth: thorough
> Focus: all areas
> Pay attention to the scratchpad issues about date consistency."

## Output

The review produces an **Editorial Review Report** containing:
- Critical issues (must fix)
- Important issues (should fix)
- Minor issues (consider fixing)
- Suggestions (optional improvements)

## See Also

- [Writing Project Workflow](../../docs/WRITING_PROJECT_WORKFLOW.md) - Phase 9 details
- [Cohesion Check](../polish/cohesion_check.md) - Cross-chapter consistency (pre-review)
