# Academic Essay

**Phase:** Drafting
**Best for:** Structured academic essays with clear thesis and argument

---

## Parameters

Edit these values for your project:

| Parameter | Value | Options |
|-----------|-------|---------|
| Essay Title | — | Your essay title |
| Target Length | medium | short (5-10 pp), medium (10-20), long (20-30) |
| Style | academic | academic, analytical, argumentative |
| Audience | academic | academic, educated general, specialist |
| Tone | formal | formal, semi-formal, accessible |
| Thesis Statement | — | Your central argument |
| Citation Style | Chicago | Chicago, MLA, APA, Harvard |
| Include Abstract | no | yes, no |
| Argument Structure | classical | classical, rogerian, toulmin |

---

## The Prompt

### Role

You are writing an academic essay that presents a clear thesis and supports it with evidence and analysis.

### Structure Options

**Classical Argument** (default):
1. **Introduction** — Hook, context, thesis statement
2. **Background** — Necessary context and definitions
3. **Argument** — Main claims with evidence
4. **Counterargument** — Acknowledge and refute opposing views
5. **Conclusion** — Synthesis and implications

**Rogerian Argument** (for contentious topics):
1. **Introduction** — Present the issue neutrally
2. **Opposing View** — Fairly represent the other side
3. **Common Ground** — Identify shared values/goals
4. **Your Position** — Present your argument
5. **Compromise** — Offer synthesis or middle ground

**Toulmin Argument** (for complex claims):
1. **Claim** — Your thesis
2. **Grounds** — Evidence supporting the claim
3. **Warrant** — Connection between evidence and claim
4. **Backing** — Support for the warrant
5. **Qualifier** — Limitations and conditions
6. **Rebuttal** — Address counterarguments

---

### Style Guidelines

#### Opening

- Begin with a compelling hook that establishes relevance
- Provide necessary context without excessive background
- State thesis clearly, typically at end of introduction
- **Do NOT** begin with dictionary definitions or broad generalizations

#### Body Paragraphs

- Each paragraph should advance ONE main point
- Begin with clear topic sentences
- Support claims with specific evidence
- Analyze evidence—don't just present it
- Use transitions that show logical relationships

#### Evidence Integration

- Introduce sources with context ("According to historian X...")
- Quote sparingly—paraphrase when possible
- Always analyze after quoting ("This demonstrates...")
- Cite all sources appropriately

#### Voice

- Maintain formal academic tone
- Avoid first person unless discipline permits
- Be assertive but not overreaching
- Hedge appropriately ("suggests," "indicates," "may")

#### Conclusion

- Restate thesis in fresh language
- Synthesize main points (don't just summarize)
- Address broader implications
- End with resonant final thought

---

## Fill In For Your Essay

**Central Question:**
> [What question is this essay answering?]

**Thesis Statement:**
> [Your central argument in 1-2 sentences]

**Key Arguments:**
1. [First main point]
2. [Second main point]
3. [Third main point]

**Counterarguments to Address:**
- [Opposing view 1]
- [Opposing view 2]

**Key Sources:**
- [Source 1]
- [Source 2]

---

## Self-Edit Checklist

After writing, verify:

- [ ] Is the thesis clear and arguable?
- [ ] Does each paragraph have a clear topic sentence?
- [ ] Is evidence analyzed, not just presented?
- [ ] Are counterarguments fairly addressed?
- [ ] Are transitions logical and clear?
- [ ] Does the conclusion offer synthesis, not just summary?
- [ ] Are all sources properly cited?

---

## Usage Example

> "Use the `essay_academic` prompt to write my essay on 'The Influence of Masonic Ritual on Early American Political Symbolism.' Thesis: Early American founders deliberately incorporated Masonic symbolic language into national iconography. Use classical argument structure."
