# Writing Prompts Library

A comprehensive collection of writing prompts organized by workflow phase. These prompts bridge the gap between CLI tooling (data, search, citations) and LLM generation (synthesis, drafting, editing).

---

## How to Use

### Quick Start

1. **Browse** the folders to find a prompt that fits your phase
2. **Customize** parameters for your project
3. **Tell Claude** which prompt to use:
   - "Create a Chapter Brief using the `research_synthesis` prompt"
   - "Draft chapter 3 using the `scholarly_narrative` prompt"
   - "Revise using `history_editor`, focusing on transitions"
   - "Run final review using `book_editor_review`"

---

## Workflow Overview

```
┌─────────────────────────────────────────────────────────────────────────┐
│                         PROMPT WORKFLOW                                  │
├─────────────────────────────────────────────────────────────────────────┤
│                                                                          │
│  [Raw Research]                                                          │
│       │                                                                  │
│       ▼                                                                  │
│  ┌─────────────────┐                                                     │
│  │   SYNTHESIS     │  ← research_synthesis                               │
│  │  (Phase 5)      │    Creates Chapter Briefs from raw research         │
│  └────────┬────────┘                                                     │
│           │                                                              │
│           ▼                                                              │
│  ┌─────────────────┐                                                     │
│  │    DRAFTING     │  ← scholarly_narrative, living_thought, essay       │
│  │  (Phase 6)      │    Creates initial chapter drafts from briefs       │
│  └────────┬────────┘                                                     │
│           │                                                              │
│           ▼                                                              │
│  ┌─────────────────┐                                                     │
│  │    REVISION     │  ← history_editor, general_editor                   │
│  │  (Phase 7)      │    Edits drafts for clarity, flow, accuracy         │
│  └────────┬────────┘                                                     │
│           │                                                              │
│           ▼                                                              │
│  ┌─────────────────┐                                                     │
│  │     POLISH      │  ← micro_enrichment, cohesion_check                 │
│  │  (Phase 8)      │    Final refinement, cross-chapter consistency      │
│  └────────┬────────┘                                                     │
│           │                                                              │
│           ▼                                                              │
│  ┌─────────────────┐                                                     │
│  │     REVIEW      │  ← book_editor_review                               │
│  │  (Phase 9)      │    Comprehensive pre-publication check              │
│  └─────────────────┘                                                     │
│                                                                          │
└─────────────────────────────────────────────────────────────────────────┘
```

---

## Folder Structure

```
prompts/
├── synthesis/         ← Transform raw research into structured briefs
│   └── research_synthesis.md
│
├── drafting/          ← Create initial content from briefs
│   ├── scholarly_narrative.md
│   ├── living_thought.md
│   └── essay_academic.md
│
├── revision/          ← Edit completed drafts
│   ├── history_editor.md
│   └── general_editor.md
│
├── polish/            ← Final refinement
│   ├── micro_enrichment.md
│   └── cohesion_check.md
│
├── review/            ← Manuscript-level editorial review
│   └── book_editor_review.md
│
├── templates/         ← Create your own prompts
│   └── prompt_template.md
│
└── AGENT_WORKFLOW.md  ← Technical guide for Claude Code
```

---

## Prompts by Phase

### Phase 5: Synthesis

**Purpose:** Transform raw research into structured Chapter Briefs

**Why this matters:** Raw research files (50+ pages) cause context overflow and "lost in the middle" degradation. Synthesis creates a structured map (~5 pages) that the drafter can follow.

| Prompt | Input | Output |
|--------|-------|--------|
| [research_synthesis](synthesis/research_synthesis.md) | Raw research files | Chapter Brief with evidence mapping |

**Tell Claude:**
> "Create a Chapter Brief for Chapter 3 using the `research_synthesis` prompt. Input: `research/ch03_research.md`. Evidence threshold: moderate."

---

### Phase 6: Drafting

**Purpose:** Create initial chapter content from Chapter Briefs

| Prompt | Best For | Style |
|--------|----------|-------|
| [scholarly_narrative](drafting/scholarly_narrative.md) | Historical, research-driven | Erudite, evidence-anchored |
| [living_thought](drafting/living_thought.md) | Philosophical, esoteric | Contemplative, organic |
| [essay_academic](drafting/essay_academic.md) | Structured academic essays | Thesis-driven, formal |

**Tell Claude:**
> "Draft Chapter 3 using the `scholarly_narrative` prompt. Input: the Chapter Brief in `briefs/ch03_brief.md`. Target: 25-30 pages. Include Chicago footnotes."

---

### Phase 7: Revision

**Purpose:** Edit completed drafts for clarity, flow, and accuracy

| Prompt | Best For | Focus |
|--------|----------|-------|
| [history_editor](revision/history_editor.md) | Historical narrative | Flow, footnotes, transitions |
| [general_editor](revision/general_editor.md) | General nonfiction | Structure, argument, clarity |

**Tell Claude:**
> "Revise Chapter 3 using the `history_editor` prompt. Preserve all citations. Check scratchpad for cross-chapter issues."

---

### Phase 8: Polish

**Purpose:** Final refinement of near-complete chapters

| Prompt | Best For | Scope |
|--------|----------|-------|
| [micro_enrichment](polish/micro_enrichment.md) | Individual chapters | Subtle stylistic enhancement |
| [cohesion_check](polish/cohesion_check.md) | Complete manuscript | Cross-chapter consistency |

**Tell Claude:**
> "Polish Chapter 3 using `micro_enrichment`. Max 2 changes per paragraph. Preserve voice."

---

### Phase 9: Review

**Purpose:** Comprehensive editorial review before publication

| Prompt | Best For | Output |
|--------|----------|--------|
| [book_editor_review](review/book_editor_review.md) | Complete manuscripts | Editorial issue report |

**Tell Claude:**
> "Perform final review using `book_editor_review`. Thorough depth. Flag all citation issues as critical."

---

## Quick Reference by Project Type

| Project Type | Synthesis | Drafting | Revision | Polish | Review |
|--------------|-----------|----------|----------|--------|--------|
| **History Book** | research_synthesis | scholarly_narrative | history_editor | micro_enrichment + cohesion | book_editor_review |
| **Philosophy** | research_synthesis | living_thought | general_editor | micro_enrichment + cohesion | book_editor_review |
| **Academic Essay** | research_synthesis | essay_academic | general_editor | micro_enrichment | — |
| **General Nonfiction** | research_synthesis | scholarly_narrative | general_editor | micro_enrichment + cohesion | book_editor_review |

---

## Customizing Prompts

Each prompt has **editable parameters**:

```markdown
## Parameters

| Parameter | Value | Options |
|-----------|-------|---------|
| Style | academic | academic, accessible, literary |
| Audience | educated general | specialist, educated general, general |
| Evidence Threshold | moderate | strict, moderate, speculative |
```

**Options:**
- Edit the prompt file directly
- Copy and create a variant
- Tell Claude to override specific parameters

---

## Creating Custom Prompts

1. Copy `templates/prompt_template.md`
2. Rename to `your_prompt_name.md`
3. Place in the appropriate phase folder
4. Edit to fit your needs

---

## Critical Workflow Notes

### Synthesis is Mandatory (Phase 5)

Never skip synthesis. Drafting directly from raw research causes:
- Context window overflow
- Lost evidence ("lost in the middle")
- Inconsistent citations
- Hallucinated claims

### Drafting Uses Briefs, Not Research (Phase 6)

**Correct:**
> "Draft Chapter 3 using the brief in `briefs/ch03_brief.md`"

**Wrong:**
> "Draft Chapter 3 using the research in `research/ch03_research.md`"

### Bibliography is CLI, Not Prompt (Phase 9)

Bibliography generation is handled by the book compilation command:
```bash
./rdf book projects/books/BOOK_xxx/outline.yaml --compile --include-bibliography
```

This extracts citations from the database, ensuring accuracy.

---

## See Also

- [Writing Project Workflow](../docs/WRITING_PROJECT_WORKFLOW.md) - Complete 9-phase guide
- [Writing Project Phase Guide](../docs/WRITING_PROJECT_PHASE_GUIDE.md) - Claude-guided workflow (Claude prompts you)
- [Agent Workflow](AGENT_WORKFLOW.md) - Technical guide for Claude Code
- [CLI User Guide](../docs/CLI_USER_GUIDE.md) - Command reference
