# Essay Projects

This folder contains essay projects created using the Research Development Framework.

## Creating an Essay

```bash
# Quick start
./rdf essay "Your Topic" --pages 15

# With options
./rdf essay "Your Topic" --pages 20 --style academic --autonomy full
```

## Project Structure

Each essay project follows this structure:

```
ESSAY_[timestamp]_[hash]/
├── outline.yaml              ← Essay configuration
├── research_summary.md       ← Research notes
├── essay_draft.md            ← First draft
├── essay_revised.md          ← Revised version
└── essay_polished.md         ← Final version
```

## Workflow

Essays use `--autonomy full` by default, running to completion without pauses:

1. **Research** - Gather relevant information from library
2. **Draft** - Generate initial essay content
3. **Revise** - Improve structure and flow
4. **Polish** - Final refinement

## See Also

- [Writing Project Workflow](../../docs/WRITING_PROJECT_WORKFLOW.md)
- [Prompt Library](../../prompts/README.md)
