# Writing Project Phase Guide

**For Claude Code Agent Use**

This guide provides phase-by-phase prompts for Claude Code to follow when guiding a user through a complete book or essay project. Claude should move through each phase sequentially, prompting the user for relevant information and decisions at each checkpoint.

**Reference:** See [WRITING_PROJECT_WORKFLOW.md](WRITING_PROJECT_WORKFLOW.md) for detailed explanations of each phase.

---

## How to Use This Guide

When a user initiates a writing project, Claude Code should:

1. Identify the current phase (or start at Phase 1 for new projects)
2. Follow the prompts for that phase
3. Collect user input at each decision point
4. Execute the appropriate CLI commands
5. Present results and request approval before advancing
6. Track progress in `workflow_state.json`

**Initiation Prompt (User says something like):**
> "Help me write a book about [topic]"
> "Start a new writing project"
> "I want to create an essay on [topic]"

---

## Phase 0: Project Initialization

### Claude Prompts to User:

**0.1 Project Type**
> "What type of project would you like to create?
>
> 1. **Book** (multiple chapters, 100+ pages)
> 2. **Long Essay** (single document, 20-50 pages)
> 3. **Short Essay** (single document, 5-20 pages)
>
> Which format fits your vision?"

**0.2 Topic & Scope**
> "What is the topic or subject of your [book/essay]?
>
> Please describe:
> - The main subject or argument
> - Any specific angle or thesis you want to explore
> - The intended audience (academic, general readers, specialists)"

**0.3 Existing Research**
> "Do you have existing research documents to work from?
>
> 1. **Yes** - I have PDFs, documents, or notes to import
> 2. **Partially** - I have some materials but need more research
> 3. **No** - Starting from scratch, will need to gather research
>
> If yes, where are these documents located?"

### Claude Actions:
- Create project directory structure
- Initialize `workflow_state.json` with Phase 1
- If user has documents, proceed to Phase 1 (Ingestion)
- If no documents, note this for Phase 3 (Research)

---

## Phase 1: Document Ingestion

### Entry Condition:
User has documents to ingest, OR skip to Phase 2 if starting from scratch.

### Claude Prompts to User:

**1.1 Document Location**
> "Please place your research documents in the `NEW_DOCS/` folder, or tell me where they're located.
>
> **Supported formats:** PDF, DOCX, DOC, ODT, TXT, MD, HTML, EPUB
>
> Let me know when the documents are ready, or provide the path to your files."

**1.2 Ingestion Confirmation**
> "I found [N] documents ready for ingestion:
> - [List files]
>
> Should I proceed with ingesting these into the library?"

### Claude Actions:
```bash
./rdf ingest NEW_DOCS/ --format json
```

**1.3 Quality Review**
> "Ingestion complete. Here's the summary:
>
> - **Successfully ingested:** [N] documents
> - **Warnings:** [List any quality issues]
> - **Failed:** [List any failures]
>
> [If warnings] Would you like me to assess the flagged documents for quality issues?
>
> Ready to proceed to **Phase 2: Scoping & Structure**?"

### Checkpoint:
- [ ] All documents ingested
- [ ] Quality issues addressed or acknowledged
- [ ] User approves moving to Phase 2

---

## Phase 2: Scoping & Structure

### Claude Prompts to User:

**2.1 Project Parameters**
> "Let's define your project structure. I need a few details:
>
> **For a Book:**
> - How many chapters are you envisioning? (typical: 6-12)
> - Target total page count? (typical: 150-300 pages)
>
> **For an Essay:**
> - Target page count? (typical: 15-50 pages)
>
> **For both:**
> - Writing style: Academic, Accessible Narrative, or Literary?
> - Citation style: Chicago, MLA, APA, or other?"

**2.2 Generate Initial Outline**

### Claude Actions:
```bash
./rdf outline "[Topic]" --chapters [N] --pages [N] --format json
```

**2.3 Outline Review**
> "Here's the initial outline I've generated:
>
> [Display outline.yaml content]
>
> **Please review:**
> - Are these chapter topics in the right order?
> - Should any chapters be split, merged, or removed?
> - Are there missing topics that need chapters?
>
> Tell me any changes you'd like, or approve this outline to proceed."

**2.4 Outline Refinement Loop**

Repeat until user approves:
> "I've updated the outline with your changes:
>
> [Display updated outline]
>
> Does this look right? Any further adjustments?"

**2.5 Chapter Details (For each chapter)**
> "Let's add detail to each chapter. For **Chapter [N]: [Title]**:
>
> - What are the 2-3 key themes or arguments?
> - Any specific sources you know should be used here?
> - Approximate page target for this chapter?
>
> (You can skip details for now and I'll infer from research)"

### Checkpoint:
> "**Phase 2 Complete.** Your outline is finalized:
>
> [Summary of chapters]
>
> **IMPORTANT:** The outline is now locked. Further structural changes will require reorganizing research.
>
> Ready to proceed to **Phase 3: Research Assembly**?"

### Claude Actions:
```bash
git add projects/books/BOOK_xxx/
git commit -m "Phase 2: Finalized outline and project structure"
```

---

## Phase 3: Research Assembly

### Claude Prompts to User:

**3.1 Research Strategy**
> "Now I'll gather research for each chapter. How would you like to proceed?
>
> 1. **Library Only** - Search only your ingested documents (recommended first)
> 2. **Library + Web** - Also search the web for additional sources (requires approval per source)
> 3. **Chapter by Chapter** - Let me research each chapter and show you results before moving on
>
> Which approach?"

**3.2 Chapter Research (For each chapter)**
> "**Researching Chapter [N]: [Title]**
>
> Key themes to search: [List from outline]
>
> Searching your library..."

### Claude Actions:
```bash
./rdf research "[Chapter themes]" --strict -o projects/books/BOOK_xxx/research/ch[N]_research.md
./rdf quotes "[Key topic]" --max 20 --format json
```

**3.3 Research Results**
> "**Research results for Chapter [N]:**
>
> - **Sources found:** [N] relevant documents
> - **Key quotes extracted:** [N]
> - **Coverage:** [Strong/Moderate/Weak]
>
> [If weak coverage]
> This chapter has limited source material. Options:
> 1. Proceed with available sources (will note thin areas)
> 2. Search the web for additional sources
> 3. Add more documents to the library
>
> How would you like to proceed?"

**3.4 Web Research (If selected)**
> "I'll search the web for: [Query]
>
> This will use your Tavily credits. Proceed?"

### Claude Actions:
```bash
./rdf research "[Query]" --allow-web -o projects/books/BOOK_xxx/research/web_research/ch[N]_web.md
```

> "**Web search results:**
>
> [List sources with titles and URLs]
>
> Please review these sources:
> - Which should I include? (List numbers)
> - Which should I reject? (unreliable, off-topic)"

### Checkpoint:
> "**Phase 3 Complete.** Research assembled for all chapters.
>
> **Summary:**
> | Chapter | Sources | Coverage |
> |---------|---------|----------|
> | Ch1 | 12 | Strong |
> | Ch2 | 8 | Moderate |
> | ... | ... | ... |
>
> Ready to proceed to **Phase 4: Gap Analysis**?"

---

## Phase 4: Gap Analysis

### Claude Prompts to User:

**4.1 Analyze Gaps**
> "I'm analyzing research coverage against your outline requirements..."

### Claude Actions:
- Compare research files against outline themes
- Identify missing evidence for key arguments
- Flag chapters with weak coverage

**4.2 Gap Report**
> "**Gap Analysis Report:**
>
> **Chapter 3: [Title]** - 2 gaps identified:
> 1. [Missing topic] - No sources found
> 2. [Weak area] - Only 1 source, needs corroboration
>
> **Chapter 5: [Title]** - 1 gap identified:
> 1. [Missing topic] - No primary sources
>
> **Options for each gap:**
> - **Fill:** Search web for additional sources
> - **Acknowledge:** Proceed with hedged language ("evidence suggests...")
> - **Remove:** Adjust outline to remove this argument
>
> How would you like to handle each gap?"

**4.3 Gap Resolution Loop**

For each gap the user wants to fill:
```bash
./rdf research "[Gap topic]" --allow-web
```

> "Found [N] potential sources for [gap]. Review and approve?"

### Checkpoint:
> "**Phase 4 Complete.** All gaps addressed:
>
> - Filled: [N]
> - Acknowledged (will hedge): [N]
> - Removed from outline: [N]
>
> Ready to proceed to **Phase 5: Synthesis**?"

---

## Phase 5: Synthesis

### Claude Prompts to User:

**5.1 Synthesis Explanation**
> "Now I'll transform raw research into **Chapter Briefs**—structured outlines that map your arguments to specific evidence.
>
> This prevents context overflow when drafting and ensures every claim has a source.
>
> I'll create briefs chapter by chapter. Ready to begin with Chapter 1?"

**5.2 Create Chapter Brief**

### Claude Actions:
- Use `research_synthesis` prompt
- For Ch2+, inject ending of previous chapter (Bridge Strategy)

**5.3 Brief Review (For each chapter)**
> "**Chapter [N] Brief created.**
>
> [Display brief summary]
>
> **Key sections:**
> - Opening hook: [Description]
> - Main arguments: [List with evidence mapping]
> - Thin areas flagged: [List]
>
> **Please review:**
> - Does the argument flow make sense?
> - Should any sections be reordered?
> - Any evidence mapped to the wrong argument?
>
> Approve this brief or request changes?"

**5.4 Bridge Strategy (For Ch2+)**
> "**Transition Strategy for Chapter [N]:**
>
> Chapter [N-1] ends with: [Summary]
>
> I've designed Chapter [N] to open by: [Bridge concept]
>
> Does this transition feel natural? Any adjustments?"

### Checkpoint:
> "**Phase 5 Complete.** All chapter briefs created and approved.
>
> Ready to proceed to **Phase 6: Drafting**?"

---

## Phase 6: Drafting

### Claude Prompts to User:

**6.1 Drafting Style Selection**
> "Which drafting style fits your project best?
>
> 1. **Scholarly Narrative** - Evidence-based, flowing historical narrative
> 2. **Living Thought** - Contemplative, philosophical, organic
> 3. **Academic Essay** - Structured argumentation, thesis-driven
>
> This will be applied to all chapters (you can adjust per-chapter if needed)."

**6.2 Draft Chapter (For each chapter)**
> "**Drafting Chapter [N]: [Title]**
>
> Using: [Selected style] prompt
> Target: [N] pages
> Citations: Markdown footnotes `[^n]`
>
> [For Ch2+] Context injected: Last page of Chapter [N-1]
>
> Generating draft..."

### Claude Actions:
- Use selected drafting prompt
- Work from brief, not raw research
- Inject previous chapter ending for Ch2+
- Enforce `[^n]` citation syntax

**6.3 Draft Review**
> "**Chapter [N] draft complete.** ([N] pages, [N] citations)
>
> **Quick assessment:**
> - All brief sections covered: [Yes/No]
> - Deviations from brief: [List any]
> - Thin areas noted: [List]
>
> Would you like to:
> 1. **Review the full draft** (I'll display it)
> 2. **Request specific changes** (expand section, cut material, adjust tone)
> 3. **Approve and continue** to next chapter
>
> What would you like to do?"

**6.4 Draft Revision Loop**
> "I've made the requested changes:
> - [List changes]
>
> Review again or approve?"

**6.5 Scratchpad Update**
> "While drafting, I noted these cross-chapter issues:
> - [Issue 1]
> - [Issue 2]
>
> I've added these to the project scratchpad for resolution in Phase 7."

### Checkpoint:
> "**Phase 6 Complete.** All chapters drafted.
>
> **Summary:**
> | Chapter | Pages | Citations | Status |
> |---------|-------|-----------|--------|
> | Ch1 | 28 | 34 | Approved |
> | Ch2 | 32 | 41 | Approved |
> | ... | ... | ... | ... |
>
> **Scratchpad issues to address:** [N]
>
> Ready to proceed to **Phase 7: Revision**?"

---

## Phase 7: Revision

### Claude Prompts to User:

**7.1 Pre-Revision Review**
> "Before revising, here are the open scratchpad issues:
>
> [List issues]
>
> I'll address these during revision. Any additional concerns to flag?"

**7.2 Revise Chapter (For each chapter)**
> "**Revising Chapter [N]: [Title]**
>
> Focus areas:
> - Narrative flow and transitions
> - Removing clichés and redundancy
> - Ensuring footnotes do real work
> - Addressing scratchpad issues for this chapter
>
> Revising..."

### Claude Actions:
- Use `history_editor` or `general_editor` prompt
- Address relevant scratchpad items
- Preserve all citations exactly

**7.3 Revision Review**
> "**Chapter [N] revision complete.**
>
> **Changes made:**
> - [Summary of significant changes]
>
> **Scratchpad items resolved:**
> - [List]
>
> Would you like to see a diff of changes, or approve and continue?"

### Checkpoint:
> "**Phase 7 Complete.** All chapters revised.
>
> **Scratchpad status:**
> - Resolved: [N]
> - Remaining: [N] (will address in Handshake Check)
>
> Ready to proceed to **Phase 7.5: Handshake Check**?"

---

## Phase 7.5: Handshake Check

### Claude Prompts to User:

**7.5.1 Explain Handshake Check**
> "Now I'll verify that chapters connect smoothly—ensuring this reads as one book, not separate essays.
>
> I'll check the **ending of each chapter** against the **opening of the next**."

**7.5.2 Check Transitions (For each pair)**
> "**Handshake Check: Chapter [N] → Chapter [N+1]**
>
> **Chapter [N] ends with:**
> [Last 2-3 sentences]
>
> **Chapter [N+1] opens with:**
> [First 2-3 sentences]
>
> **Assessment:**
> - Smoothness: [1-5]
> - Bridge concept: [Description]
> - Issues: [Any problems found]
>
> [If issues found]
> **Suggested fix:** [Specific edit recommendation]
>
> Should I apply this fix, or would you prefer a different approach?"

**7.5.3 Connection Audit Summary**
> "**Full Connection Audit:**
>
> | Transition | Smoothness | Status |
> |------------|------------|--------|
> | Ch1 → Ch2 | 4/5 | Good |
> | Ch2 → Ch3 | 2/5 | Fixed |
> | Ch3 → Ch4 | 5/5 | Excellent |
> | ... | ... | ... |
>
> All transitions now connect smoothly."

### Checkpoint:
> "**Phase 7.5 Complete.** Chapter connections verified.
>
> Ready to proceed to **Phase 8: Polish**?"

---

## Phase 8: Polish

### Claude Prompts to User:

**8.1 Polish Approach**
> "Final polish phase—subtle improvements only. The content is locked.
>
> Polish parameters:
> - Max changes per paragraph: 2
> - Preserve voice and tone
> - No structural changes
>
> Ready to polish Chapter 1?"

**8.2 Polish Approach Selection**
> "How would you like to handle polishing?
>
> 1. **Claude applies suggestions (Default)** - I analyze and apply improvements directly
> 2. **Delegate to internal model** - CLI uses its internal LLM for bulk polishing
>
> Option 1 gives you more control; Option 2 is faster for large manuscripts."

**8.3 Polish Chapter (For each chapter)**
> "**Polishing Chapter [N]**..."

### Claude Actions:

**Option A: Claude applies suggestions (Default)**
```bash
./rdf polish chapter_[N].md --preset academic
# Returns suggestions for Claude to apply
```

**Option B: Delegate to internal model**
```bash
./rdf polish chapter_[N].md --preset academic --use-internal-model
# CLI rewrites text using internal LLM
```

Additional actions:
- Use `micro_enrichment` prompt
- Verify no structural changes
- Track all modifications

**8.4 Polish Summary**
> "**Chapter [N] polished.**
>
> Changes made: [N] minor improvements
> - [List significant changes]
>
> Approve and continue?"

**8.5 Cross-Chapter Cohesion (After all chapters)**
> "Running cohesion check across all chapters...
>
> **Checking:**
> - Terminology consistency
> - Date/fact consistency
> - Cross-reference accuracy
>
> **Results:**
> [List any inconsistencies found]
>
> Should I fix these, or would you like to review first?"

### Checkpoint:
> "**Phase 8 Complete.** All chapters polished and cohesion verified.
>
> Ready to proceed to **Phase 9: Front Matter & Compilation**?"

---

## Phase 9: Front Matter & Compilation

### Claude Prompts to User:

**9.1 Introduction (Written Last)**
> "Now that the body is complete, let's write the **Introduction**.
>
> Based on what we actually wrote, the Introduction should:
> - Preview the arguments we made (not the original outline)
> - Set up the narrative arc
> - Promise only what we delivered
>
> I'll draft the Introduction now. Ready?"

**9.2 Introduction Review**
> "**Introduction draft:**
>
> [Display introduction]
>
> Does this accurately represent the book? Any adjustments?"

**9.3 Front Matter Content**
> "**Front Matter elements needed:**
>
> 1. **Title Page** - I have: [Title] by [Author]. Correct?
> 2. **Dedication** - Would you like to include one? (Optional)
> 3. **Preface/Acknowledgments** - Would you like to write these, or skip?
> 4. **Table of Contents** - I'll generate the structure (page numbers added during export)
>
> Please provide any content for dedication/preface, or indicate to skip."

**9.4 Citation Audit**
> "**Running citation audit...**
>
> Checking all chapters for:
> - Correct `[^n]` syntax
> - No HTML `<sup>` tags
> - No parenthetical citations
> - All references defined
>
> **Results:**
> - Total citations: [N]
> - Issues found: [N]
> - [List any issues]
>
> [If issues] Should I fix these automatically?"

**9.5 Bibliography Generation**
> "Generating bibliography from the library database..."

### Claude Actions:
```bash
./rdf book projects/books/BOOK_xxx/outline.yaml --compile --include-bibliography
```

> "**Bibliography generated:** [N] sources
>
> Would you like to review it?"

**9.5.1 Export Bibliography for Reference Managers**
> "Would you like to export the bibliography for use with reference managers (Zotero, Mendeley, EndNote)?
>
> Available formats:
> 1. **BibTeX** (.bib) - For LaTeX and most reference managers
> 2. **RIS** (.ris) - For EndNote, Zotero, Mendeley
> 3. **CSL-JSON** (.json) - For Pandoc and Zotero
>
> Which format(s) would you like?"

### Claude Actions:
```bash
# Export as BibTeX
./rdf export bibliography --project BOOK_xxx --format bibtex --output refs.bib

# Export as RIS
./rdf export bibliography --project BOOK_xxx --format ris --output refs.ris

# Export as CSL-JSON
./rdf export bibliography --project BOOK_xxx --format csl-json --output refs.json

# Optional: Validate sources first
./rdf export bibliography --project BOOK_xxx --validate
```

> "**Bibliography exported:**
> - Format: [Selected format]
> - Location: [File path]
> - Sources: [N]
>
> You can import this file directly into Zotero, Mendeley, or your reference manager."

**9.6 Editor-in-Chief Review**
> "**Running Editor-in-Chief review...**
>
> Evaluating:
> - The Arc: Does the book fulfill the Introduction's promise?
> - Pacing: Any sluggish chapters?
> - Conclusion: Synthesis or mere summary?
> - Narrative cohesion: One book or essays stitched together?
>
> **Developmental Notes:**
> [Report]
>
> [If critical issues] These should be addressed before final export. Proceed anyway or make fixes?"

**9.7 Export Configuration**
> "**Final Export Settings:**
>
> 1. **Citation style:**
>    - Endnotes (back of book) - typical for Chicago
>    - Footnotes (bottom of page) - academic papers
>    - Chapter endnotes (end of each chapter)
>
> 2. **Output formats:**
>    - PDF (final, with page numbers)
>    - DOCX (for further editing)
>    - Markdown (archival)
>
> Which configuration?"

**9.8 Final Export**
### Claude Actions:
```bash
./rdf book projects/books/BOOK_xxx/outline.yaml --compile --endnotes --format pdf
```

> "**Export complete!**
>
> Your finished manuscript is at:
> `projects/books/BOOK_xxx/compiled/final/BOOK_TITLE.pdf`
>
> **Final Statistics:**
> - Total pages: [N]
> - Total chapters: [N]
> - Total citations: [N]
> - Total sources: [N]
>
> Congratulations on completing your book!"

### Final Git Checkpoint:
```bash
git add projects/books/BOOK_xxx/
git commit -m "Phase 9: Final manuscript compiled and exported"
git tag -a "v1.0-manuscript" -m "First complete manuscript"
```

---

## Phase Navigation Commands

Users can jump to specific phases:

| Command | Action |
|---------|--------|
| "Show current phase" | Display current phase and progress |
| "Go to Phase [N]" | Jump to specific phase |
| "Show scratchpad" | Display cross-chapter issues |
| "Show outline" | Display current outline |
| "Show chapter [N] brief" | Display specific chapter brief |
| "Restart phase [N]" | Re-run current phase from beginning |

---

## Error Recovery

If a phase fails or user wants to backtrack:

**Outline Changes After Phase 2:**
> "Changing the outline after research is organized will require re-running Phases 3-5. Are you sure you want to modify the outline?"

**Draft Rejected:**
> "I'll regenerate the draft with your feedback. What specific changes should I make?"

**Gap Cannot Be Filled:**
> "This gap cannot be filled from available sources. Options:
> 1. Proceed with hedged language
> 2. Remove this argument from the outline
> 3. Provide additional documents to ingest"

---

## Session Resumption

When resuming a project, Claude Code should first load context:

### Claude Actions:
```bash
# Get comprehensive context packet for warm-start
./rdf context BOOK_xxx --format json
```

This returns current phase, progress, recent activity, pending decisions, and blocking items.

### Claude Prompts to User:

> "Welcome back! Your project **[Title]** is at **Phase [N]: [Name]**.
>
> **Progress:** [X]% complete
> **Last action:** [Description]
> **Blocking items:** [N items in queue]
> **Next step:** [Description]
>
> [If blocking items exist]
> There are [N] items awaiting your review in the queue. Would you like to address those first, or continue with [next step]?
>
> Ready to continue?"

---

## Quick Reference: Phase Summary

| Phase | Purpose | Key Outputs |
|-------|---------|-------------|
| 0 | Initialize | Project directory |
| 1 | Ingest | Documents in library |
| 2 | Scope | Finalized outline |
| 3 | Research | Research files per chapter |
| 4 | Gap Analysis | Gap report, filled gaps |
| 5 | Synthesis | Chapter briefs |
| 6 | Drafting | Draft chapters |
| 7 | Revision | Revised chapters |
| 7.5 | Handshake | Connected transitions |
| 8 | Polish | Polished chapters |
| 9 | Compile | Final manuscript |

---

## See Also

- [WRITING_PROJECT_WORKFLOW.md](WRITING_PROJECT_WORKFLOW.md) - Detailed phase explanations
- [Prompt Library](../prompts/README.md) - All available prompts
- [CLI User Guide](CLI_USER_GUIDE.md) - Command reference
